/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import com.glodblock.github.client.gui.GuiFluidCraftConfirm;
import com.glodblock.github.client.gui.GuiItemMonitor;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public class SPacketMEItemInvUpdate
implements IMessage {
    private List<IAEItemStack> list = new ArrayList<IAEItemStack>();
    private byte ref = 0;
    private boolean resort = true;

    public SPacketMEItemInvUpdate() {
    }

    public SPacketMEItemInvUpdate(byte b) {
        this.ref = b;
    }

    public SPacketMEItemInvUpdate(boolean resort) {
        this.resort = resort;
    }

    public void fromBytes(ByteBuf buf) {
        this.ref = buf.readByte();
        this.resort = buf.readBoolean();
        int amount = buf.readInt();
        this.list = new ArrayList<IAEItemStack>(amount);
        try {
            for (int i = 0; i < amount; ++i) {
                this.list.add(AEItemStack.loadItemStackFromPacket((ByteBuf)buf));
            }
        }
        catch (Exception io) {
            System.out.println("Error handling payload w/ " + amount + " items.");
            io.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte((int)this.ref);
        buf.writeBoolean(this.resort);
        buf.writeInt(this.list.size());
        try {
            for (IAEItemStack is : this.list) {
                is.writeToPacket(buf);
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public void setResort(boolean resort) {
        this.resort = resort;
    }

    public void appendItem(IAEItemStack is) {
        this.list.add(is);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public static class Handler
    implements IMessageHandler<SPacketMEItemInvUpdate, IMessage> {
        public IMessage onMessage(SPacketMEItemInvUpdate message, MessageContext ctx) {
            GuiScreen gs = Minecraft.func_71410_x().field_71462_r;
            if (gs instanceof GuiItemMonitor) {
                ((GuiItemMonitor)gs).postUpdate(message.list, message.resort);
            } else if (gs instanceof GuiFluidCraftConfirm) {
                ((GuiFluidCraftConfirm)gs).postUpdate(message.list, message.ref);
            }
            return null;
        }
    }
}

