/*
 * Decompiled with CFR 0.152.
 */
package bartworks.system.material;

import bartworks.system.material.TileEntityMetaGeneratedBlock;
import bartworks.system.material.Werkstoff;
import bartworks.system.material.WerkstoffLoader;
import gregtech.GTMod;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TextureSet;
import gregtech.api.interfaces.ITexture;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTOreDictUnificator;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class BWTileEntityMetaGeneratedOre
extends TileEntityMetaGeneratedBlock {
    protected static boolean shouldFortune = false;
    protected static boolean shouldSilkTouch = false;
    public boolean mNatural = false;

    @Override
    public void func_145839_a(NBTTagCompound aNBT) {
        super.func_145839_a(aNBT);
        this.mNatural = aNBT.func_74767_n("n");
    }

    @Override
    public void func_145841_b(NBTTagCompound aNBT) {
        super.func_145841_b(aNBT);
        aNBT.func_74757_a("n", this.mNatural);
    }

    @Override
    public ITexture[] getTexture(Block aBlock, ForgeDirection side) {
        Werkstoff aMaterial = Werkstoff.werkstoffHashMap.get(this.mMetaData);
        if (aMaterial != null) {
            ITexture aIconSet = TextureFactory.of(aMaterial.getTexSet().mTextures[OrePrefixes.ore.mTextureIndex], aMaterial.getRGBA());
            return new ITexture[]{TextureFactory.of(Blocks.field_150348_b), aIconSet};
        }
        return new ITexture[]{TextureFactory.of(Blocks.field_150348_b), TextureFactory.of(TextureSet.SET_NONE.mTextures[OrePrefixes.ore.mTextureIndex])};
    }

    @Override
    protected Block GetProperBlock() {
        return WerkstoffLoader.BWOres;
    }

    @Override
    public ArrayList<ItemStack> getDrops(int aFortune) {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        if (this.mMetaData <= 0) {
            rList.add(new ItemStack(Blocks.field_150347_e, 1, 0));
            return rList;
        }
        Materials aOreMaterial = Werkstoff.werkstoffHashMap.get(this.mMetaData).getBridgeMaterial();
        if (shouldSilkTouch) {
            rList.add(new ItemStack(this.GetProperBlock(), 1, (int)this.mMetaData));
        } else {
            switch (GTMod.proxy.oreDropSystem) {
                case Item: {
                    rList.add(GTOreDictUnificator.get(OrePrefixes.rawOre, aOreMaterial, 1L));
                    break;
                }
                case FortuneItem: {
                    if (shouldFortune && this.mNatural && aFortune > 0) {
                        int aMinAmount = 1;
                        if (aFortune > 3) {
                            aFortune = 3;
                        }
                        long amount = (long)new Random().nextInt(aFortune) + (long)aMinAmount;
                        int i = 0;
                        while ((long)i < amount) {
                            rList.add(GTOreDictUnificator.get(OrePrefixes.rawOre, aOreMaterial, 1L));
                            ++i;
                        }
                        break;
                    }
                    rList.add(GTOreDictUnificator.get(OrePrefixes.rawOre, aOreMaterial, 1L));
                    break;
                }
                case UnifiedBlock: 
                case PerDimBlock: 
                case Block: {
                    rList.add(new ItemStack(this.GetProperBlock(), 1, (int)this.mMetaData));
                }
            }
        }
        return rList;
    }
}

