/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.logic;

import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.tileentity.IRecipeLockable;
import gregtech.api.interfaces.tileentity.IVoidable;
import gregtech.api.objects.GTDualInputPattern;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SingleRecipeCheck;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.OverclockCalculator;
import gregtech.api.util.ParallelHelper;
import gregtech.common.tileentities.machines.IDualInputInventoryWithPattern;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ProcessingLogic {
    protected IVoidable machine;
    protected IRecipeLockable recipeLockableMachine;
    protected boolean isRecipeLocked;
    protected ItemStack[] inputItems;
    protected FluidStack[] inputFluids;
    protected ItemStack specialSlotItem;
    protected int maxParallel = 1;
    protected Supplier<Integer> maxParallelSupplier;
    protected int batchSize = 1;
    protected Supplier<RecipeMap<?>> recipeMapSupplier;
    protected double euModifier = 1.0;
    protected double speedBoost = 1.0;
    protected long availableVoltage;
    protected long availableAmperage;
    protected int maxTierSkips = 1;
    protected boolean protectItems;
    protected boolean protectFluids;
    protected double overClockTimeReduction = 2.0;
    protected double overClockPowerIncrease = 4.0;
    protected boolean amperageOC = true;
    protected boolean recipeCaching = true;
    protected ItemStack[] outputItems;
    protected FluidStack[] outputFluids;
    protected long calculatedEut;
    protected int duration;
    protected int calculatedParallels = 0;
    protected RecipeMap<?> lastRecipeMap;
    protected GTRecipe lastRecipe;
    protected IDualInputInventoryWithPattern activeDualInv;
    protected Map<IDualInputInventoryWithPattern, Set<GTRecipe>> dualInvWithPatternToRecipeCache = new HashMap<IDualInputInventoryWithPattern, Set<GTRecipe>>();

    public ProcessingLogic setMachine(IVoidable machine) {
        this.machine = machine;
        return this;
    }

    public ProcessingLogic setRecipeLocking(IRecipeLockable recipeLockableMachine, boolean isRecipeLocked) {
        this.recipeLockableMachine = recipeLockableMachine;
        this.isRecipeLocked = isRecipeLocked;
        return this;
    }

    @Nonnull
    public ProcessingLogic setInputItems(ItemStack ... itemInputs) {
        this.inputItems = itemInputs;
        return this;
    }

    @Nonnull
    public ProcessingLogic setInputItems(List<ItemStack> itemInputs) {
        this.inputItems = itemInputs.toArray(new ItemStack[0]);
        return this;
    }

    @Nonnull
    public ProcessingLogic setInputFluids(FluidStack ... fluidInputs) {
        this.inputFluids = fluidInputs;
        return this;
    }

    @Nonnull
    public ProcessingLogic setInputFluids(List<FluidStack> fluidInputs) {
        this.inputFluids = fluidInputs.toArray(new FluidStack[0]);
        return this;
    }

    public ProcessingLogic setSpecialSlotItem(ItemStack specialSlotItem) {
        this.specialSlotItem = specialSlotItem;
        return this;
    }

    public boolean tryCachePossibleRecipesFromPattern(IDualInputInventoryWithPattern inv) {
        if (!inv.shouldBeCached()) {
            return true;
        }
        if (this.dualInvWithPatternToRecipeCache.containsKey(inv)) {
            this.activeDualInv = inv;
            return true;
        }
        GTDualInputPattern inputs = inv.getPatternInputs();
        this.setInputItems(inputs.inputItems);
        this.setInputFluids(inputs.inputFluid);
        Set recipes = this.findRecipeMatches(this.getCurrentRecipeMap()).collect(Collectors.toCollection(LinkedHashSet::new));
        this.setInputItems(new ItemStack[0]);
        this.setInputFluids(new FluidStack[0]);
        if (!recipes.isEmpty()) {
            this.dualInvWithPatternToRecipeCache.put(inv, recipes);
            this.activeDualInv = inv;
            return true;
        }
        return false;
    }

    public void removeInventoryRecipeCache(IDualInputInventoryWithPattern inv) {
        this.dualInvWithPatternToRecipeCache.remove(inv);
    }

    public ProcessingLogic setMaxParallel(int maxParallel) {
        this.maxParallel = maxParallel;
        return this;
    }

    public ProcessingLogic setMaxParallelSupplier(Supplier<Integer> supplier) {
        this.maxParallelSupplier = supplier;
        return this;
    }

    public ProcessingLogic setBatchSize(int size) {
        this.batchSize = size;
        return this;
    }

    public ProcessingLogic setRecipeMap(RecipeMap<?> recipeMap) {
        return this.setRecipeMapSupplier(() -> recipeMap);
    }

    public ProcessingLogic setRecipeMapSupplier(Supplier<RecipeMap<?>> supplier) {
        this.recipeMapSupplier = supplier;
        return this;
    }

    public ProcessingLogic setEuModifier(double modifier) {
        this.euModifier = modifier;
        return this;
    }

    public ProcessingLogic setSpeedBonus(double speedModifier) {
        this.speedBoost = speedModifier;
        return this;
    }

    public ProcessingLogic setAvailableVoltage(long voltage) {
        this.availableVoltage = voltage;
        return this;
    }

    public ProcessingLogic setAvailableAmperage(long amperage) {
        this.availableAmperage = amperage;
        return this;
    }

    public ProcessingLogic setMaxTierSkips(int tierSkips) {
        this.maxTierSkips = tierSkips;
        return this;
    }

    public ProcessingLogic setUnlimitedTierSkips() {
        this.maxTierSkips = Integer.MAX_VALUE;
        return this;
    }

    public ProcessingLogic setVoidProtection(boolean protectItems, boolean protectFluids) {
        this.protectItems = protectItems;
        this.protectFluids = protectFluids;
        return this;
    }

    public ProcessingLogic setOverclock(double timeReduction, double powerIncrease) {
        this.overClockTimeReduction = timeReduction;
        this.overClockPowerIncrease = powerIncrease;
        return this;
    }

    public ProcessingLogic enablePerfectOverclock() {
        return this.setOverclock(4.0, 4.0);
    }

    public ProcessingLogic setAmperageOC(boolean amperageOC) {
        this.amperageOC = amperageOC;
        return this;
    }

    public ProcessingLogic noRecipeCaching() {
        this.recipeCaching = false;
        return this;
    }

    public ProcessingLogic overwriteOutputItems(ItemStack ... itemOutputs) {
        this.outputItems = itemOutputs;
        return this;
    }

    public ProcessingLogic overwriteOutputFluids(FluidStack ... fluidOutputs) {
        this.outputFluids = fluidOutputs;
        return this;
    }

    public ProcessingLogic overwriteCalculatedEut(long calculatedEut) {
        this.calculatedEut = calculatedEut;
        return this;
    }

    public ProcessingLogic overwriteCalculatedDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public ProcessingLogic clear() {
        this.inputItems = null;
        this.inputFluids = null;
        this.specialSlotItem = null;
        this.outputItems = null;
        this.outputFluids = null;
        this.calculatedEut = 0L;
        this.duration = 0;
        this.calculatedParallels = 0;
        this.activeDualInv = null;
        return this;
    }

    protected RecipeMap<?> getCurrentRecipeMap() {
        RecipeMap<?> recipeMap = this.recipeMapSupplier == null ? null : this.recipeMapSupplier.get();
        if (this.lastRecipeMap != recipeMap) {
            if (this.lastRecipeMap != null) {
                this.dualInvWithPatternToRecipeCache.clear();
            }
            this.lastRecipe = null;
            this.lastRecipeMap = recipeMap;
        }
        return recipeMap;
    }

    @Nonnull
    public CheckRecipeResult process() {
        RecipeMap<?> recipeMap = this.getCurrentRecipeMap();
        if (this.maxParallelSupplier != null) {
            this.maxParallel = this.maxParallelSupplier.get();
        }
        if (this.inputItems == null) {
            this.inputItems = GTValues.emptyItemStackArray;
        }
        if (this.inputFluids == null) {
            this.inputFluids = GTValues.emptyFluidStackArray;
        }
        if (this.activeDualInv != null) {
            Set<GTRecipe> matchedRecipes = this.dualInvWithPatternToRecipeCache.get(this.activeDualInv);
            for (GTRecipe matchedRecipe : matchedRecipes) {
                if (matchedRecipe.maxParallelCalculatedByInputs(1, this.inputFluids, this.inputItems) != 1.0) continue;
                CalculationResult foundResult = this.validateAndCalculateRecipe(matchedRecipe);
                return foundResult.checkRecipeResult;
            }
            this.activeDualInv = null;
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        if (this.isRecipeLocked && this.recipeLockableMachine != null && this.recipeLockableMachine.getSingleRecipeCheck() != null) {
            SingleRecipeCheck singleRecipeCheck = this.recipeLockableMachine.getSingleRecipeCheck();
            if (singleRecipeCheck.checkRecipeInputs(false, 1, this.inputItems, this.inputFluids) == 0) {
                return CheckRecipeResultRegistry.NO_RECIPE;
            }
            return this.validateAndCalculateRecipe((GTRecipe)this.recipeLockableMachine.getSingleRecipeCheck().getRecipe()).checkRecipeResult;
        }
        Stream<GTRecipe> matchedRecipes = this.findRecipeMatches(recipeMap);
        Iterable recipeIterable = matchedRecipes::iterator;
        CheckRecipeResult checkRecipeResult = CheckRecipeResultRegistry.NO_RECIPE;
        for (GTRecipe matchedRecipe : recipeIterable) {
            CalculationResult foundResult = this.validateAndCalculateRecipe(matchedRecipe);
            if (foundResult.successfullyConsumedInputs) {
                return foundResult.checkRecipeResult;
            }
            if (foundResult.checkRecipeResult == CheckRecipeResultRegistry.NO_RECIPE) continue;
            checkRecipeResult = foundResult.checkRecipeResult;
        }
        return checkRecipeResult;
    }

    @Nonnull
    private CalculationResult validateAndCalculateRecipe(@Nonnull GTRecipe recipe) {
        CheckRecipeResult result = this.validateRecipe(recipe);
        if (!result.wasSuccessful()) {
            return CalculationResult.ofFailure(result);
        }
        ParallelHelper helper = this.createParallelHelper(recipe);
        OverclockCalculator calculator = this.createOverclockCalculator(recipe);
        helper.setCalculator(calculator);
        helper.build();
        if (!helper.getResult().wasSuccessful()) {
            return CalculationResult.ofFailure(helper.getResult());
        }
        return CalculationResult.ofSuccess(this.applyRecipe(recipe, helper, calculator, result));
    }

    @Nonnull
    protected CheckRecipeResult applyRecipe(@Nonnull GTRecipe recipe, @Nonnull ParallelHelper helper, @Nonnull OverclockCalculator calculator, @Nonnull CheckRecipeResult result) {
        this.lastRecipe = recipe.mCanBeBuffered ? recipe : null;
        this.calculatedParallels = helper.getCurrentParallel();
        if (calculator.getConsumption() == Long.MAX_VALUE) {
            return CheckRecipeResultRegistry.POWER_OVERFLOW;
        }
        if (calculator.getDuration() == Integer.MAX_VALUE) {
            return CheckRecipeResultRegistry.DURATION_OVERFLOW;
        }
        this.calculatedEut = calculator.getConsumption();
        double finalDuration = this.calculateDuration(recipe, helper, calculator);
        if (finalDuration >= 2.147483647E9) {
            return CheckRecipeResultRegistry.DURATION_OVERFLOW;
        }
        this.duration = (int)finalDuration;
        CheckRecipeResult hookResult = this.onRecipeStart(recipe);
        if (!hookResult.wasSuccessful()) {
            return hookResult;
        }
        this.outputItems = helper.getItemOutputs();
        this.outputFluids = helper.getFluidOutputs();
        return result;
    }

    protected double calculateDuration(@Nonnull GTRecipe recipe, @Nonnull ParallelHelper helper, @Nonnull OverclockCalculator calculator) {
        return (double)calculator.getDuration() * helper.getDurationMultiplierDouble();
    }

    @Nonnull
    protected Stream<GTRecipe> findRecipeMatches(@Nullable RecipeMap<?> map) {
        if (map == null) {
            return Stream.empty();
        }
        return map.findRecipeQuery().caching(this.recipeCaching).items(this.inputItems).fluids(this.inputFluids).specialSlot(this.specialSlotItem).cachedRecipe(this.lastRecipe).findAll();
    }

    @Nonnull
    protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    @Nonnull
    protected ParallelHelper createParallelHelper(@Nonnull GTRecipe recipe) {
        return new ParallelHelper().setRecipe(recipe).setItemInputs(this.inputItems).setFluidInputs(this.inputFluids).setAvailableEUt(this.availableVoltage * this.availableAmperage).setMachine(this.machine, this.protectItems, this.protectFluids).setRecipeLocked(this.recipeLockableMachine, this.isRecipeLocked).setMaxParallel(this.maxParallel).setEUtModifier(this.euModifier).enableBatchMode(this.batchSize).setConsumption(true).setOutputCalculation(true);
    }

    @Nonnull
    protected OverclockCalculator createOverclockCalculator(@Nonnull GTRecipe recipe) {
        return new OverclockCalculator().setRecipeEUt(recipe.mEUt).setAmperage(this.availableAmperage).setEUt(this.availableVoltage).setMaxTierSkips(this.maxTierSkips).setDuration(recipe.mDuration).setDurationModifier(this.speedBoost).setEUtDiscount(this.euModifier).setAmperageOC(this.amperageOC).setDurationDecreasePerOC(this.overClockTimeReduction).setEUtIncreasePerOC(this.overClockPowerIncrease);
    }

    @Nonnull
    protected CheckRecipeResult onRecipeStart(@Nonnull GTRecipe recipe) {
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    public ItemStack[] getOutputItems() {
        return this.outputItems;
    }

    public FluidStack[] getOutputFluids() {
        return this.outputFluids;
    }

    public int getDuration() {
        return this.duration;
    }

    public long getCalculatedEut() {
        return this.calculatedEut;
    }

    public int getCurrentParallels() {
        return this.calculatedParallels;
    }

    protected static final class CalculationResult {
        public final boolean successfullyConsumedInputs;
        public final CheckRecipeResult checkRecipeResult;

        public static CalculationResult ofSuccess(CheckRecipeResult checkRecipeResult) {
            return new CalculationResult(true, checkRecipeResult);
        }

        public static CalculationResult ofFailure(CheckRecipeResult checkRecipeResult) {
            return new CalculationResult(false, checkRecipeResult);
        }

        private CalculationResult(boolean successfullyConsumedInputs, CheckRecipeResult checkRecipeResult) {
            this.successfullyConsumedInputs = successfullyConsumedInputs;
            this.checkRecipeResult = checkRecipeResult;
        }
    }
}

