/*
 * Decompiled with CFR 0.152.
 */
package gtnhlanth.common.tileentity.recipe.beamline;

import gtnhlanth.common.beamline.Particle;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class SourceChamberMetadata {
    public final int particleID;
    public final int rate;
    public final float maxEnergy;
    public final float focus;
    public final float energyRatio;

    private SourceChamberMetadata(int particleID, int rate, float maxEnergy, float focus, float energyRatio) {
        this.particleID = particleID;
        this.rate = rate;
        this.maxEnergy = maxEnergy;
        this.focus = focus;
        this.energyRatio = energyRatio;
    }

    public int hashCode() {
        return Objects.hash(this.particleID, this.rate, Float.valueOf(this.maxEnergy), Float.valueOf(this.focus), Float.valueOf(this.energyRatio));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceChamberMetadata that = (SourceChamberMetadata)o;
        if (this.particleID != that.particleID) {
            return false;
        }
        if (this.rate != that.rate) {
            return false;
        }
        if (this.maxEnergy != that.maxEnergy) {
            return false;
        }
        if (this.focus != that.focus) {
            return false;
        }
        return this.energyRatio == that.energyRatio;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("particleID", this.particleID).append("rate", this.rate).append("maxEnergy", this.maxEnergy).append("focus", this.focus).append("energyRatio", this.energyRatio).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int particleID;
        private int rate;
        private float maxEnergy;
        private float focus;
        private float energyRatio;

        private Builder() {
        }

        public Builder particleID(int particleID) {
            if (particleID < 0 || particleID >= Particle.VALUES.length) {
                throw new IllegalArgumentException("'particleID' must be within bounds for the Particle enum!");
            }
            this.particleID = particleID;
            return this;
        }

        public Builder rate(int rate) {
            if (rate <= 0) {
                throw new IllegalArgumentException("'rate' must be greater than zero!");
            }
            this.rate = rate;
            return this;
        }

        public Builder energy(float maxEnergy, float energyRatio) {
            if (maxEnergy <= 0.0f) {
                throw new IllegalArgumentException("'maxEnergy' must be greater than zero!");
            }
            if (energyRatio <= 0.0f) {
                throw new IllegalArgumentException("'energyRatio' must be greater than zero!");
            }
            this.maxEnergy = maxEnergy;
            this.energyRatio = energyRatio;
            return this;
        }

        public Builder focus(float focus) {
            if (focus <= 0.0f) {
                throw new IllegalArgumentException("'focus' must be greater than zero!");
            }
            this.focus = focus;
            return this;
        }

        public SourceChamberMetadata build() {
            return new SourceChamberMetadata(this.particleID, this.rate, this.maxEnergy, this.focus, this.energyRatio);
        }
    }
}

