/*
 * Decompiled with CFR 0.152.
 */
package kekztech.common.tileentities;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import kekztech.common.Blocks;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MTESOFuelCellMK1
extends MTEEnhancedMultiBlockBase<MTESOFuelCellMK1> {
    private final int OXYGEN_PER_SEC = 100;
    private final int EU_PER_TICK = 2048;
    private final int STEAM_PER_SEC = 20000;
    private int mCasing = 0;
    private static final int CASING_TEXTURE_ID = 49;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTESOFuelCellMK1> STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccc", "ccc", "ccc", "ccc", "ccc"}, {"c~c", "geg", "geg", "geg", "cdc"}, {"ccc", "ccc", "ccc", "ccc", "ccc"}})).addElement('c', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(te -> ++te.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addInputToMachineList, 49, 1), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addMaintenanceToMachineList, 49, 1), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addOutputToMachineList, 49, 1)})).addElement('d', GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addDynamoToMachineList, 49, 1)).addElement('g', StructureUtility.ofBlockAnyMeta((Block)GameRegistry.findBlock((String)"IC2", (String)"blockAlloyGlass"))).addElement('e', StructureUtility.ofBlockAnyMeta((Block)Blocks.yszUnit)).build();

    public MTESOFuelCellMK1(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTESOFuelCellMK1(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity var1) {
        return new MTESOFuelCellMK1(this.mName);
    }

    @Override
    public boolean supportsPowerPanel() {
        return false;
    }

    @Override
    public IStructureDefinition<MTESOFuelCellMK1> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Gas Turbine").addInfo("Oxidizes gas fuels to generate electricity without polluting the environment").addInfo("Consumes up to " + GTUtility.formatNumbers(40960L) + "EU worth of fuel with up to 100% efficiency each second").addInfo("Steam production requires the SOFC to heat up completely first").addInfo("Outputs 2048EU/t and 20000L/s Steam").addInfo("Additionally, requires 100L/s Oxygen gas").beginStructureBlock(3, 3, 5, false).addController("Front center").addCasingInfoMin("Clean Stainless Steel Casing", 12, false).addOtherStructurePart("YSZ Ceramic Electrolyte Unit", "3x, Center 1x1x3").addOtherStructurePart("Reinforced Glass", "6x, touching the electrolyte units on the horizontal sides").addDynamoHatch("Back center", 1).addMaintenanceHatch("Any casing").addInputHatch("Fuel, any casing").addInputHatch("Oxygen, any casing").addOutputHatch("Steam, any casing").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49)};
    }

    @Override
    @Nonnull
    public CheckRecipeResult checkProcessing() {
        ArrayList<FluidStack> storedFluids = super.getStoredFluids();
        Collection<GTRecipe> recipeList = RecipeMaps.gasTurbineFuels.getAllRecipes();
        for (FluidStack hatchFluid : storedFluids) {
            for (GTRecipe aFuel : recipeList) {
                FluidStack liquid = GTUtility.getFluidForFilledItem(aFuel.getRepresentativeInput(0), true);
                if (liquid == null || !hatchFluid.isFluidEqual(liquid)) continue;
                liquid.amount = 40960 / aFuel.mSpecialValue;
                if (!super.depleteInput(liquid)) continue;
                if (!super.depleteInput(Materials.Oxygen.getGas(100L))) {
                    this.mEUt = 0;
                    this.mEfficiency = 0;
                    return CheckRecipeResultRegistry.NO_FUEL_FOUND;
                }
                this.mEUt = 2048;
                this.mMaxProgresstime = 20;
                this.mEfficiencyIncrease = 40;
                if (this.mEfficiency == this.getMaxEfficiency(null)) {
                    super.addOutput(Materials.Steam.getGas(20000L));
                }
                return CheckRecipeResultRegistry.GENERATING;
            }
        }
        this.mEUt = 0;
        this.mEfficiency = 0;
        return CheckRecipeResultRegistry.NO_FUEL_FOUND;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity thisController, ItemStack guiSlotItem) {
        this.mCasing = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 1, 0)) {
            return false;
        }
        return this.mCasing >= 12 && this.mMaintenanceHatches.size() == 1 && this.mInputHatches.size() >= 2;
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 1, 1, 0);
    }

    @Override
    public boolean showRecipeTextInGUI() {
        return false;
    }
}

