/*
 * Decompiled with CFR 0.152.
 */
package mantle.module;

import cpw.mods.fml.common.Loader;
import java.io.File;
import java.util.ArrayList;
import mantle.module.ILoadableModule;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class ModuleController {
    private ArrayList<ILoadableModule> modules = new ArrayList();
    private State currentState = State.WAITING;
    private Logger logger;
    private Configuration config;

    public ModuleController(String modName) {
        this.logger = LogManager.getLogger((String)(modName + "-ModuleController"));
        this.config = null;
    }

    public ModuleController(String confName, String modName) {
        this.logger = LogManager.getLogger((String)(modName + "-ModuleController"));
        this.config = new Configuration(new File(Loader.instance().getConfigDir().toString() + File.separator + confName));
    }

    public void preInit() {
        this.currentState = State.PREINIT;
        for (ILoadableModule m : this.modules) {
            m.preInit();
        }
    }

    public void init() {
        this.currentState = State.INIT;
        for (ILoadableModule m : this.modules) {
            m.init();
        }
    }

    public void postInit() {
        this.currentState = State.POSTINIT;
        for (ILoadableModule m : this.modules) {
            m.postInit();
        }
        this.currentState = State.DONE;
    }

    public boolean registerModule(Class<? extends ILoadableModule> mod) {
        String mID = this.getModId(mod);
        if (mID == null) {
            return false;
        }
        boolean allowedByConf = true;
        if (this.config != null) {
            this.config.load();
            allowedByConf = this.config.get("Modules", mID, true).getBoolean(true);
            this.config.save();
        }
        if (!allowedByConf || !Loader.isModLoaded((String)mID)) {
            return false;
        }
        return this.doSetup(mod, mID);
    }

    public boolean registerUncheckedModule(Class<? extends ILoadableModule> mod) {
        String mID = this.getModId(mod);
        if (mID == null || !Loader.isModLoaded((String)mID)) {
            return false;
        }
        return this.doSetup(mod, mID);
    }

    private String getModId(Class<? extends ILoadableModule> mod) {
        String mID;
        try {
            mID = (String)mod.getField("modId").get(null);
        }
        catch (Exception e) {
            this.logger.error("Module loading failed for class " + mod + "; modId field may be missing.");
            return null;
        }
        catch (NoClassDefFoundError ncdf) {
            this.logger.error("Module loading failed for class " + mod + "; a referenced class is missing.");
            return null;
        }
        return mID;
    }

    private boolean doSetup(Class<? extends ILoadableModule> mod, String mID) {
        ILoadableModule module;
        try {
            module = mod.newInstance();
            this.modules.add(module);
        }
        catch (Exception e) {
            this.logger.error("Could not construct module for " + mID);
            this.logger.error(e.getMessage());
            this.logger.error((Object)e.getStackTrace());
            return false;
        }
        this.logger.info("Module for " + mID + " loaded successfully.");
        boolean caughtUp = false;
        switch (this.currentState) {
            case DONE: 
            case POSTINIT: {
                module.preInit();
                module.init();
                module.postInit();
                caughtUp = true;
                break;
            }
            case INIT: {
                module.preInit();
                module.init();
                caughtUp = true;
                break;
            }
            case PREINIT: {
                module.preInit();
                caughtUp = true;
                break;
            }
        }
        if (caughtUp) {
            this.logger.info("Completed catch-up for " + mID + " module.");
        }
        return true;
    }

    private static enum State {
        WAITING,
        PREINIT,
        INIT,
        POSTINIT,
        DONE;

    }
}

