/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import logisticspipes.interfaces.IRequestWatcher;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.orderer.ComponentList;
import logisticspipes.network.packets.orderer.MissingItems;
import logisticspipes.network.packets.orderer.OrdererContent;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.RequestLog;
import logisticspipes.request.RequestTree;
import logisticspipes.request.resources.IResource;
import logisticspipes.routing.order.LinkedLogisticsOrderList;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class RequestHandler {
    public static void request(final EntityPlayer player, ItemIdentifierStack stack, final CoreRoutedPipe pipe) {
        if (!pipe.useEnergy(5)) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("lp.misc.noenergy", new Object[0]));
            return;
        }
        RequestTree.request(stack.clone(), pipe, new RequestLog(){

            @Override
            public void handleMissingItems(List<IResource> resources) {
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(MissingItems.class).setItems(resources).setFlag(true), player);
            }

            @Override
            public void handleSucessfullRequestOf(IResource item, LinkedLogisticsOrderList parts) {
                ArrayList<IResource> coll = new ArrayList<IResource>(1);
                coll.add(item);
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(MissingItems.class).setItems(coll).setFlag(false), player);
                if (pipe instanceof IRequestWatcher) {
                    ((IRequestWatcher)((Object)pipe)).handleOrderList(item, parts);
                }
            }

            @Override
            public void handleSucessfullRequestOfList(List<IResource> resources, LinkedLogisticsOrderList parts) {
            }
        }, null);
    }

    public static void simulate(EntityPlayer player, ItemIdentifierStack stack, CoreRoutedPipe pipe) {
        final ArrayList<IResource> usedList = new ArrayList<IResource>();
        final ArrayList<IResource> missingList = new ArrayList<IResource>();
        RequestTree.simulate(stack.clone(), pipe, new RequestLog(){

            @Override
            public void handleMissingItems(List<IResource> resources) {
                missingList.addAll(resources);
            }

            @Override
            public void handleSucessfullRequestOf(IResource item, LinkedLogisticsOrderList parts) {
            }

            @Override
            public void handleSucessfullRequestOfList(List<IResource> resources, LinkedLogisticsOrderList parts) {
                usedList.addAll(resources);
            }
        });
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ComponentList.class).setUsed(usedList).setMissing(missingList), player);
    }

    public static void refresh(EntityPlayer player, CoreRoutedPipe pipe, DisplayOptions option) {
        Map<ItemIdentifier, Integer> _availableItems = option == DisplayOptions.SupplyOnly || option == DisplayOptions.Both ? SimpleServiceLocator.logisticsManager.getAvailableItems(pipe.getRouter().getIRoutersByCost()) : new HashMap<ItemIdentifier, Integer>();
        LinkedList<ItemIdentifier> _craftableItems = option == DisplayOptions.CraftOnly || option == DisplayOptions.Both ? SimpleServiceLocator.logisticsManager.getCraftableItems(pipe.getRouter().getIRoutersByCost()) : new LinkedList();
        TreeSet<ItemIdentifierStack> _allItems = new TreeSet<ItemIdentifierStack>();
        for (Map.Entry<ItemIdentifier, Integer> entry : _availableItems.entrySet()) {
            ItemIdentifierStack newStack = entry.getKey().makeStack(entry.getValue());
            _allItems.add(newStack);
        }
        for (ItemIdentifier itemIdentifier : _craftableItems) {
            if (_availableItems.containsKey(itemIdentifier)) continue;
            _allItems.add(itemIdentifier.makeStack(0));
        }
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OrdererContent.class).setIdentSet(_allItems), player);
    }

    public static void requestList(final EntityPlayer player, List<ItemIdentifierStack> list, final CoreRoutedPipe pipe) {
        if (!pipe.useEnergy(5)) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("lp.misc.noenergy", new Object[0]));
            return;
        }
        RequestTree.request(list, pipe, new RequestLog(){

            @Override
            public void handleMissingItems(List<IResource> resources) {
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(MissingItems.class).setItems(resources).setFlag(true), player);
            }

            @Override
            public void handleSucessfullRequestOf(IResource item, LinkedLogisticsOrderList parts) {
            }

            @Override
            public void handleSucessfullRequestOfList(List<IResource> resources, LinkedLogisticsOrderList parts) {
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(MissingItems.class).setItems(resources).setFlag(false), player);
                if (pipe instanceof IRequestWatcher) {
                    ((IRequestWatcher)((Object)pipe)).handleOrderList(null, parts);
                }
            }
        }, RequestTree.defaultRequestFlags, null);
    }

    public static void requestMacrolist(NBTTagCompound itemlist, final CoreRoutedPipe requester, final EntityPlayer player) {
        if (!requester.useEnergy(5)) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("lp.misc.noenergy", new Object[0]));
            return;
        }
        NBTTagList list = itemlist.func_150295_c("inventar", 10);
        ArrayList<ItemIdentifierStack> transaction = new ArrayList<ItemIdentifierStack>(list.func_74745_c());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound itemnbt = list.func_150305_b(i);
            NBTTagCompound itemNBTContent = itemnbt.func_74775_l("nbt");
            if (!itemnbt.func_74764_b("nbt")) {
                itemNBTContent = null;
            }
            ItemIdentifierStack stack = ItemIdentifier.get(Item.func_150899_d((int)itemnbt.func_74762_e("id")), itemnbt.func_74762_e("data"), itemNBTContent).makeStack(itemnbt.func_74762_e("amount"));
            transaction.add(stack);
        }
        RequestTree.request(transaction, requester, new RequestLog(){

            @Override
            public void handleMissingItems(List<IResource> resources) {
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(MissingItems.class).setItems(resources).setFlag(true), player);
            }

            @Override
            public void handleSucessfullRequestOf(IResource item, LinkedLogisticsOrderList parts) {
            }

            @Override
            public void handleSucessfullRequestOfList(List<IResource> resources, LinkedLogisticsOrderList parts) {
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(MissingItems.class).setItems(resources).setFlag(false), player);
                if (requester instanceof IRequestWatcher) {
                    ((IRequestWatcher)((Object)requester)).handleOrderList(null, parts);
                }
            }
        }, RequestTree.defaultRequestFlags, null);
    }

    public static Object[] computerRequest(ItemIdentifierStack makeStack, CoreRoutedPipe pipe, boolean craftingOnly) {
        EnumSet<RequestTree.ActiveRequestType> requestFlags = craftingOnly ? EnumSet.of(RequestTree.ActiveRequestType.Craft) : EnumSet.of(RequestTree.ActiveRequestType.Craft, RequestTree.ActiveRequestType.Provide);
        if (!pipe.useEnergy(15)) {
            return new Object[]{"NO_POWER"};
        }
        final Object[] status = new Object[2];
        RequestTree.request(makeStack, pipe, new RequestLog(){

            @Override
            public void handleMissingItems(List<IResource> resources) {
                status[0] = "MISSING";
                status[1] = resources;
            }

            @Override
            public void handleSucessfullRequestOf(IResource item, LinkedLogisticsOrderList parts) {
                status[0] = "DONE";
                LinkedList<IResource> itemList = new LinkedList<IResource>();
                itemList.add(item);
                status[1] = itemList;
            }

            @Override
            public void handleSucessfullRequestOfList(List<IResource> resources, LinkedLogisticsOrderList parts) {
            }
        }, false, false, true, false, requestFlags, null);
        return status;
    }

    public static void refreshFluid(EntityPlayer player, CoreRoutedPipe pipe) {
        TreeSet<ItemIdentifierStack> _allItems = SimpleServiceLocator.logisticsFluidManager.getAvailableFluid(pipe.getRouter().getIRoutersByCost());
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(OrdererContent.class).setIdentSet(_allItems), player);
    }

    public static void requestFluid(final EntityPlayer player, ItemIdentifierStack stack, CoreRoutedPipe pipe, IRequestFluid requester) {
        if (!pipe.useEnergy(10)) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("lp.misc.noenergy", new Object[0]));
            return;
        }
        RequestTree.requestFluid(FluidIdentifier.get(stack.getItem()), stack.getStackSize(), requester, new RequestLog(){

            @Override
            public void handleMissingItems(List<IResource> resources) {
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(MissingItems.class).setItems(resources).setFlag(true), player);
            }

            @Override
            public void handleSucessfullRequestOf(IResource item, LinkedLogisticsOrderList parts) {
                ArrayList<IResource> coll = new ArrayList<IResource>(1);
                coll.add(item);
                MainProxy.sendPacketToPlayer(PacketHandler.getPacket(MissingItems.class).setItems(coll).setFlag(false), player);
            }

            @Override
            public void handleSucessfullRequestOfList(List<IResource> resources, LinkedLogisticsOrderList parts) {
            }
        });
    }

    public static enum DisplayOptions {
        Both,
        SupplyOnly,
        CraftOnly;

    }
}

