/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui;

import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.ITopLevelWidget;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.RenderStage;
import binnie.core.craftgui.WidgetAttribute;
import binnie.core.craftgui.events.Event;
import binnie.core.craftgui.events.EventHandler;
import binnie.core.craftgui.events.EventWidget;
import binnie.core.craftgui.geometry.IArea;
import binnie.core.craftgui.geometry.IPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;

public class Widget
implements IWidget {
    protected IArea cropArea;
    protected IWidget cropWidget;
    protected boolean cropped = false;
    protected int color = 0xFFFFFF;
    private IWidget parent;
    private final List<IWidget> subWidgets = new ArrayList<IWidget>();
    private final List<WidgetAttribute> attributes = new ArrayList<WidgetAttribute>();
    private IPoint position = new IPoint(0.0f, 0.0f);
    private IPoint size = new IPoint(0.0f, 0.0f);
    private IPoint offset = new IPoint(0.0f, 0.0f);
    private final Collection<EventHandler> globalEventHandlers = new ArrayList<EventHandler>();
    private boolean enabled = true;
    private boolean visible = true;

    public Widget(IWidget parent) {
        this.parent = parent;
        if (parent != null) {
            parent.addWidget(this);
        }
    }

    @Override
    public List<WidgetAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean hasAttribute(WidgetAttribute attribute) {
        return this.attributes.contains((Object)attribute);
    }

    @Override
    public boolean addAttribute(WidgetAttribute attribute) {
        return this.attributes.add(attribute);
    }

    @Override
    public void deleteChild(IWidget child) {
        if (child == null) {
            return;
        }
        child.delete();
        this.subWidgets.remove(child);
    }

    @Override
    public void deleteAllChildren() {
        while (!this.subWidgets.isEmpty()) {
            this.deleteChild(this.subWidgets.get(0));
        }
    }

    @Override
    public IWidget getParent() {
        return this.parent;
    }

    @Override
    public ITopLevelWidget getSuperParent() {
        return (ITopLevelWidget)(this.isTopLevel() ? this : this.parent.getSuperParent());
    }

    @Override
    public IWidget addWidget(IWidget widget) {
        if (!this.subWidgets.isEmpty() && this.subWidgets.get(this.subWidgets.size() - 1).hasAttribute(WidgetAttribute.ALWAYS_ON_TOP)) {
            this.subWidgets.add(this.subWidgets.size() - 1, widget);
        } else {
            this.subWidgets.add(widget);
        }
        this.onAddChild(widget);
        return widget;
    }

    protected void onAddChild(IWidget widget) {
    }

    @Override
    public List<IWidget> getWidgets() {
        return this.subWidgets;
    }

    @Override
    public boolean isTopLevel() {
        return this instanceof ITopLevelWidget;
    }

    @Override
    public IPoint pos() {
        return this.position.add(this.offset);
    }

    @Override
    public IPoint size() {
        return this.size;
    }

    @Override
    public IArea area() {
        return this.getArea();
    }

    @Override
    public IPoint getPosition() {
        return this.pos();
    }

    @Override
    public IArea getArea() {
        return new IArea(IPoint.ZERO, this.size());
    }

    @Override
    public IPoint getOriginalPosition() {
        return this.position;
    }

    @Override
    public IArea getCroppedZone() {
        return this.cropArea;
    }

    @Override
    public void setCroppedZone(IWidget relative, IArea area) {
        this.cropArea = area;
        this.cropped = true;
        this.cropWidget = relative;
    }

    @Override
    public IPoint getAbsolutePosition() {
        return this.isTopLevel() ? this.getPosition() : this.getParent().getAbsolutePosition().add(this.getPosition());
    }

    @Override
    public IPoint getOriginalAbsolutePosition() {
        return this.isTopLevel() ? this.getOriginalPosition() : this.getParent().getOriginalPosition().sub(this.getOriginalPosition());
    }

    @Override
    public IPoint getSize() {
        return this.size();
    }

    @Override
    public IPoint getOffset() {
        return this.offset;
    }

    @Override
    public void setPosition(IPoint position) {
        if (!position.equals(this.position)) {
            this.position = new IPoint(position);
            this.callEvent(new EventWidget.ChangePosition(this));
        }
    }

    @Override
    public void setSize(IPoint size) {
        if (!size.equals(this.size)) {
            this.size = new IPoint(size);
            this.callEvent(new EventWidget.ChangeSize(this));
        }
    }

    @Override
    public void setOffset(IPoint offset) {
        if (offset != this.offset) {
            this.offset = new IPoint(offset);
            this.callEvent(new EventWidget.ChangeOffset(this));
        }
    }

    @Override
    public void setColor(int color) {
        if (this.color != color) {
            this.color = color;
            this.callEvent(new EventWidget.ChangeColour(this));
        }
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public boolean canMouseOver() {
        return this.hasAttribute(WidgetAttribute.MOUSE_OVER);
    }

    @Override
    public boolean canFocus() {
        return this.hasAttribute(WidgetAttribute.CAN_FOCUS);
    }

    public void addEventHandler(EventHandler handler) {
        this.globalEventHandlers.add(handler);
    }

    public void addSelfEventHandler(EventHandler handler) {
        this.addEventHandler(handler.setOrigin(EventHandler.Origin.Self, this));
    }

    @Override
    public void callEvent(Event event) {
        this.getSuperParent().recieveEvent(event);
    }

    @Override
    public void recieveEvent(Event event) {
        for (EventHandler handler : this.globalEventHandlers) {
            if (!handler.handles(event)) continue;
            handler.onEvent(event);
        }
        try {
            for (IWidget child : this.getWidgets()) {
                child.recieveEvent(event);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @Override
    public IPoint getMousePosition() {
        return this.getSuperParent().getAbsoluteMousePosition();
    }

    @Override
    public IPoint getRelativeMousePosition() {
        return this.isTopLevel() ? this.getMousePosition() : this.getParent().getRelativeMousePosition().sub(this.getPosition());
    }

    @Override
    public boolean isCroppedWidget() {
        return this.cropped;
    }

    @Override
    public IWidget getCropWidget() {
        return this.cropWidget == null ? this : this.cropWidget;
    }

    @Override
    public void render() {
        if (!this.isVisible()) {
            return;
        }
        CraftGUI.render.preRender(this);
        this.onRender(RenderStage.PreChildren);
        for (IWidget widget : this.getWidgets()) {
            widget.render();
            CraftGUI.render.preRender(widget);
            widget.onRender(RenderStage.PostSiblings);
            CraftGUI.render.postRender(widget);
        }
        this.onRender(RenderStage.PostChildren);
        CraftGUI.render.postRender(this);
    }

    @Override
    public void updateClient() {
        if (!this.isVisible()) {
            return;
        }
        if (this.getSuperParent() == this) {
            ((ITopLevelWidget)((Object)this)).updateTopLevel();
        }
        this.onUpdateClient();
        ArrayList<IWidget> deletedWidgets = new ArrayList<IWidget>();
        for (IWidget widget : this.getWidgets()) {
            if (widget.hasAttribute(WidgetAttribute.NEEDS_DELETION)) {
                deletedWidgets.add(widget);
                continue;
            }
            widget.updateClient();
        }
        for (IWidget widget : deletedWidgets) {
            this.deleteChild(widget);
        }
    }

    @Override
    public boolean calculateIsMouseOver() {
        IPoint mouse = this.getRelativeMousePosition();
        if (!this.cropped) {
            return this.isMouseOverWidget(mouse);
        }
        IWidget cropRelative = this.cropWidget != null ? this.cropWidget : this;
        IPoint pos = IPoint.sub(cropRelative.getAbsolutePosition(), this.getAbsolutePosition());
        IPoint size = new IPoint(this.cropArea.size().x(), this.cropArea.size().y());
        return mouse.x() > pos.x() && mouse.y() > pos.y() && mouse.x() < pos.x() + size.x() && mouse.y() < pos.y() + size.y() && this.isMouseOverWidget(mouse);
    }

    @Override
    public boolean isMouseOverWidget(IPoint relativeMouse) {
        return this.getArea().contains(relativeMouse);
    }

    @Override
    public void enable() {
        this.enabled = true;
        this.callEvent(new EventWidget.Enable(this));
    }

    @Override
    public void disable() {
        this.enabled = false;
        this.callEvent(new EventWidget.Disable(this));
    }

    @Override
    public void show() {
        this.visible = true;
        this.callEvent(new EventWidget.Show(this));
    }

    @Override
    public void hide() {
        this.visible = false;
        this.callEvent(new EventWidget.Hide(this));
    }

    @Override
    public boolean isEnabled() {
        if (!this.enabled) {
            return false;
        }
        if (this.isTopLevel()) {
            return true;
        }
        return this.getParent().isEnabled() && this.getParent().isChildEnabled(this);
    }

    @Override
    public boolean isVisible() {
        if (!this.visible) {
            return false;
        }
        if (this.isTopLevel()) {
            return true;
        }
        return this.getParent().isVisible() && this.getParent().isChildVisible(this);
    }

    @Override
    public boolean isFocused() {
        return this.getSuperParent().isFocused(this);
    }

    @Override
    public boolean isDragged() {
        return this.getSuperParent().isDragged(this);
    }

    @Override
    public boolean isMouseOver() {
        return this.getSuperParent().isMouseOver(this);
    }

    @Override
    public boolean isChildVisible(IWidget child) {
        return true;
    }

    @Override
    public boolean isChildEnabled(IWidget child) {
        return true;
    }

    @Override
    public void onRender(RenderStage stage) {
        if (stage == RenderStage.PreChildren) {
            this.onRenderBackground();
        } else if (stage == RenderStage.PostChildren) {
            this.onRenderForeground();
        } else if (stage == RenderStage.PostSiblings) {
            this.onRenderOverlay();
        }
    }

    public void onRenderBackground() {
    }

    public void onRenderForeground() {
    }

    public void onRenderOverlay() {
    }

    @Override
    public void onUpdateClient() {
    }

    @Override
    public void delete() {
        this.getSuperParent().widgetDeleted(this);
        this.onDelete();
    }

    @Override
    public void onDelete() {
    }

    @Override
    public <T> T getWidget(Class<T> x) {
        for (IWidget child : this.getWidgets()) {
            if (x.isInstance(child)) {
                return (T)child;
            }
            T found = child.getWidget(x);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public boolean contains(IPoint position) {
        return this.getArea().contains(position);
    }

    @Override
    public int getLevel() {
        int level = this.getParent() == null ? 0 : this.getParent().getLevel();
        int index = this.getParent() == null ? 0 : this.getParent().getWidgets().indexOf(this);
        return level + index;
    }

    @Override
    public boolean isDescendant(IWidget widget) {
        IWidget clss = this;
        while (clss != widget) {
            if ((clss = clss.getParent()) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public float x() {
        return this.pos().x();
    }

    @Override
    public float y() {
        return this.pos().y();
    }

    @Override
    public float w() {
        return this.size().x();
    }

    @Override
    public float h() {
        return this.size().y();
    }

    public IWidget getWidget() {
        return this;
    }
}

