/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.building;

import com.recursive_pineapple.matter_manipulator.common.building.BlockAnalyzer;
import com.recursive_pineapple.matter_manipulator.common.building.PortableItemStack;
import com.recursive_pineapple.matter_manipulator.common.building.providers.AECellItemProvider;
import com.recursive_pineapple.matter_manipulator.common.building.providers.BatteryItemProvider;
import com.recursive_pineapple.matter_manipulator.common.building.providers.IItemProvider;
import com.recursive_pineapple.matter_manipulator.common.building.providers.PatternItemProvider;
import com.recursive_pineapple.matter_manipulator.common.utils.InventoryAdapter;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import com.recursive_pineapple.matter_manipulator.common.utils.Mods;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InventoryAnalysis {
    public boolean mFuzzy;
    public IItemProvider[] mItems;

    @Nullable
    public static InventoryAnalysis fromInventory(IInventory inv, boolean fuzzy) {
        InventoryAnalysis analysis = new InventoryAnalysis();
        analysis.mFuzzy = fuzzy;
        analysis.mItems = new IItemProvider[inv.func_70302_i_()];
        InventoryAdapter adapter = InventoryAdapter.findAdapter(inv);
        if (adapter == null) {
            return null;
        }
        for (int slot = 0; slot < analysis.mItems.length; ++slot) {
            if (!adapter.isValidSlot(inv, slot)) continue;
            analysis.mItems[slot] = InventoryAnalysis.getProviderFor(inv.func_70301_a(slot), fuzzy);
        }
        return analysis;
    }

    private static IItemProvider getProviderFor(ItemStack stack, boolean fuzzy) {
        BatteryItemProvider battery;
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        if (Mods.AppliedEnergistics2.isModLoaded()) {
            AECellItemProvider cell;
            if (!fuzzy && (cell = AECellItemProvider.fromWorkbenchItem(stack)) != null) {
                return cell;
            }
            PatternItemProvider pattern = PatternItemProvider.fromPattern(stack);
            if (pattern != null) {
                return pattern;
            }
        }
        if ((battery = BatteryItemProvider.fromStack(stack)) != null) {
            return battery;
        }
        return fuzzy ? new PortableItemStack(stack) : PortableItemStack.withNBT(stack);
    }

    public boolean apply(BlockAnalyzer.IBlockApplyContext context, IInventory inv, boolean consume, boolean simulate) {
        return this.apply(context, inv, InventoryAdapter.findAdapter(inv), consume, simulate);
    }

    private boolean apply(BlockAnalyzer.IBlockApplyContext context, IInventory inv, InventoryAdapter adapter, boolean consume, boolean simulate) {
        if (!adapter.validate(context, inv)) {
            return false;
        }
        if (inv.func_70302_i_() != this.mItems.length) {
            context.warn("Inventory was the wrong size (expected " + this.mItems.length + ", was " + inv.func_70302_i_() + ")");
            return false;
        }
        boolean didSomething = false;
        boolean success = true;
        for (int slot = 0; slot < this.mItems.length; ++slot) {
            IItemProvider actual;
            IItemProvider target;
            if (!adapter.isValidSlot(inv, slot) || Objects.equals(target = this.mItems[slot], actual = InventoryAnalysis.getProviderFor(inv.func_70301_a(slot), this.mFuzzy))) continue;
            ItemStack stack = inv.func_70301_a(slot);
            if (stack != null) {
                if (!adapter.canExtract(inv, slot)) {
                    context.warn("Could not extract item in slot " + slot + ": " + MMUtils.stripFormat(stack.func_82833_r()));
                    continue;
                }
                if (!simulate && (stack = adapter.extract(inv, slot)) != null) {
                    didSomething = true;
                }
                if (stack != null && consume) {
                    context.givePlayerItems(stack);
                }
            }
            if (target == null) continue;
            if (!adapter.canInsert(inv, slot, target.getStack(null, false))) {
                context.warn("Invalid item for slot " + slot + ": " + MMUtils.stripFormat(target.describe()));
                continue;
            }
            ItemStack toInsert = target.getStack(context, consume);
            if (toInsert == null) {
                context.warn("Could not gather item for inventory: " + MMUtils.stripFormat(target.describe()));
                success = false;
                continue;
            }
            if (simulate) continue;
            if (adapter.insert(inv, slot, toInsert)) {
                didSomething = true;
                continue;
            }
            context.givePlayerItems(toInsert);
        }
        if (didSomething) {
            inv.func_70296_d();
        }
        return success;
    }

    protected InventoryAnalysis clone() {
        InventoryAnalysis dup = new InventoryAnalysis();
        dup.mFuzzy = this.mFuzzy;
        dup.mItems = MMUtils.mapToArray(this.mItems, IItemProvider[]::new, x -> x == null ? null : x.clone());
        return dup;
    }
}

