/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.forge;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import mods.railcraft.common.items.IItemMetaEnum;
import mods.railcraft.common.items.RailcraftItem;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.Level;

public class CraftingPlugin {
    public static void addFurnaceRecipe(ItemStack input, ItemStack output, float xp) {
        if (input == null && output == null) {
            Game.logTrace(Level.WARN, "Tried to define invalid furnace recipe, the input and output were both null. Skipping", new Object[0]);
            return;
        }
        if (input == null) {
            Game.logTrace(Level.WARN, "Tried to define invalid furnace recipe for {0}, the input was null. Skipping", output.func_77977_a());
            return;
        }
        if (output == null) {
            Game.logTrace(Level.WARN, "Tried to define invalid furnace recipe for {0}, the output was null. Skipping", input.func_77977_a());
            return;
        }
        FurnaceRecipes.func_77602_a().func_151394_a(input, output, xp);
    }

    private static Object[] cleanRecipeArray(Object[] recipeArray) {
        ArrayList recipeList = Lists.newArrayList((Object[])recipeArray);
        for (int i = 0; i < recipeList.size(); ++i) {
            Object obj2;
            Object obj = recipeList.get(i);
            if (!(obj instanceof RailcraftItem)) continue;
            Object v0 = obj2 = i + 1 < recipeList.size() ? recipeList.get(i + 1) : null;
            if (obj2 instanceof IItemMetaEnum) {
                recipeList.set(i, ((RailcraftItem)((Object)obj)).getRecipeObject(obj2));
                recipeList.remove(i + 1);
                continue;
            }
            recipeList.set(i, ((RailcraftItem)((Object)obj)).getRecipeObject());
        }
        return recipeList.toArray();
    }

    public static void addShapedRecipe(ItemStack result, Object ... recipeArray) {
        if (result == null || result.field_77994_a <= 0) {
            Game.logTrace(Level.WARN, "Tried to define invalid shaped recipe, the result was null or zero. Skipping", new Object[0]);
            return;
        }
        recipeArray = CraftingPlugin.cleanRecipeArray(recipeArray);
        boolean oreRecipe = false;
        for (Object obj : recipeArray) {
            if (obj instanceof String) {
                if (((String)obj).length() <= 3) continue;
                oreRecipe = true;
                continue;
            }
            if (obj instanceof Boolean) {
                oreRecipe = true;
                continue;
            }
            if (obj != null) continue;
            Game.logTrace(Level.WARN, "Tried to define invalid shaped recipe for {0}, a necessary item was probably disabled. Skipping", result.func_77977_a());
            return;
        }
        if (oreRecipe) {
            ShapedOreRecipe recipe = new ShapedOreRecipe(result, recipeArray);
            CraftingPlugin.addRecipe((IRecipe)recipe);
        } else {
            GameRegistry.addRecipe((ItemStack)result, (Object[])recipeArray);
        }
    }

    public static void addShapelessRecipe(ItemStack result, Object ... recipeArray) {
        if (result == null || result.field_77994_a <= 0) {
            Game.logTrace(Level.WARN, "Tried to define invalid shapeless recipe, the result was null or zero. Skipping", new Object[0]);
            return;
        }
        recipeArray = CraftingPlugin.cleanRecipeArray(recipeArray);
        boolean oreRecipe = false;
        for (Object obj : recipeArray) {
            if (obj instanceof String) {
                oreRecipe = true;
                continue;
            }
            if (obj != null) continue;
            Game.logTrace(Level.WARN, "Tried to define invalid shapeless recipe for {0}, a necessary item was probably disabled. Skipping", result.func_77977_a());
            return;
        }
        if (oreRecipe) {
            ShapelessOreRecipe recipe = new ShapelessOreRecipe(result, recipeArray);
            CraftingPlugin.addRecipe((IRecipe)recipe);
        } else {
            GameRegistry.addShapelessRecipe((ItemStack)result, (Object[])recipeArray);
        }
    }

    public static void addRecipe(IRecipe recipe) {
        GameRegistry.addRecipe((IRecipe)recipe);
    }
}

