/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.LRUCache;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.api.IRecipeFilter;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.filter.AllMultiItemFilter;
import codechicken.nei.filter.AnyItemRecipeFilter;
import codechicken.nei.filter.AnyMultiItemFilter;
import codechicken.nei.filter.EverythingItemFilter;
import codechicken.nei.filter.NegatedItemFilter;
import codechicken.nei.filter.NothingItemFilter;
import codechicken.nei.search.ItemFilterVisitor;
import codechicken.nei.search.RecipeFilterVisitor;
import codechicken.nei.search.SearchExpressionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.Language;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class SearchTokenParser {
    public static final Pattern SPACE_PATTERN = Pattern.compile(" ");
    protected final LRUCache<String, ItemFilter> filtersCache = new LRUCache(20);
    protected final List<ISearchParserProvider> searchProviders;
    protected final Set<Character> redefinedPrefixes = new HashSet<Character>();
    protected final ProvidersCache providersCache = new ProvidersCache();
    protected final Map<Character, Character> prefixRedefinitions = new HashMap<Character, Character>();

    public SearchTokenParser(List<ISearchParserProvider> searchProviders) {
        this.searchProviders = searchProviders;
        this.updateRedefinedPrefixes();
    }

    public SearchTokenParser() {
        this(new ArrayList<ISearchParserProvider>());
        this.updateRedefinedPrefixes();
    }

    public void addProvider(ISearchParserProvider provider) {
        this.searchProviders.add(provider);
        this.updateRedefinedPrefixes(provider);
        this.providersCache.clear();
        this.filtersCache.clear();
    }

    public void clearCache() {
        this.filtersCache.clear();
        this.updateRedefinedPrefixes();
    }

    protected List<ISearchParserProvider> getProviders() {
        Language currentLanguage = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        if (!currentLanguage.func_135034_a().equals(this.providersCache.languageCode)) {
            this.providersCache.providers = new ArrayList<ISearchParserProvider>();
            this.providersCache.languageCode = currentLanguage.func_135034_a();
            HashMap<Character, ISearchParserProvider> providers = new HashMap<Character, ISearchParserProvider>();
            for (int index = this.searchProviders.size() - 1; index >= 0; --index) {
                ISearchParserProvider provider = this.searchProviders.get(index);
                if (!provider.getMatchingLanguages().contains(currentLanguage)) continue;
                if (provider.getSearchMode() == SearchMode.PREFIX && !providers.containsKey(Character.valueOf(provider.getPrefix()))) {
                    providers.put(Character.valueOf(provider.getPrefix()), provider);
                    continue;
                }
                if (provider.getSearchMode() != SearchMode.ALWAYS) continue;
                this.providersCache.providers.add(provider);
            }
            this.providersCache.providers.addAll(providers.values());
        }
        return this.providersCache.providers;
    }

    public boolean hasRedefinedPrefix(char ch) {
        return this.redefinedPrefixes.contains(Character.valueOf(ch));
    }

    public ISearchParserProvider getProvider(char ch) {
        if (!this.hasRedefinedPrefix(ch)) {
            return null;
        }
        for (ISearchParserProvider provider : this.getProviders()) {
            if (provider.getSearchMode() != SearchMode.PREFIX || this.getRedefinedPrefix(provider.getPrefix()) != ch) continue;
            return provider;
        }
        return null;
    }

    public List<ItemFilter> getAlwaysProvidersFilters(String searchText) {
        ArrayList<ItemFilter> filters = new ArrayList<ItemFilter>();
        for (ISearchParserProvider provider : this.getProviders()) {
            if (provider.getSearchMode() != SearchMode.ALWAYS) continue;
            filters.add(provider.getFilter(searchText));
        }
        return filters;
    }

    public synchronized ItemFilter getFilter(String filterText) {
        if ((filterText = EnumChatFormatting.func_110646_a((String)filterText).toLowerCase()) == null || filterText.isEmpty()) {
            return new EverythingItemFilter();
        }
        int spaceMode = NEIClientConfig.getIntSetting("inventory.search.spaceMode");
        int patternMode = NEIClientConfig.getIntSetting("inventory.search.patternMode");
        if (patternMode != 3) {
            return this.filtersCache.computeIfAbsent(filterText, text -> {
                String[] parts = text.split("\\|");
                List<ItemFilter> searchTokens = Arrays.stream(parts).map(this::parseSearchText).filter(s -> s != null).collect(Collectors.toList());
                if (searchTokens.isEmpty()) {
                    return new EverythingItemFilter();
                }
                if (searchTokens.size() == 1) {
                    return new IsRegisteredItemFilter((ItemFilter)searchTokens.get(0));
                }
                return new IsRegisteredItemFilter(new AnyMultiItemFilter(searchTokens));
            });
        }
        if (spaceMode == 1) {
            filterText = SPACE_PATTERN.matcher(filterText).replaceAll("\\\\ ");
        }
        return this.filtersCache.computeIfAbsent(filterText, text -> {
            ItemFilterVisitor visitor = new ItemFilterVisitor(this);
            ItemFilter searchToken = SearchExpressionUtils.visitSearchExpression(text, visitor);
            return new IsRegisteredItemFilter(searchToken);
        });
    }

    public synchronized IRecipeFilter getRecipeFilter(String filterText) {
        int patternMode = NEIClientConfig.getIntSetting("inventory.search.patternMode");
        if (patternMode != 3) {
            return new AnyItemRecipeFilter(this.getFilter(filterText));
        }
        if ((filterText = EnumChatFormatting.func_110646_a((String)filterText).toLowerCase()) == null || filterText.isEmpty()) {
            return new AnyItemRecipeFilter(new EverythingItemFilter());
        }
        int spaceModeEnabled = NEIClientConfig.getIntSetting("inventory.search.spaceMode");
        if (spaceModeEnabled == 1) {
            filterText = SPACE_PATTERN.matcher(filterText).replaceAll("\\\\ ");
        }
        RecipeFilterVisitor visitor = new RecipeFilterVisitor(this);
        return SearchExpressionUtils.visitSearchExpression(filterText, visitor);
    }

    public List<SearchToken> splitSearchText(String filterText) {
        if (filterText.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SearchToken> tokens = new ArrayList<SearchToken>();
        String prefixes = this.getPrefixes();
        int spaceMode = NEIClientConfig.getIntSetting("inventory.search.spaceMode");
        String patternPart1 = "(?<tokenA>(^|\\s+)(?:[^" + Pattern.quote(" -\"" + prefixes) + "]).+?(?=\\s+[" + Pattern.quote("-\"" + prefixes) + "]|$))";
        String patternPart2 = "((?<ignore>-*)(?<firstChar>[" + Pattern.quote(prefixes) + "]*)(?<tokenB>\\\".*?(?:\\\"|$)|\\S+\\s*))";
        Pattern pattern = Pattern.compile(spaceMode == 0 ? patternPart2 : patternPart1 + "|" + patternPart2);
        Matcher filterMatcher = pattern.matcher(filterText);
        while (filterMatcher.find()) {
            String firstChar = filterMatcher.group("firstChar");
            SearchToken token = new SearchToken();
            token.start = filterMatcher.start();
            token.end = filterMatcher.end();
            token.ignore = "-".equals(filterMatcher.group("ignore"));
            String string = token.rawText = spaceMode == 0 ? null : filterMatcher.group("tokenA");
            if (firstChar != null && !firstChar.isEmpty()) {
                token.firstChar = Character.valueOf(firstChar.charAt(0));
            }
            if (token.rawText == null) {
                token.rawText = filterMatcher.group("tokenB");
                boolean bl = token.quotes = token.rawText.length() > 1 && token.rawText.startsWith("\"") && token.rawText.endsWith("\"");
                if (token.quotes) {
                    token.rawText = token.rawText.substring(1, token.rawText.length() - 1);
                }
                token.words = new String[]{token.rawText.trim()};
            } else {
                token.words = spaceMode == 2 ? token.rawText.trim().split("\\s+") : new String[]{token.rawText.trim()};
            }
            tokens.add(token);
        }
        return tokens;
    }

    private String getPrefixes() {
        StringBuilder builder = new StringBuilder();
        for (Character redefinedPrefix : this.redefinedPrefixes) {
            builder.append(redefinedPrefix);
        }
        return builder.toString();
    }

    public char getRedefinedPrefix(char prefix) {
        return this.prefixRedefinitions.getOrDefault(Character.valueOf(prefix), Character.valueOf(prefix)).charValue();
    }

    public void updateRedefinedPrefixes() {
        this.redefinedPrefixes.clear();
        for (ISearchParserProvider provider : this.getProviders()) {
            if (provider.getSearchMode() != SearchMode.PREFIX) continue;
            this.redefinedPrefixes.add(Character.valueOf(this.getRedefinedPrefix(provider.getPrefix())));
        }
        this.redefinedPrefixes.add(Character.valueOf('\u0000'));
    }

    public void updateRedefinedPrefixes(ISearchParserProvider provider) {
        if (provider.getSearchMode() == SearchMode.PREFIX) {
            this.redefinedPrefixes.add(Character.valueOf(this.getRedefinedPrefix(provider.getPrefix())));
        }
    }

    private ItemFilter parseSearchText(String filterText) {
        if (filterText.isEmpty()) {
            return null;
        }
        AllMultiItemFilter searchTokens = new AllMultiItemFilter();
        List<SearchToken> tokens = this.splitSearchText(filterText);
        for (SearchToken token : tokens) {
            if (!token.rawText.isEmpty()) {
                ItemFilter result = this.parseToken(token);
                if (token.ignore) {
                    searchTokens.filters.add(new NegatedItemFilter(result));
                    continue;
                }
                searchTokens.filters.add(result);
                continue;
            }
            if (token.ignore) continue;
            searchTokens.filters.add(new NothingItemFilter());
        }
        return searchTokens;
    }

    private ItemFilter parseToken(SearchToken token) {
        ISearchParserProvider provider;
        ISearchParserProvider iSearchParserProvider = provider = token.firstChar == null ? null : this.getProvider(token.firstChar.charValue());
        if (provider == null || provider.getSearchMode() == SearchMode.NEVER) {
            ArrayList<ItemFilter> filters = new ArrayList<ItemFilter>();
            for (ISearchParserProvider _provider : this.getProviders()) {
                if (_provider.getSearchMode() != SearchMode.ALWAYS) continue;
                AllMultiItemFilter filter = this.generateFilters(_provider, token.words);
                if (filter.filters.isEmpty()) continue;
                filters.add(filter);
            }
            return filters.isEmpty() ? new NothingItemFilter() : new AnyMultiItemFilter(filters);
        }
        return this.generateFilters(provider, token.words);
    }

    private AllMultiItemFilter generateFilters(ISearchParserProvider provider, String[] words) {
        AllMultiItemFilter filters = new AllMultiItemFilter();
        for (String work : words) {
            ItemFilter filter = provider.getFilter(work);
            if (filter == null) continue;
            filters.filters.add(filter);
        }
        return filters;
    }

    private static class ProvidersCache {
        public String languageCode = null;
        public List<ISearchParserProvider> providers = new ArrayList<ISearchParserProvider>();

        private ProvidersCache() {
        }

        public void clear() {
            this.languageCode = null;
            this.providers.clear();
        }
    }

    public static interface ISearchParserProvider {
        public ItemFilter getFilter(String var1);

        public static List<Language> getAllLanguages() {
            return new ArrayList<Language>(Minecraft.func_71410_x().func_135016_M().func_135040_d());
        }

        default public List<Language> getMatchingLanguages() {
            return ISearchParserProvider.getAllLanguages();
        }

        public char getPrefix();

        public EnumChatFormatting getHighlightedColor();

        public SearchMode getSearchMode();
    }

    public static enum SearchMode {
        ALWAYS,
        PREFIX,
        NEVER;


        public static SearchMode fromInt(int value) {
            SearchMode searchMode;
            switch (value) {
                case 0: {
                    searchMode = ALWAYS;
                    break;
                }
                case 1: {
                    searchMode = PREFIX;
                    break;
                }
                default: {
                    searchMode = NEVER;
                }
            }
            return searchMode;
        }
    }

    public static class SearchToken {
        public boolean ignore = false;
        public boolean quotes = false;
        public Character firstChar = null;
        public String[] words;
        public String rawText = "";
        public int start = 0;
        public int end = 0;
    }

    public static class IsRegisteredItemFilter
    implements ItemFilter {
        public ItemFilter filter;

        public IsRegisteredItemFilter(ItemFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean matches(ItemStack item) {
            return item != null && item.func_77973_b() != null && item.func_77973_b().delegate.name() != null && this.filter.matches(item);
        }
    }
}

