/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config.preset;

import codechicken.core.gui.GuiWidget;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.CollapsibleItems;
import codechicken.nei.ItemsGrid;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PresetsList;
import codechicken.nei.SearchField;
import codechicken.nei.TextField;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.config.preset.CheckboxButton;
import codechicken.nei.config.preset.PresetItemsGrid;
import codechicken.nei.filter.AllMultiItemFilter;
import codechicken.nei.filter.AnyMultiItemFilter;
import codechicken.nei.filter.NegatedItemFilter;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.util.TextHistory;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class RightPanel
extends GuiWidget {
    protected static final int INPUT_HEIGHT = 20;
    protected static final int BUTTON_SIZE = 16;
    protected final PresetItemsGrid grid = new PresetItemsGrid(){

        @Override
        protected ItemFilter getFilter() {
            AllMultiItemFilter filter = new AllMultiItemFilter(RightPanel.this.searchField.getFilter());
            if (RightPanel.this.enabledPresets.isChecked()) {
                AllMultiItemFilter andFilter = new AllMultiItemFilter();
                AnyMultiItemFilter orFilter = new AnyMultiItemFilter();
                Set identifiers = PresetsList.presets.stream().flatMap(p -> p.items.stream()).collect(Collectors.toSet());
                andFilter.filters.add(item -> !identifiers.contains(PresetsList.Preset.getIdentifier(item)));
                andFilter.filters.add(new NegatedItemFilter(CollapsibleItems.getItemFilter()));
                if (RightPanel.this.slotIndex != -1) {
                    orFilter.filters.add(PresetsList.presets.get(RightPanel.this.slotIndex));
                }
                orFilter.filters.add(andFilter);
                filter.filters.add(orFilter);
            }
            return filter;
        }

        @Override
        protected boolean isSelected(ItemStack stack) {
            if (RightPanel.this.mouseSelection != null && RightPanel.this.mouseSelection.items.contains(stack)) {
                return RightPanel.this.mouseSelection.append;
            }
            return RightPanel.this.preset.items.contains(PresetsList.Preset.getIdentifier(stack));
        }

        @Override
        protected ItemsGrid.MouseContext getMouseContext(int mousex, int mousey) {
            Object hovered = this.getSlotMouseOver(mousex, mousey);
            if (hovered != null) {
                return new ItemsGrid.MouseContext(((ItemsGrid.ItemsGridSlot)hovered).slotIndex, ((ItemsGrid.ItemsGridSlot)hovered).slotIndex / this.columns, ((ItemsGrid.ItemsGridSlot)hovered).slotIndex % this.columns);
            }
            return null;
        }
    };
    protected CheckboxButton enabledPresets;
    protected final PresetsList.Preset preset;
    protected final int slotIndex;
    protected MouseSelection mouseSelection;
    protected final PresetSearchField searchField = new PresetSearchField("preset-search"){

        @Override
        public void onTextChange(String oldText) {
            String newText = this.text();
            if (!newText.equals(oldText)) {
                RightPanel.this.grid.restartFilter();
            }
        }
    };

    public RightPanel(PresetsList.Preset preset, int slotIndex) {
        super(1, 0, 2, 2);
        this.slotIndex = slotIndex;
        this.preset = preset;
        this.enabledPresets = new CheckboxButton(NEIClientUtils.translate("presets.filter", new Object[0])){

            @Override
            protected void onChange() {
                RightPanel.this.grid.restartFilter();
            }
        };
        this.enabledPresets.setChecked(true);
        this.grid.restartFilter();
    }

    public void mouseClicked(int x, int y, int button) {
        Object slot;
        this.grid.mouseClicked(x, y, button);
        if (this.enabledPresets.contains(x, y)) {
            this.enabledPresets.handleClick(x, y, button);
        }
        if (this.searchField.contains(x, y)) {
            this.searchField.handleClick(x, y, button);
        } else {
            this.searchField.onGuiClick(x, y);
        }
        if (this.mouseSelection == null && (button == 0 || button == 1) && (slot = this.grid.getSlotMouseOver(x, y)) != null) {
            this.mouseSelection = new MouseSelection(((ItemsGrid.ItemsGridSlot)slot).itemIndex, this.grid.getItemRect(((ItemsGrid.ItemsGridSlot)slot).itemIndex), button == 0);
        }
    }

    protected void onItemsChanges() {
    }

    public void mouseMovedOrUp(int x, int y, int button) {
        this.searchField.mouseUp(x, y, button);
        if (this.mouseSelection != null && (button == 0 || button == 1)) {
            Object hoverSlot = this.grid.getSlotMouseOver(x, y);
            if (hoverSlot != null && ((ItemsGrid.ItemsGridSlot)hoverSlot).itemIndex == this.mouseSelection.startIndex) {
                this.setHidden(((ItemsGrid.ItemsGridSlot)hoverSlot).getItemStack(), button == 0);
            } else if (!this.mouseSelection.items.isEmpty()) {
                for (ItemStack stack : this.mouseSelection.items) {
                    this.hideItem(stack, this.mouseSelection.append);
                }
            }
            this.mouseSelection = null;
            this.onItemsChanges();
        }
    }

    protected void setHidden(ItemStack stack, boolean append) {
        if (NEIClientUtils.shiftKey()) {
            ArrayList<ItemStack> items = this.grid.getItems();
            for (int i = 0; i < items.size(); ++i) {
                if (!stack.func_77973_b().equals(((ItemStack)items.get(i)).func_77973_b())) continue;
                this.hideItem((ItemStack)items.get(i), append);
            }
        } else if (NEIClientUtils.controlKey()) {
            String modId = RightPanel.getModId(stack);
            if (modId == null) {
                this.hideItem(stack, append);
            } else {
                ArrayList<ItemStack> items = this.grid.getItems();
                for (int i = 0; i < items.size(); ++i) {
                    String mod = RightPanel.getModId((ItemStack)items.get(i));
                    if (mod == null || !mod.equals(modId)) continue;
                    this.hideItem((ItemStack)items.get(i), append);
                }
            }
        } else {
            this.hideItem(stack, append);
        }
    }

    protected void hideItem(ItemStack stack, boolean append) {
        if (append) {
            this.preset.items.add(PresetsList.Preset.getIdentifier(stack));
        } else {
            this.preset.items.remove(PresetsList.Preset.getIdentifier(stack));
        }
    }

    protected static String getModId(ItemStack stack) {
        try {
            return GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b()).modId;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void mouseDragged(int x, int y, int button, long time) {
        Object slot;
        this.searchField.mouseDragged(x, y, button, time);
        if (this.mouseSelection != null && (button == 0 || button == 1) && (slot = this.grid.getSlotMouseOver(x, y)) != null && ((ItemsGrid.ItemsGridSlot)slot).itemIndex != this.mouseSelection.endIndex) {
            this.mouseSelection.endIndex = ((ItemsGrid.ItemsGridSlot)slot).itemIndex;
            this.mouseSelection.items.clear();
            Rectangle4i rec = this.grid.getItemRect(((ItemsGrid.ItemsGridSlot)slot).itemIndex);
            Rectangle4i sel = new Rectangle4i(Math.min(rec.x, this.mouseSelection.startX), Math.min(rec.y, this.mouseSelection.startY), Math.max(rec.x, this.mouseSelection.startX) - Math.min(rec.x, this.mouseSelection.startX), Math.max(rec.y, this.mouseSelection.startY) - Math.min(rec.y, this.mouseSelection.startY));
            for (int ix = sel.x; ix <= sel.x + sel.w; ix += ItemsGrid.SLOT_SIZE) {
                for (int iy = sel.y; iy <= sel.y + sel.h; iy += ItemsGrid.SLOT_SIZE) {
                    Object over = this.grid.getSlotMouseOver(ix, iy);
                    if (over == null) continue;
                    this.mouseSelection.items.add(((ItemsGrid.ItemsGridSlot)over).getItemStack());
                }
            }
        }
    }

    public void update() {
        this.enabledPresets.w = 20;
        this.enabledPresets.h = 20;
        this.enabledPresets.x = this.x;
        this.enabledPresets.y = this.y + this.height - 2 - 20;
        this.searchField.w = this.width - this.enabledPresets.w - 3;
        this.searchField.h = 20;
        this.searchField.x = this.enabledPresets.x + this.enabledPresets.w + 3;
        this.searchField.y = this.enabledPresets.y;
        this.grid.setGridSize(this.x, this.y, this.width, this.searchField.y - this.y);
        this.grid.refresh(null);
    }

    public void draw(int mousex, int mousey, float frame) {
        this.enabledPresets.draw(mousex, mousey);
        this.searchField.draw(mousex, mousey);
        RenderHelper.func_74520_c();
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        this.grid.draw(mousex, mousey);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        RenderHelper.func_74519_b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> handleTooltip(int mousex, int mousey, List<String> tooltip) {
        Object over = this.grid.getSlotMouseOver(mousex, mousey);
        if (over != null) {
            tooltip = GuiContainerManager.itemDisplayNameMultiline(((ItemsGrid.ItemsGridSlot)over).getItemStack(), null, true);
            LinkedList<IContainerTooltipHandler> linkedList = GuiContainerManager.tooltipHandlers;
            synchronized (linkedList) {
                for (IContainerTooltipHandler handler : GuiContainerManager.tooltipHandlers) {
                    tooltip = handler.handleItemTooltip(null, ((ItemsGrid.ItemsGridSlot)over).getItemStack(), mousex, mousey, tooltip);
                }
            }
            if (!tooltip.isEmpty()) {
                tooltip.set(0, tooltip.get(0) + "\u00a7h");
            }
        } else if (this.enabledPresets.contains(mousex, mousey)) {
            tooltip.add(NEIClientUtils.translate("presets.filter.tip", new Object[0]));
        }
        return tooltip;
    }

    public void keyTyped(char c, int keycode) {
        this.searchField.handleKeyPress(keycode, c);
    }

    public void mouseScrolled(int x, int y, int scroll) {
        if (this.grid.contains(x, y)) {
            this.grid.shiftPage(-scroll);
        }
    }

    protected static abstract class PresetSearchField
    extends TextField {
        private static final TextHistory history = new TextHistory();

        protected PresetSearchField(String ident) {
            super(ident);
        }

        @Override
        protected void initInternalTextField() {
            this.field = new SearchField.GuiSearchField();
            this.field.func_146203_f(256);
            this.field.func_146196_d();
        }

        @Override
        public int getTextColour() {
            if (!this.text().isEmpty()) {
                return this.focused() ? -3394816 : -6737152;
            }
            return this.focused() ? -2039584 : -7303024;
        }

        @Override
        public void lastKeyTyped(int keyID, char keyChar) {
            if (!this.focused() && NEIClientConfig.isKeyHashDown("gui.search")) {
                this.setFocus(true);
            }
            if (this.focused() && NEIClientConfig.isKeyHashDown("gui.getprevioussearch")) {
                this.handleNavigateHistory(TextHistory.Direction.PREVIOUS);
            }
            if (this.focused() && NEIClientConfig.isKeyHashDown("gui.getnextsearch")) {
                this.handleNavigateHistory(TextHistory.Direction.NEXT);
            }
        }

        @Override
        public String filterText(String s) {
            return EnumChatFormatting.func_110646_a((String)s);
        }

        public ItemFilter getFilter() {
            return ((SearchField.GuiSearchField)this.field).getFilter();
        }

        @Override
        public void setFocus(boolean focus) {
            boolean previousFocus = this.field.func_146206_l();
            if (previousFocus != focus) {
                history.add(this.text());
            }
            super.setFocus(focus);
        }

        private boolean handleNavigateHistory(TextHistory.Direction direction) {
            if (this.focused()) {
                return history.get(direction, this.text()).map(newText -> {
                    this.setText((String)newText);
                    return true;
                }).orElse(false);
            }
            return false;
        }
    }

    protected static class MouseSelection {
        public int startX = -1;
        public int startY = -1;
        public int startIndex = -1;
        public int endIndex = -1;
        public Set<ItemStack> items = new HashSet<ItemStack>();
        public boolean append = true;

        public MouseSelection(int slotIndex, Rectangle4i rec, boolean ppnd) {
            this.append = ppnd;
            this.endIndex = slotIndex;
            this.startIndex = slotIndex;
            this.startX = rec.x;
            this.startY = rec.y;
        }
    }
}

