/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.nei.FastTransferManager;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.StackInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class DefaultOverlayHandler
implements IOverlayHandler {
    public int offsetx;
    public int offsety;

    public DefaultOverlayHandler(int x, int y) {
        this.offsetx = x;
        this.offsety = y;
    }

    public DefaultOverlayHandler() {
        this(5, 11);
    }

    @Override
    public void overlayRecipe(GuiContainer gui, IRecipeHandler handler, int recipeIndex, boolean maxTransfer) {
        this.transferRecipe(gui, handler, recipeIndex, maxTransfer ? Integer.MAX_VALUE : 1);
    }

    @Override
    public int transferRecipe(GuiContainer gui, IRecipeHandler handler, int recipeIndex, int multiplier) {
        List<PositionedStack> ingredients = handler.getIngredientStacks(recipeIndex);
        List<DistributedIngred> ingredStacks = this.getPermutationIngredients(ingredients);
        if (!this.clearIngredients(gui)) {
            return 0;
        }
        this.findInventoryQuantities(gui, ingredStacks);
        List<IngredientDistribution> assignedIngredients = this.assignIngredients(ingredients, ingredStacks);
        if (assignedIngredients == null) {
            return 0;
        }
        this.assignIngredSlots(gui, ingredients, assignedIngredients);
        multiplier = Math.min(multiplier == 0 ? 64 : multiplier, this.calculateRecipeQuantity(assignedIngredients));
        this.moveIngredients(gui, assignedIngredients, Math.max(1, multiplier));
        return assignedIngredients.stream().anyMatch(distrib -> distrib.distrib.distributed == 0) ? 0 : multiplier;
    }

    @Override
    public boolean canFillCraftingGrid(GuiContainer firstGui, IRecipeHandler handler, int recipeIndex) {
        return true;
    }

    @Override
    public boolean canCraft(GuiContainer firstGui, IRecipeHandler handler, int recipeIndex) {
        return this.canFillCraftingGrid(firstGui, handler, recipeIndex) && this.presenceOverlay(firstGui, handler, recipeIndex).stream().allMatch(state -> state.isPresent());
    }

    @Override
    public boolean craft(GuiContainer firstGui, IRecipeHandler recipe, int recipeIndex, int multiplier) {
        int transfer;
        EntityClientPlayerMP thePlayer = NEIClientUtils.mc().field_71439_g;
        boolean craft = false;
        block0: while (multiplier > 0 && (transfer = this.transferRecipe(firstGui, recipe, recipeIndex, multiplier)) > 0) {
            multiplier -= transfer;
            for (Slot slot : firstGui.field_147002_h.field_75151_b) {
                if (!slot.func_75216_d() || !(slot instanceof SlotCrafting) || !slot.func_82869_a((EntityPlayer)thePlayer)) continue;
                FastTransferManager.clickSlot(firstGui, slot.field_75222_d, 0, 1);
                craft = true;
                continue block0;
            }
        }
        this.clearIngredients(firstGui);
        return craft;
    }

    private boolean clearIngredients(GuiContainer gui) {
        EntityClientPlayerMP thePlayer = NEIClientUtils.mc().field_71439_g;
        for (Slot slot : gui.field_147002_h.field_75151_b) {
            if (!slot.func_75216_d() || this.canMoveFrom(slot, gui) || slot instanceof SlotCrafting || !slot.func_82869_a((EntityPlayer)thePlayer)) continue;
            FastTransferManager.clickSlot(gui, slot.field_75222_d, 0, 1);
            if (!slot.func_75216_d()) continue;
            return false;
        }
        return this.dropOffMouseStack((EntityPlayer)thePlayer, gui);
    }

    private void moveIngredients(GuiContainer gui, List<IngredientDistribution> assignedIngredients, int multiplier) {
        EntityClientPlayerMP thePlayer = NEIClientUtils.mc().field_71439_g;
        for (Slot slot : gui.field_147002_h.field_75151_b) {
            if (slot instanceof SlotCrafting || !slot.func_75216_d() || !this.canMoveFrom(slot, gui) || !slot.func_82869_a((EntityPlayer)thePlayer)) continue;
            ItemStack stack = slot.func_75211_c();
            int slotTransferCap = stack.func_77976_d();
            for (IngredientDistribution distrib : assignedIngredients) {
                if (distrib.slots.length == 0 || !slot.func_75216_d() || !this.canStack(distrib.permutation, stack)) continue;
                int transferCap = Math.min(slotTransferCap, multiplier * distrib.permutation.field_77994_a);
                int stackSize = slot.func_75211_c().field_77994_a;
                boolean pickup = false;
                for (Slot dest : distrib.slots) {
                    int amount = Math.min(transferCap - (dest.func_75216_d() ? dest.func_75211_c().field_77994_a : 0), stackSize);
                    if (stackSize <= amount) {
                        if (!pickup) {
                            FastTransferManager.clickSlot(gui, slot.field_75222_d);
                        }
                        FastTransferManager.clickSlot(gui, dest.field_75222_d);
                        break;
                    }
                    for (int c = 0; c < amount; ++c) {
                        boolean bl = pickup;
                        pickup = true;
                        if (!bl) {
                            FastTransferManager.clickSlot(gui, slot.field_75222_d);
                        }
                        FastTransferManager.clickSlot(gui, dest.field_75222_d, 1);
                        --stackSize;
                    }
                }
                if (thePlayer.field_71071_by.func_70445_o() == null) continue;
                FastTransferManager.clickSlot(gui, slot.field_75222_d);
            }
        }
    }

    protected boolean dropOffMouseStack(EntityPlayer entityPlayer, GuiContainer gui) {
        if (entityPlayer.field_71071_by.func_70445_o() == null) {
            return true;
        }
        for (int i = 0; i < gui.field_147002_h.field_75151_b.size(); ++i) {
            Slot slot = (Slot)gui.field_147002_h.field_75151_b.get(i);
            if (slot.field_75224_c != entityPlayer.field_71071_by) continue;
            ItemStack mouseItem = entityPlayer.field_71071_by.func_70445_o();
            ItemStack slotStack = slot.func_75211_c();
            if (slotStack == null || NEIClientUtils.areStacksSameType(mouseItem, slotStack)) {
                FastTransferManager.clickSlot(gui, i, 0, 0);
            }
            if (entityPlayer.field_71071_by.func_70445_o() != null) continue;
            return true;
        }
        return entityPlayer.field_71071_by.func_70445_o() == null;
    }

    private int calculateRecipeQuantity(List<IngredientDistribution> assignedIngredients) {
        int quantity = Integer.MAX_VALUE;
        for (IngredientDistribution distrib : assignedIngredients) {
            DistributedIngred istack = distrib.distrib;
            if (istack.distributed == 0) continue;
            if (istack.numSlots == 0) {
                return 0;
            }
            int maxStackSize = istack.stack.func_77976_d();
            if (maxStackSize == 1 && istack.isContainerItem) continue;
            int allSlots = Math.min(istack.invAmount, istack.numSlots * maxStackSize);
            quantity = Math.min(quantity, allSlots / istack.distributed);
        }
        if (quantity == Integer.MAX_VALUE) {
            quantity = 1;
        }
        return quantity;
    }

    private Slot[][] assignIngredSlots(GuiContainer gui, List<PositionedStack> ingredients, List<IngredientDistribution> assignedIngredients) {
        Slot[][] recipeSlots = this.mapIngredSlots(gui, ingredients);
        HashMap<Slot, Integer> distribution = new HashMap<Slot, Integer>();
        Slot[][] slotArray = recipeSlots;
        int n = slotArray.length;
        for (int i = 0; i < n; ++i) {
            Slot[] recipeSlot;
            for (Slot slot : recipeSlot = slotArray[i]) {
                if (distribution.containsKey(slot)) continue;
                distribution.put(slot, -1);
            }
        }
        HashSet avaliableSlots = new HashSet(distribution.keySet());
        HashSet<Integer> remainingIngreds = new HashSet<Integer>();
        ArrayList assignedSlots = new ArrayList();
        for (int i = 0; i < ingredients.size(); ++i) {
            remainingIngreds.add(i);
            assignedSlots.add(new LinkedList());
        }
        while (!avaliableSlots.isEmpty() && !remainingIngreds.isEmpty()) {
            Iterator iterator = remainingIngreds.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                boolean assigned = false;
                DistributedIngred istack = assignedIngredients.get((int)i).distrib;
                for (Slot slot : recipeSlots[i]) {
                    if (!avaliableSlots.contains(slot)) continue;
                    avaliableSlots.remove(slot);
                    if (slot.func_75216_d()) continue;
                    ++istack.numSlots;
                    ((LinkedList)assignedSlots.get(i)).add(slot);
                    assigned = true;
                    break;
                }
                if (assigned && istack.numSlots * istack.stack.func_77976_d() < istack.invAmount) continue;
                iterator.remove();
            }
        }
        for (int i = 0; i < ingredients.size(); ++i) {
            assignedIngredients.get((int)i).slots = ((LinkedList)assignedSlots.get(i)).toArray(new Slot[0]);
        }
        return recipeSlots;
    }

    private List<IngredientDistribution> assignIngredients(List<PositionedStack> ingredients, List<DistributedIngred> ingredStacks) {
        ArrayList<IngredientDistribution> assignedIngredients = new ArrayList<IngredientDistribution>();
        for (PositionedStack posstack : ingredients) {
            DistributedIngred biggestIngred = null;
            ItemStack permutation = null;
            int biggestSize = 0;
            block1: for (ItemStack pstack : posstack.items) {
                for (DistributedIngred istack : ingredStacks) {
                    int relsize;
                    if (!this.canStack(pstack, istack.stack) || istack.invAmount - istack.distributed < pstack.field_77994_a || istack.recipeAmount == 0 || pstack.field_77994_a == 0 || (relsize = (istack.invAmount - istack.invAmount / istack.recipeAmount * istack.distributed) / pstack.field_77994_a) <= biggestSize) continue;
                    biggestSize = relsize;
                    biggestIngred = istack;
                    permutation = pstack;
                    continue block1;
                }
            }
            if (biggestIngred == null) {
                biggestIngred = new DistributedIngred(posstack.item);
                permutation = InventoryUtils.copyStack((ItemStack)posstack.item, (int)0);
            }
            biggestIngred.distributed += permutation.field_77994_a;
            assignedIngredients.add(new IngredientDistribution(biggestIngred, permutation));
        }
        return assignedIngredients;
    }

    private void findInventoryQuantities(GuiContainer gui, List<DistributedIngred> ingredStacks) {
        for (Slot slot : gui.field_147002_h.field_75151_b) {
            ItemStack pstack;
            DistributedIngred istack;
            if (!slot.func_75216_d() || !this.canMoveFrom(slot, gui) || (istack = this.findIngred(ingredStacks, pstack = slot.func_75211_c())) == null) continue;
            istack.invAmount += pstack.field_77994_a;
            if (istack.isContainerItem || pstack.func_77976_d() != 1 || !pstack.func_77973_b().hasContainerItem(pstack)) continue;
            NBTTagCompound tagCompound = pstack.func_77978_p();
            if (tagCompound != null && tagCompound.func_74764_b("GT.ToolStats")) {
                istack.isContainerItem = true;
                continue;
            }
            boolean isPausedItemDamageSound = StackInfo.isPausedItemDamageSound();
            StackInfo.pauseItemDamageSound(true);
            ItemStack containerItem = pstack.func_77973_b().getContainerItem(pstack);
            if (containerItem != null) {
                istack.isContainerItem = pstack.func_77973_b() == containerItem.func_77973_b();
            }
            StackInfo.pauseItemDamageSound(isPausedItemDamageSound);
        }
    }

    private List<DistributedIngred> getPermutationIngredients(List<PositionedStack> ingredients) {
        ArrayList<DistributedIngred> ingredStacks = new ArrayList<DistributedIngred>();
        for (PositionedStack posstack : ingredients) {
            for (ItemStack pstack : posstack.items) {
                DistributedIngred istack = this.findIngred(ingredStacks, pstack);
                if (istack == null) {
                    istack = new DistributedIngred(pstack);
                    ingredStacks.add(istack);
                }
                istack.recipeAmount += pstack.field_77994_a;
            }
        }
        return ingredStacks;
    }

    public boolean canMoveFrom(Slot slot, GuiContainer gui) {
        return slot.field_75224_c instanceof InventoryPlayer;
    }

    public Slot[][] mapIngredSlots(GuiContainer gui, List<PositionedStack> ingredients) {
        Slot[][] recipeSlotList = new Slot[ingredients.size()][];
        for (int i = 0; i < ingredients.size(); ++i) {
            LinkedList<Slot> recipeSlots = new LinkedList<Slot>();
            PositionedStack pstack = ingredients.get(i);
            for (Slot slot : gui.field_147002_h.field_75151_b) {
                if (slot.field_75223_e != pstack.relx + this.offsetx || slot.field_75221_f != pstack.rely + this.offsety) continue;
                recipeSlots.add(slot);
                break;
            }
            recipeSlotList[i] = recipeSlots.toArray(new Slot[0]);
        }
        return recipeSlotList;
    }

    public DistributedIngred findIngred(List<DistributedIngred> ingredStacks, ItemStack pstack) {
        for (DistributedIngred istack : ingredStacks) {
            if (!this.canStack(istack.stack, pstack)) continue;
            return istack;
        }
        return null;
    }

    protected boolean canStack(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return true;
        }
        return NEIClientUtils.areStacksSameTypeCraftingWithNBT(stack1, stack2);
    }

    public static class IngredientDistribution {
        public DistributedIngred distrib;
        public ItemStack permutation;
        public Slot[] slots;

        public IngredientDistribution(DistributedIngred distrib, ItemStack permutation) {
            this.distrib = distrib;
            this.permutation = permutation;
        }
    }

    public static class DistributedIngred {
        public ItemStack stack;
        public int invAmount;
        public int distributed;
        public int numSlots;
        public int recipeAmount;
        public boolean isContainerItem = false;

        public DistributedIngred(ItemStack item) {
            this.stack = InventoryUtils.copyStack((ItemStack)item, (int)1);
        }
    }
}

