/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.core.ReflectionManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.DefaultOverlayRenderer;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ShapedRecipeHandler
extends TemplateRecipeHandler {
    @Override
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 23, 24, 18), "crafting", new Object[0]));
    }

    @Override
    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCrafting.class;
    }

    @Override
    public String getRecipeName() {
        return NEIClientUtils.translate("recipe.shaped", new Object[0]);
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("crafting") && this.getClass() == ShapedRecipeHandler.class) {
            for (IRecipe irecipe : CraftingManager.func_77594_a().func_77592_b()) {
                CachedShapedRecipe recipe = null;
                if (irecipe instanceof ShapedRecipes) {
                    ShapedRecipes shaped = (ShapedRecipes)irecipe;
                    recipe = new CachedShapedRecipe(shaped);
                } else if (irecipe instanceof ShapedOreRecipe) {
                    ShapedOreRecipe shaped = (ShapedOreRecipe)irecipe;
                    recipe = this.forgeShapedRecipe(shaped);
                }
                if (recipe == null) continue;
                recipe.computeVisuals();
                this.arecipes.add(recipe);
            }
        } else if (outputId.equals("crafting2x2") && this.getClass() == ShapedRecipeHandler.class) {
            for (IRecipe irecipe : CraftingManager.func_77594_a().func_77592_b()) {
                if (!(irecipe instanceof ShapedRecipes)) continue;
                ShapedRecipes shaped = (ShapedRecipes)irecipe;
                if (shaped.field_77576_b > 2 || shaped.field_77577_c > 2) continue;
                CachedShapedRecipe recipe = new CachedShapedRecipe(shaped);
                recipe.computeVisuals();
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (IRecipe irecipe : CraftingManager.func_77594_a().func_77592_b()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting(irecipe.func_77571_b(), result)) continue;
            CachedShapedRecipe recipe = null;
            if (irecipe instanceof ShapedRecipes) {
                recipe = new CachedShapedRecipe((ShapedRecipes)irecipe);
            } else if (irecipe instanceof ShapedOreRecipe) {
                recipe = this.forgeShapedRecipe((ShapedOreRecipe)irecipe);
            }
            if (recipe == null) continue;
            recipe.computeVisuals();
            this.arecipes.add(recipe);
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        for (IRecipe irecipe : CraftingManager.func_77594_a().func_77592_b()) {
            CachedShapedRecipe recipe = null;
            if (irecipe instanceof ShapedRecipes) {
                recipe = new CachedShapedRecipe((ShapedRecipes)irecipe);
            } else if (irecipe instanceof ShapedOreRecipe) {
                recipe = this.forgeShapedRecipe((ShapedOreRecipe)irecipe);
            }
            if (recipe == null || !recipe.contains(recipe.ingredients, ingredient.func_77973_b())) continue;
            recipe.computeVisuals();
            if (!recipe.contains(recipe.ingredients, ingredient)) continue;
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public CachedShapedRecipe forgeShapedRecipe(ShapedOreRecipe recipe) {
        try {
            Object[] items;
            int width = (Integer)ReflectionManager.getField(ShapedOreRecipe.class, Integer.class, (Object)recipe, (int)4);
            int height = (Integer)ReflectionManager.getField(ShapedOreRecipe.class, Integer.class, (Object)recipe, (int)5);
            for (Object item : items = recipe.getInput()) {
                if (!(item instanceof List) || !((List)item).isEmpty()) continue;
                return null;
            }
            return new CachedShapedRecipe(width, height, items, recipe.func_77571_b());
        }
        catch (Exception e) {
            NEIClientConfig.logger.error("Error loading recipe: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getGuiTexture() {
        return "textures/gui/container/crafting_table.png";
    }

    @Override
    public String getOverlayIdentifier() {
        return "crafting";
    }

    @Override
    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return super.hasOverlay(gui, container, recipe) || this.isRecipe2x2(recipe) && RecipeInfo.hasDefaultOverlay(gui, "crafting2x2");
    }

    @Override
    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipe) {
        IRecipeOverlayRenderer renderer = super.getOverlayRenderer(gui, recipe);
        if (renderer != null) {
            return renderer;
        }
        IStackPositioner positioner = RecipeInfo.getStackPositioner(gui, "crafting2x2");
        if (positioner == null) {
            return null;
        }
        return new DefaultOverlayRenderer(this.getIngredientStacks(recipe), positioner);
    }

    @Override
    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        IOverlayHandler handler = super.getOverlayHandler(gui, recipe);
        if (handler != null) {
            return handler;
        }
        return RecipeInfo.getOverlayHandler(gui, "crafting2x2");
    }

    public boolean isRecipe2x2(int recipe) {
        for (PositionedStack stack : this.getIngredientStacks(recipe)) {
            if (stack.relx <= 43 && stack.rely <= 24) continue;
            return false;
        }
        return true;
    }

    public class CachedShapedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public PositionedStack result;

        public CachedShapedRecipe(int width, int height, Object[] items, ItemStack out) {
            this.result = new PositionedStack(out, 119, 24);
            this.ingredients = new ArrayList();
            this.setIngredients(width, height, items);
        }

        public CachedShapedRecipe(ShapedRecipes recipe) {
            this(recipe.field_77576_b, recipe.field_77577_c, recipe.field_77574_d, recipe.func_77571_b());
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (items[y * width + x] == null) continue;
                    PositionedStack stack = new PositionedStack(items[y * width + x], 25 + x * 18, 6 + y * 18, false);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }

        @Override
        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(ShapedRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        @Override
        public PositionedStack getResult() {
            return this.result;
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
        }
    }
}

