/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.networking;

import appeng.api.AEApi;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.tiles.IWirelessAccessPoint;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.core.AEConfig;
import appeng.me.GridAccessException;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class TileWireless
extends AENetworkInvTile
implements IWirelessAccessPoint,
IPowerChannelState {
    public static final int POWERED_FLAG = 1;
    public static final int CHANNEL_FLAG = 2;
    private final int[] sides = new int[]{0};
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 1);
    private int clientFlags = 0;

    public TileWireless() {
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
        this.getProxy().setValidSides(EnumSet.noneOf(ForgeDirection.class));
    }

    @Override
    public void setOrientation(ForgeDirection inForward, ForgeDirection inUp) {
        super.setOrientation(inForward, inUp);
        this.getProxy().setValidSides(EnumSet.of(this.getForward().getOpposite()));
    }

    @MENetworkEventSubscribe
    public void chanRender(MENetworkChannelsChanged c) {
        this.markForUpdate();
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.markForUpdate();
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TileWireless(ByteBuf data) {
        int old = this.getClientFlags();
        this.setClientFlags(data.readByte());
        return old != this.getClientFlags();
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream_TileWireless(ByteBuf data) {
        this.setClientFlags(0);
        try {
            if (this.getProxy().getEnergy().isNetworkPowered()) {
                this.setClientFlags(this.getClientFlags() | 1);
            }
            if (this.getProxy().getNode().meetsChannelRequirements()) {
                this.setClientFlags(this.getClientFlags() | 2);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        data.writeByte((int)((byte)this.getClientFlags()));
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return AEApi.instance().definitions().materials().wirelessBooster().isSameAs(itemstack);
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        return this.sides;
    }

    @Override
    public void onReady() {
        this.updatePower();
        super.onReady();
    }

    private void updatePower() {
        this.getProxy().setIdlePowerUsage(AEConfig.instance.wireless_getPowerDrain(this.getBoosters()));
    }

    private int getBoosters() {
        ItemStack boosters = this.inv.func_70301_a(0);
        return boosters == null ? 0 : boosters.field_77994_a;
    }

    public void func_70296_d() {
        this.updatePower();
    }

    @Override
    public double getRange() {
        return AEConfig.instance.wireless_getMaxRange(this.getBoosters());
    }

    @Override
    public boolean isActive() {
        if (Platform.isClient()) {
            return this.isPowered() && 2 == (this.getClientFlags() & 2);
        }
        return this.getProxy().isActive();
    }

    @Override
    public IGrid getGrid() {
        try {
            return this.getProxy().getGrid();
        }
        catch (GridAccessException e) {
            return null;
        }
    }

    @Override
    public boolean isPowered() {
        return 1 == (this.getClientFlags() & 1);
    }

    public int getClientFlags() {
        return this.clientFlags;
    }

    private void setClientFlags(int clientFlags) {
        this.clientFlags = clientFlags;
    }
}

