/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.config.group;

import dev.rndmorris.salisarcana.config.ConfigGroup;
import dev.rndmorris.salisarcana.config.settings.IntSetting;
import dev.rndmorris.salisarcana.config.settings.Setting;
import dev.rndmorris.salisarcana.config.settings.ToggleSetting;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class ConfigThaumcraft
extends ConfigGroup {
    private static final String potionCategory = "potion_ids";
    private static final String potionIdComment = "Override the id of the %s potion effect.";
    private static final String primalArrowCategory = "primal_arrows";
    public final ToggleSetting potionIdLimitRaised = (ToggleSetting)((Setting)new ToggleSetting(this, "_uncapped_potion_ids", "If true, will allow setting potion ids to 128 and higher.").setEnabled(false)).setCategory("potion_ids");
    public final IntSetting taintPoisonId = (IntSetting)new IntSetting(this, "taintPoisonId", String.format("Override the id of the %s potion effect.", "Taint Poison"), -1).setMinValue(-1).setCategory("potion_ids");
    public final IntSetting fluxFluId = (IntSetting)new IntSetting(this, "fluxFluId", String.format("Override the id of the %s potion effect.", "Flux Flu"), -1).setMinValue(-1).setCategory("potion_ids");
    public final IntSetting fluxPhageId = (IntSetting)new IntSetting(this, "fluxPhageId", String.format("Override the id of the %s potion effect.", "Flux Phage"), -1).setMinValue(-1).setCategory("potion_ids");
    public final IntSetting unnaturalHungerId = (IntSetting)new IntSetting(this, "unnaturalHungerId", String.format("Override the id of the %s potion effect.", "Unnatural Hunger"), -1).setMinValue(-1).setCategory("potion_ids");
    public final IntSetting warpWardId = (IntSetting)new IntSetting(this, "warpWardId", String.format("Override the id of the %s potion effect.", "Warp Ward"), -1).setMinValue(-1).setCategory("potion_ids");
    public final IntSetting deadlyGazeId = (IntSetting)new IntSetting(this, "deadlyGazeId", String.format("Override the id of the %s potion effect.", "Deadly Gaze"), -1).setMinValue(-1).setCategory("potion_ids");
    public final IntSetting blurredVisionId = (IntSetting)new IntSetting(this, "blurredVisionId", String.format("Override the id of the %s potion effect.", "Blurred Vision"), -1).setMinValue(-1).setCategory("potion_ids");
    public final IntSetting sunScornedId = (IntSetting)new IntSetting(this, "sunScornedId", String.format("Override the id of the %s potion effect.", "Sun Scorned"), -1).setMinValue(-1).setCategory("potion_ids");
    public final IntSetting thaumarhiaId = (IntSetting)new IntSetting(this, "thaumarhiaId", String.format("Override the id of the %s potion effect.", "Thaumarhia"), -1).setMinValue(-1).setCategory("potion_ids");
    public final ToggleSetting primalArrowsCanBeFiredFromDispensers = (ToggleSetting)new ToggleSetting(this, "canBeFiredFromDispensers", "Primal arrows can be shot from dispensers").setCategory("primal_arrows");

    public boolean anyPotionIdOverrideActive() {
        return Arrays.stream(new IntSetting[]{this.taintPoisonId, this.fluxFluId, this.fluxPhageId, this.unnaturalHungerId, this.warpWardId, this.deadlyGazeId, this.blurredVisionId, this.sunScornedId, this.thaumarhiaId}).anyMatch(IntSetting::isEnabled);
    }

    @Override
    @NotNull
    public String getGroupName() {
        return "thaumcraft_configuration";
    }

    @Override
    @NotNull
    public String getGroupComment() {
        return "Additional configuration options for Thaumcraft";
    }

    @Override
    protected Collection<ConfigGroup.CategoryComment> getCategoryComments() {
        return Collections.singletonList(new ConfigGroup.CategoryComment(potionCategory, "Override the ids of Thaumcraft's potion effects. An id not overridden, or that cannot be assigned to its\noverridden id, here will be automatically assigned to the lowest unclaimed id as normal.\n\nWARNING: Do not set any of these values to 128 or higher unless you are using a mod that increases the\nmaximum potion id. If you are, and would like to set these ids to 128 or higher, set\n`_uncapped_potion_ids` to `true`."));
    }
}

