/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.compat;

import java.util.EnumMap;
import net.minecraftforge.common.util.ForgeDirection;

public enum Orientation {
    NONE(ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN),
    DOWN_DOWN(ForgeDirection.DOWN, ForgeDirection.DOWN),
    UP_DOWN(ForgeDirection.UP, ForgeDirection.DOWN),
    NORTH_DOWN(ForgeDirection.NORTH, ForgeDirection.DOWN),
    SOUTH_DOWN(ForgeDirection.SOUTH, ForgeDirection.DOWN),
    WEST_DOWN(ForgeDirection.WEST, ForgeDirection.DOWN),
    EAST_DOWN(ForgeDirection.EAST, ForgeDirection.DOWN),
    DOWN_UP(ForgeDirection.DOWN, ForgeDirection.UP),
    UP_UP(ForgeDirection.UP, ForgeDirection.UP),
    NORTH_UP(ForgeDirection.NORTH, ForgeDirection.UP),
    SOUTH_UP(ForgeDirection.SOUTH, ForgeDirection.UP),
    WEST_UP(ForgeDirection.WEST, ForgeDirection.UP),
    EAST_UP(ForgeDirection.EAST, ForgeDirection.UP),
    DOWN_NORTH(ForgeDirection.DOWN, ForgeDirection.NORTH),
    UP_NORTH(ForgeDirection.UP, ForgeDirection.NORTH),
    NORTH_NORTH(ForgeDirection.NORTH, ForgeDirection.NORTH),
    SOUTH_NORTH(ForgeDirection.SOUTH, ForgeDirection.NORTH),
    WEST_NORTH(ForgeDirection.WEST, ForgeDirection.NORTH),
    EAST_NORTH(ForgeDirection.EAST, ForgeDirection.NORTH),
    DOWN_SOUTH(ForgeDirection.DOWN, ForgeDirection.SOUTH),
    UP_SOUTH(ForgeDirection.UP, ForgeDirection.SOUTH),
    NORTH_SOUTH(ForgeDirection.NORTH, ForgeDirection.SOUTH),
    SOUTH_SOUTH(ForgeDirection.SOUTH, ForgeDirection.SOUTH),
    WEST_SOUTH(ForgeDirection.WEST, ForgeDirection.SOUTH),
    EAST_SOUTH(ForgeDirection.EAST, ForgeDirection.SOUTH),
    DOWN_WEST(ForgeDirection.DOWN, ForgeDirection.WEST),
    UP_WEST(ForgeDirection.UP, ForgeDirection.WEST),
    NORTH_WEST(ForgeDirection.NORTH, ForgeDirection.WEST),
    SOUTH_WEST(ForgeDirection.SOUTH, ForgeDirection.WEST),
    WEST_WEST(ForgeDirection.WEST, ForgeDirection.WEST),
    EAST_WEST(ForgeDirection.EAST, ForgeDirection.WEST),
    DOWN_EAST(ForgeDirection.DOWN, ForgeDirection.EAST),
    UP_EAST(ForgeDirection.UP, ForgeDirection.EAST),
    NORTH_EAST(ForgeDirection.NORTH, ForgeDirection.EAST),
    SOUTH_EAST(ForgeDirection.SOUTH, ForgeDirection.EAST),
    WEST_EAST(ForgeDirection.WEST, ForgeDirection.EAST),
    EAST_EAST(ForgeDirection.EAST, ForgeDirection.EAST);

    public final ForgeDirection a;
    public final ForgeDirection b;
    private static final EnumMap<ForgeDirection, EnumMap<ForgeDirection, Orientation>> ORIENTATIONS;

    private Orientation(ForgeDirection a, ForgeDirection b) {
        this.a = a;
        this.b = b;
    }

    public static Orientation getOrientation(ForgeDirection a, ForgeDirection b) {
        if (a == null) {
            a = ForgeDirection.UNKNOWN;
        }
        if (b == null) {
            b = ForgeDirection.UNKNOWN;
        }
        return ORIENTATIONS.get(a).get(b);
    }

    static {
        ORIENTATIONS = new EnumMap(ForgeDirection.class);
        for (Orientation o : Orientation.values()) {
            ORIENTATIONS.computeIfAbsent(o.a, x -> new EnumMap(ForgeDirection.class)).put(o.b, o);
        }
    }
}

