/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.texture.CableBusTextures;
import appeng.core.settings.TickRates;
import appeng.parts.reporting.AbstractPartMonitor;
import appeng.util.IWideReadableNumberConverter;
import appeng.util.Platform;
import appeng.util.ReadableNumberConverter;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public class PartThroughputMonitor
extends AbstractPartMonitor
implements IGridTickable {
    private static final IWideReadableNumberConverter NUMBER_CONVERTER = ReadableNumberConverter.INSTANCE;
    private static final CableBusTextures FRONT_BRIGHT_ICON = CableBusTextures.PartThroughputMonitor_Bright;
    private static final CableBusTextures FRONT_DARK_ICON = CableBusTextures.PartThroughputMonitor_Dark;
    private static final CableBusTextures FRONT_COLORED_ICON = CableBusTextures.PartThroughputMonitor_Colored;
    private static final CableBusTextures FRONT_COLORED_ICON_LOCKED = CableBusTextures.PartThroughputMonitor_Dark_Locked;
    private TimeUnit timeMode = TimeUnit.Tick;
    private double itemNumsChange = 0.0;
    private long lastStackSize = -1L;

    public PartThroughputMonitor(ItemStack is) {
        super(is);
    }

    @Override
    public CableBusTextures getFrontBright() {
        return FRONT_BRIGHT_ICON;
    }

    @Override
    public CableBusTextures getFrontColored() {
        return this.isLocked() ? FRONT_COLORED_ICON_LOCKED : FRONT_COLORED_ICON;
    }

    @Override
    public CableBusTextures getFrontDark() {
        return FRONT_DARK_ICON;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.timeMode = TimeUnit.fromOrdinal(data.func_74762_e("timeMode"));
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("timeMode", this.timeMode.ordinal());
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeInt(this.timeMode.ordinal());
        data.writeDouble(this.itemNumsChange);
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        boolean needRedraw = super.readFromStream(data);
        this.timeMode = TimeUnit.fromOrdinal(data.readInt());
        this.itemNumsChange = data.readDouble();
        return needRedraw;
    }

    @Override
    public boolean onPartShiftActivate(EntityPlayer player, Vec3 pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getLocation(), player)) {
            return false;
        }
        this.timeMode = this.timeMode.getNext();
        this.host.markForUpdate();
        return true;
    }

    @Override
    public void tesrRenderItemNumber(IAEItemStack ais) {
        GL11.glTranslatef((float)0.0f, (float)0.14f, (float)-0.24f);
        GL11.glScalef((float)0.008333334f, (float)0.008333334f, (float)0.008333334f);
        long stackSize = ais.getStackSize();
        String renderedStackSize = NUMBER_CONVERTER.toWideReadableForm(stackSize);
        String renderedStackSizeChange = (this.itemNumsChange > 0.0 ? "+" : "") + Platform.formatNumberDoubleRestrictedByWidth(this.itemNumsChange, 3) + this.timeMode.label;
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int width = fr.func_78256_a(renderedStackSize);
        GL11.glTranslatef((float)(-0.5f * (float)width), (float)0.0f, (float)-1.0f);
        fr.func_78276_b(renderedStackSize, 0, 0, 0);
        GL11.glTranslatef((float)(0.5f * (float)width), (float)(fr.field_78288_b + 3), (float)-1.0f);
        width = fr.func_78256_a(renderedStackSizeChange);
        GL11.glTranslatef((float)(-0.5f * (float)width), (float)0.0f, (float)-1.0f);
        int color = 0;
        if (this.itemNumsChange < 0.0) {
            color = 0xFF0000;
        } else if (this.itemNumsChange > 0.0) {
            color = 1554028;
        }
        fr.func_78276_b(renderedStackSizeChange, 0, 0, color);
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.ThroughputMonitor.getMin(), TickRates.ThroughputMonitor.getMax(), false, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        if (Platform.isClient()) {
            return TickRateModulation.SAME;
        }
        if (this.getDisplayed() == null) {
            this.lastStackSize = -1L;
            this.host.markForUpdate();
            return TickRateModulation.IDLE;
        }
        long nowStackSize = this.getDisplayed().getStackSize();
        if (this.lastStackSize != -1L) {
            long changeStackSize = nowStackSize - this.lastStackSize;
            this.itemNumsChange = changeStackSize * (long)this.timeMode.totalTicks / (long)TicksSinceLastCall;
            this.host.markForUpdate();
        }
        this.lastStackSize = nowStackSize;
        return TickRateModulation.FASTER;
    }

    private static enum TimeUnit {
        Tick("/t", 1),
        Second("/s", 20),
        Minute("/m", 1200),
        Hour("/h", 72000);

        String label;
        int totalTicks;

        private TimeUnit(String label, int totalTicks) {
            this.totalTicks = totalTicks;
            this.label = label;
        }

        public TimeUnit getNext() {
            if (this.ordinal() == TimeUnit.values().length - 1) {
                return Tick;
            }
            return TimeUnit.values()[this.ordinal() + 1];
        }

        public static TimeUnit fromOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal >= TimeUnit.values().length) {
                return Tick;
            }
            return TimeUnit.values()[ordinal];
        }
    }
}

