/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.effects;

import ca.wescook.nutrition.data.PlayerDataHandler;
import ca.wescook.nutrition.effects.Effect;
import ca.wescook.nutrition.effects.EffectsList;
import ca.wescook.nutrition.nutrients.Nutrient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;

public class EffectsManager {
    public static void reapplyEffects(EntityPlayer player) {
        List<Effect> effects = EffectsManager.removeDuplicates(EffectsManager.getEffectsInThreshold(player));
        for (Effect effect : effects) {
            player.func_70690_d(new PotionEffect(effect.potion.field_76415_H, 619, effect.amplifier));
        }
    }

    private static List<Effect> getEffectsInThreshold(EntityPlayer player) {
        ArrayList<Effect> effectsInThreshold = new ArrayList<Effect>();
        Map<Nutrient, Float> playerNutrition = PlayerDataHandler.getForPlayer(player).get();
        block6: for (Effect effect : EffectsList.get()) {
            block0 : switch (effect.detectionType) {
                case ANY: {
                    for (Nutrient nutrient : effect.nutrients) {
                        if (!(playerNutrition.get(nutrient).floatValue() >= (float)effect.minimum) || !(playerNutrition.get(nutrient).floatValue() <= (float)effect.maximum)) continue;
                        effectsInThreshold.add(effect);
                        break block0;
                    }
                    continue block6;
                }
                case AVERAGE: {
                    Float total = Float.valueOf(0.0f);
                    for (Nutrient nutrient : effect.nutrients) {
                        total = Float.valueOf(total.floatValue() + playerNutrition.get(nutrient).floatValue());
                    }
                    int size = effect.nutrients.size();
                    float f = size != 0 ? total.floatValue() / (float)size : -1.0f;
                    float average = f;
                    if (!(average >= (float)effect.minimum) || !(average <= (float)effect.maximum)) continue block6;
                    effectsInThreshold.add(effect);
                    break;
                }
                case ALL: {
                    boolean allWithinThreshold = true;
                    for (Nutrient nutrient : effect.nutrients) {
                        if (playerNutrition.get(nutrient).floatValue() >= (float)effect.minimum && playerNutrition.get(nutrient).floatValue() <= (float)effect.maximum) continue;
                        allWithinThreshold = false;
                    }
                    if (!allWithinThreshold) continue block6;
                    effectsInThreshold.add(effect);
                    break;
                }
                case CUMULATIVE: {
                    int cumulativeCount = 0;
                    for (Nutrient nutrient : effect.nutrients) {
                        if (!(playerNutrition.get(nutrient).floatValue() >= (float)effect.minimum) || !(playerNutrition.get(nutrient).floatValue() <= (float)effect.maximum)) continue;
                        ++cumulativeCount;
                    }
                    effect.amplifier = cumulativeCount * effect.cumulativeModifier - 1;
                    if (cumulativeCount <= 0) break;
                    effectsInThreshold.add(effect);
                }
            }
        }
        return effectsInThreshold;
    }

    private static List<Effect> removeDuplicates(List<Effect> effectsInput) {
        ArrayList<Effect> effectsOutput = new ArrayList<Effect>();
        boolean foundMatch = false;
        for (Effect effectIn : effectsInput) {
            for (Effect effectOut : effectsOutput) {
                if (effectIn.potion != effectOut.potion) continue;
                if (effectIn.amplifier > effectOut.amplifier) {
                    int listIndex = effectsOutput.indexOf(effectOut);
                    effectsOutput.add(listIndex, effectIn);
                }
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            effectsOutput.add(effectIn);
        }
        return effectsOutput;
    }
}

