/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity.guide;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.shader.TesselatorVertexState;
import net.minecraft.util.ResourceLocation;
import openblocks.shapes.CoordShape;
import openmods.renderer.shaders.ArraysHelper;
import openmods.renderer.shaders.BufferHelper;
import openmods.renderer.shaders.ShaderProgram;
import openmods.renderer.shaders.ShaderProgramBuilder;

public class MarkerRenderer {
    private static final ResourceLocation vertexSource = new ResourceLocation("openblocks:shaders/shader.vert");
    private static final ResourceLocation fragmentSource = new ResourceLocation("openblocks:shaders/shader.frag");
    private final ShaderProgram shader;
    private static final int nativeBufferSize = 0x200000;
    private final ByteBuffer byteBuffer = GLAllocation.func_74524_c((int)0x800000);
    private final IntBuffer intBuffer = this.byteBuffer.asIntBuffer();
    private final Runnable model;
    private boolean initialized;
    private boolean hasTexture;
    private boolean hasColor;
    private boolean shouldRefresh = true;
    private int vertexCount;
    private int vao;
    private int vbo;

    public MarkerRenderer(Runnable model) {
        this.model = model;
        ShaderProgramBuilder shaderProgramBuilder = new ShaderProgramBuilder();
        shaderProgramBuilder.addShader(vertexSource, 35633);
        shaderProgramBuilder.addShader(fragmentSource, 35632);
        this.shader = shaderProgramBuilder.build();
    }

    public void reset() {
        this.shouldRefresh = true;
    }

    private void createModel() {
        this.model.run();
        TesselatorVertexState state = Tessellator.field_78398_a.func_147564_a(0.0f, 0.0f, 0.0f);
        Tessellator.field_78398_a.func_78381_a();
        if (state.func_147572_a().length > 0x200000) {
            throw new UnsupportedOperationException("Big buffers not supported!");
        }
        this.vertexCount = state.func_147575_c();
        this.byteBuffer.position(0);
        this.intBuffer.clear();
        this.intBuffer.put(state.func_147572_a(), 0, this.vertexCount * 8);
        this.byteBuffer.position(0);
        this.byteBuffer.limit(this.vertexCount * 32);
        this.hasTexture = state.func_147573_d();
        this.hasColor = state.func_147574_g();
    }

    private void createVAO() {
        if (this.initialized) {
            this.createModel();
            if (this.vao == 0) {
                this.vao = ArraysHelper.methods().glGenVertexArrays();
            }
            ArraysHelper.methods().glBindVertexArray(this.vao);
            if (this.vbo == 0) {
                this.vbo = BufferHelper.methods().glGenBuffers();
            }
            BufferHelper.methods().glBindBuffer(34962, this.vbo);
            BufferHelper.methods().glBufferData(34962, this.byteBuffer, 35044);
            this.shader.attributePointer("aVertex", 3, 5126, false, 32, 0L);
            this.shader.attributePointer("aTexCoord", 2, 5126, false, 32, 12L);
            this.shader.attributePointer("aColor", 4, 5121, false, 32, 20L);
            BufferHelper.methods().glBindBuffer(34962, 0);
            this.shader.uniform1f("uHasTexture", this.hasTexture ? 1.0f : 0.0f);
            this.shader.uniform1f("uHasColor", this.hasColor ? 1.0f : 0.0f);
            this.shader.uniform1i("uDefaultTexture", 0);
            ArraysHelper.methods().glBindVertexArray(0);
            this.shouldRefresh = false;
        }
    }

    public void drawInstanced(CoordShape shape, int color, float scale) {
        this.shader.bind();
        this.initialized = true;
        if (this.shouldRefresh) {
            this.createVAO();
        }
        ArraysHelper.methods().glBindVertexArray(this.vao);
        shape.bindVBO();
        this.shader.instanceAttributePointer("aPosition", 3, 5124, false, 0, 0L);
        BufferHelper.methods().glBindBuffer(34962, 0);
        this.shader.uniform3f("uColor", (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        this.shader.uniform1f("uScale", scale);
        ArraysHelper.methods().glDrawArraysInstanced(7, 0, this.vertexCount, shape.size());
        ArraysHelper.methods().glBindVertexArray(0);
        this.shader.release();
    }

    public void deleteShape(CoordShape shape) {
        if (this.initialized) {
            ArraysHelper.methods().glBindVertexArray(this.vao);
            shape.destroy();
            ArraysHelper.methods().glBindVertexArray(0);
        }
    }
}

