/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.skeleton;

import java.util.Random;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.DataWatcherHelper;
import toast.specialMobs.Properties;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.ISpecialMob;
import toast.specialMobs.entity.SpecialMobData;

public class Entity_SpecialSkeleton
extends EntitySkeleton
implements ISpecialMob {
    private static final double BABY_CHANCE = Properties.getDouble("_mob_stats", "baby_skeleton_chance");
    private static final double BOW_CHANCE = Properties.getDouble("_mob_stats", "bow_chance_skeleton");
    private static final double BOW_CHANCE_WITHER = Properties.getDouble("_mob_stats", "bow_chance_wither");
    private static final UUID babySpeedBoostUUID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier babySpeedBoostModifier = new AttributeModifier(babySpeedBoostUUID, "Baby speed boost", 0.5, 1);
    private static final byte DW_IS_BABY = DataWatcherHelper.instance.SKELETON.nextKey();
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("textures/entity/skeleton/skeleton.png"), new ResourceLocation("textures/entity/skeleton/wither_skeleton.png")};
    private float adultWidth = -1.0f;
    private float adultHeight;
    public EntityAIArrowAttack field_85037_d;
    public EntityAIAttackOnCollide field_85038_e;
    private SpecialMobData specialData;

    public Entity_SpecialSkeleton(World world) {
        super(world);
    }

    protected void func_70088_a() {
        this.specialData = new SpecialMobData((EntityLiving)this, TEXTURES);
        super.func_70088_a();
        this.field_70180_af.func_75682_a((int)DW_IS_BABY, (Object)0);
        this.initTypeAI();
    }

    protected void initTypeAI() {
        this.setRangedAI(1.0, 20, 60, 15.0f);
        this.setMeleeAI(1.2);
    }

    protected void loadRangedAI() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.field_85037_d);
        SpecialMobData data = this.getSpecialData();
        this.field_85037_d = new EntityAIArrowAttack((IRangedAttackMob)this, (double)data.arrowMoveSpeed, (int)data.arrowRefireMin, (int)data.arrowRefireMax, data.arrowRange);
        this.func_85036_m();
    }

    protected void setRangedAI(double moveSpeed, int minDelay, int maxDelay, float range) {
        SpecialMobData data = this.getSpecialData();
        data.arrowMoveSpeed = (float)moveSpeed;
        data.arrowRefireMin = (short)minDelay;
        data.arrowRefireMax = (short)maxDelay;
        data.arrowRange = range;
        this.field_85037_d = new EntityAIArrowAttack((IRangedAttackMob)this, (double)data.arrowMoveSpeed, (int)data.arrowRefireMin, (int)data.arrowRefireMax, data.arrowRange);
    }

    protected void setMeleeAI(double moveSpeed) {
        this.field_85038_e = new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, moveSpeed, false);
    }

    @Override
    public SpecialMobData getSpecialData() {
        return this.specialData;
    }

    @Override
    public void adjustEntityAttributes() {
        ItemStack itemStack;
        if (this.field_70146_Z.nextDouble() < BABY_CHANCE) {
            this.setChild(true);
        }
        if (this.func_82202_m() == 1) {
            this.field_70178_ae = true;
            if (this.field_70146_Z.nextDouble() < BOW_CHANCE_WITHER) {
                itemStack = new ItemStack((Item)Items.field_151031_f);
                float tension = this.field_70170_p.func_147462_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70146_Z.nextFloat() < 0.25f * tension) {
                    try {
                        EnchantmentHelper.func_77504_a((Random)this.field_70146_Z, (ItemStack)itemStack, (int)((int)(5.0f + tension * (float)this.field_70146_Z.nextInt(18))));
                    }
                    catch (Exception ex) {
                        _SpecialMobs.console("Error applying enchantments! entity:" + this.toString());
                        ex.printStackTrace();
                    }
                }
                this.func_70062_b(0, itemStack);
            }
        } else if (this.field_70146_Z.nextDouble() >= BOW_CHANCE) {
            itemStack = new ItemStack(Items.field_151052_q);
            float tension = this.field_70170_p.func_147462_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (this.field_70146_Z.nextFloat() < 0.25f * tension) {
                try {
                    EnchantmentHelper.func_77504_a((Random)this.field_70146_Z, (ItemStack)itemStack, (int)((int)(5.0f + tension * (float)this.field_70146_Z.nextInt(18))));
                }
                catch (Exception ex) {
                    _SpecialMobs.console("Error applying enchantments! entity:" + this.toString());
                    ex.printStackTrace();
                }
            }
            this.func_70062_b(0, itemStack);
        }
        float prevMax = this.func_110138_aP();
        this.adjustTypeAttributes();
        this.func_70606_j(this.func_110138_aP() + this.func_110143_aJ() - prevMax);
    }

    protected void adjustTypeAttributes() {
    }

    public void func_82196_d(EntityLivingBase target, float range) {
        EntityArrow arrow = new EntityArrow(this.field_70170_p, (EntityLivingBase)this, target, 1.6f, this.getTypeArrowSpread());
        arrow.func_70239_b((double)(range * this.getSpecialData().arrowDamage) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.field_73013_u.func_151525_a() * 0.11f));
        int power = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)this.func_70694_bm());
        int punch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)this.func_70694_bm());
        if (power > 0) {
            arrow.func_70239_b(arrow.func_70242_d() + (double)power * 0.5 + 0.5);
        }
        if (punch > 0) {
            arrow.func_70240_a(punch);
        }
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)this.func_70694_bm()) > 0 || this.func_82202_m() == 1) {
            arrow.func_70015_d(100);
        }
        this.func_85030_a("random.bow", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)arrow);
    }

    protected float getTypeArrowSpread() {
        return this.getSpecialData().arrowSpread - (float)this.field_70170_p.field_73013_u.func_151525_a() * (this.getSpecialData().arrowSpread / 4.0f + 0.5f);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.getSpecialData().onUpdate();
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        return this.getSpecialData().onSpawnWithEgg(data, (EntityLiving)new EntitySkeleton(this.field_70170_p));
    }

    public boolean func_70631_g_() {
        return this.getChild();
    }

    public boolean getChild() {
        return this.field_70180_af.func_75683_a((int)DW_IS_BABY) == 1;
    }

    public void setChild(boolean value) {
        this.field_70180_af.func_75692_b((int)DW_IS_BABY, (Object)((byte)(value ? 1 : 0)));
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            IAttributeInstance attribute = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            attribute.func_111124_b(babySpeedBoostModifier);
            if (value) {
                attribute.func_111121_a(babySpeedBoostModifier);
            }
        }
        this.updateScale(value);
    }

    protected void func_70105_a(float width, float height) {
        boolean alreadyScaled = this.adultWidth > 0.0f && this.adultHeight > 0.0f;
        this.adultWidth = width;
        this.adultHeight = height;
        if (!alreadyScaled) {
            this.updateScale();
        }
    }

    protected void updateScale() {
        this.updateScale(this.func_70631_g_());
    }

    protected void updateScale(boolean isChild) {
        float scale = !this.field_70170_p.field_72995_K && this.func_70631_g_() ? 0.5f : 1.0f;
        super.func_70105_a(this.adultWidth * scale, this.adultHeight * scale);
    }

    public boolean func_70652_k(Entity target) {
        this.func_71038_i();
        if (super.func_70652_k(target)) {
            this.onTypeAttack(target);
            return true;
        }
        return false;
    }

    protected void onTypeAttack(Entity target) {
    }

    public void func_85036_m() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.field_85038_e);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.field_85037_d);
        ItemStack itemStack = this.func_70694_bm();
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemBow) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.field_85037_d);
        } else {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.field_85038_e);
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74757_a("IsBaby", this.getChild());
        this.getSpecialData().isImmuneToFire = this.field_70178_ae;
        this.getSpecialData().writeToNBT(saveTag);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_74764_b("IsBaby")) {
            this.setChild(saveTag.func_74767_n("IsBaby"));
        } else if (tag.func_74764_b("IsBaby")) {
            this.setChild(tag.func_74767_n("IsBaby"));
        }
        this.getSpecialData().readFromNBT(tag);
        this.getSpecialData().readFromNBT(saveTag);
        this.field_70178_ae = this.getSpecialData().isImmuneToFire;
        this.loadRangedAI();
    }

    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
    }

    public void func_82201_a(int type) {
        super.func_82201_a(type);
        this.field_70178_ae = this.getSpecialData().isImmuneToFire;
    }

    public int func_70658_aO() {
        return Math.min(20, super.func_70658_aO() + this.getSpecialData().armor);
    }

    public void func_70015_d(int time) {
        if (!this.getSpecialData().isImmuneToBurning) {
            super.func_70015_d(time);
        }
    }

    public boolean func_110164_bC() {
        return !this.func_110167_bD() && this.getSpecialData().allowLeashing;
    }

    public void func_70110_aj() {
        if (!this.getSpecialData().isImmuneToWebs) {
            super.func_70110_aj();
        }
    }

    protected void func_70069_a(float distance) {
        if (!this.getSpecialData().isImmuneToFalling) {
            super.func_70069_a(distance);
        }
    }

    public boolean func_145773_az() {
        return this.getSpecialData().ignorePressurePlates;
    }

    public boolean func_70648_aU() {
        return this.getSpecialData().canBreatheInWater;
    }

    public boolean func_96092_aw() {
        return !this.getSpecialData().ignoreWaterPush;
    }

    public boolean func_70687_e(PotionEffect effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }
}

