/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.kuba6000.mobsinfo.CommonProxy;
import com.kuba6000.mobsinfo.network.LoadConfigPacket;
import com.kuba6000.mobsinfo.network.SaveDataPacket;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="mobsinfo", version="0.5.4-GTNH", name="MobsInfo", acceptedMinecraftVersions="[1.7.10]", dependencies="required-after: gtnhmixins@[2.0.1,); required-after: NotEnoughItems; after: EnderIO; after: Thaumcraft; after: InfernalMobs; after: MineTweaker3; ")
public class MobsInfo {
    public static final String MODID = "mobsinfo";
    public static final String MODNAME = "MobsInfo";
    @Mod.Instance
    public static MobsInfo instance;
    public static ModContainer container;
    public static final SimpleNetworkWrapper NETWORK;
    private static final Logger LOG;
    @SidedProxy(clientSide="com.kuba6000.mobsinfo.ClientProxy", serverSide="com.kuba6000.mobsinfo.CommonProxy")
    public static CommonProxy proxy;
    private static EventBus masterEventBus;

    @Subscribe
    public void iAmDependingOnEverything(FMLEvent event) {
        if (event instanceof FMLPreInitializationEvent) {
            LOG.info("I Am Depending On Everything -> reordering mod load order!");
            List list = Loader.instance().getActiveModList();
            list.remove(container);
            list.add(container);
            masterEventBus.unregister((Object)this);
        }
    }

    @Mod.EventHandler
    public void construction(FMLConstructionEvent event) {
        container = Loader.instance().activeModContainer();
        if (!Loader.isModLoaded((String)"JustAnotherSpawner")) {
            return;
        }
        LOG.info("Found JustAnotherSpawner mod, hacking load order");
        try {
            Field loaderControllerField = Loader.class.getDeclaredField("modController");
            loaderControllerField.setAccessible(true);
            LoadController controller = (LoadController)loaderControllerField.get(Loader.instance());
            Field masterEventBusField = LoadController.class.getDeclaredField("masterChannel");
            masterEventBusField.setAccessible(true);
            masterEventBus = (EventBus)masterEventBusField.get(controller);
            masterEventBus.register((Object)this);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        proxy.loadComplete(event);
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        proxy.serverAboutToStart(event);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        proxy.serverStarting(event);
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        proxy.serverStarted(event);
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        proxy.serverStopping(event);
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        proxy.serverStopped(event);
    }

    public static void debug(String message) {
        LOG.debug(message);
    }

    public static void info(String message) {
        LOG.info(message);
    }

    public static void warn(String message) {
        LOG.warn(message);
    }

    public static void error(String message) {
        LOG.error(message);
    }

    static {
        NETWORK = new SimpleNetworkWrapper(MODID);
        NETWORK.registerMessage((IMessageHandler)new LoadConfigPacket.Handler(), LoadConfigPacket.class, 0, Side.CLIENT);
        NETWORK.registerMessage((IMessageHandler)new SaveDataPacket.Handler(), SaveDataPacket.class, 1, Side.CLIENT);
        LOG = LogManager.getLogger((String)MODID);
    }
}

