/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocator;

import codechicken.core.ClientUtils;
import codechicken.lib.colour.CustomGradient;
import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.SwapYZ;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.translocator.RenderParticle;
import codechicken.translocator.TileItemTranslocator;
import codechicken.translocator.TileLiquidTranslocator;
import codechicken.translocator.TileTranslocator;
import java.util.Map;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class TileTranslocatorRenderer
extends TileEntitySpecialRenderer {
    public static Vector3[] sidePos = new Vector3[]{new Vector3(0.5, 0.0, 0.5), new Vector3(0.5, 1.0, 0.5), new Vector3(0.5, 0.5, 0.0), new Vector3(0.5, 0.5, 1.0), new Vector3(0.0, 0.5, 0.5), new Vector3(1.0, 0.5, 0.5)};
    public static Vector3[] sideVec = new Vector3[]{new Vector3(0.0, -1.0, 0.0), new Vector3(0.0, 1.0, 0.0), new Vector3(0.0, 0.0, -1.0), new Vector3(0.0, 0.0, 1.0), new Vector3(-1.0, 0.0, 0.0), new Vector3(1.0, 0.0, 0.0)};
    public static CCModel[] plates = new CCModel[6];
    public static CCModel insert;
    private CustomGradient gradient = new CustomGradient(new ResourceLocation("translocator", "textures/grad.png"));

    public void func_147500_a(TileEntity tileentity, double x, double y, double z, float f) {
        TileTranslocator ttrans = (TileTranslocator)tileentity;
        double time = ClientUtils.getRenderTime();
        CCRenderState state = CCRenderState.instance();
        state.reset();
        CCRenderState.changeTexture((String)"translocator:textures/tex.png");
        state.pullLightmap();
        state.useNormals = true;
        CCRenderState.setColour((int)-1);
        CCRenderState.startDrawing((int)4);
        for (int i = 0; i < 6; ++i) {
            TileTranslocator.Attachment a = ttrans.attachments[i];
            if (a == null) continue;
            TileTranslocatorRenderer.renderAttachment(i, ttrans.func_145832_p(), MathHelper.interpolate((double)a.b_insertpos, (double)a.a_insertpos, (double)f), a.getIconIndex(), x, y, z);
        }
        state.draw();
        if (ttrans instanceof TileItemTranslocator) {
            TileItemTranslocator titrans = (TileItemTranslocator)ttrans;
            for (TileItemTranslocator.MovingItem movingItem : titrans.movingItems) {
                GL11.glPushMatrix();
                double d = MathHelper.interpolate((double)movingItem.b_progress, (double)movingItem.a_progress, (double)f);
                Vector3 pos = TileTranslocatorRenderer.getPath(movingItem.src, movingItem.dst, d).add(this.itemFloat(movingItem.src, movingItem.dst, d));
                GL11.glTranslated((double)(x + pos.x), (double)(y + pos.y - 0.06), (double)(z + pos.z));
                GL11.glScaled((double)0.35, (double)0.35, (double)0.35);
                RenderUtils.renderItemUniform((ItemStack)movingItem.stack);
                GL11.glPopMatrix();
            }
        }
        if (ttrans instanceof TileLiquidTranslocator) {
            TileLiquidTranslocator tltrans = (TileLiquidTranslocator)ttrans;
            for (TileLiquidTranslocator.MovingLiquid movingLiquid : tltrans.movingLiquids()) {
                double start = MathHelper.interpolate((double)movingLiquid.b_start, (double)movingLiquid.a_start, (double)f);
                double end = MathHelper.interpolate((double)movingLiquid.b_end, (double)movingLiquid.a_end, (double)f);
                this.drawLiquidSpiral(movingLiquid.src, movingLiquid.dst, movingLiquid.liquid, start, end, time, 0.0, x, y, z);
                if (!movingLiquid.fast) continue;
                this.drawLiquidSpiral(movingLiquid.src, movingLiquid.dst, movingLiquid.liquid, start, end, time, 0.5, x, y, z);
            }
        }
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        CCRenderState.changeTexture((String)"translocator:textures/particle.png");
        CCRenderState.startDrawing((int)7);
        for (int src = 0; src < 6; ++src) {
            TileTranslocator.Attachment asrc = ttrans.attachments[src];
            if (asrc == null || !asrc.a_eject) continue;
            for (int i = 0; i < 6; ++i) {
                TileTranslocator.Attachment adst = ttrans.attachments[i];
                if (adst == null || adst.a_eject) continue;
                this.renderLink(src, i, time, ttrans.field_145851_c, ttrans.field_145848_d, ttrans.field_145849_e);
            }
        }
        state.draw();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
    }

    private void drawLiquidSpiral(int src, int dst, FluidStack stack, double start, double end, double time, double theta0, double x, double y, double z) {
        IIcon tex = RenderUtils.prepareFluidRender((FluidStack)stack, (int)255);
        CCRenderState state = CCRenderState.instance();
        CCRenderState.startDrawing((int)7);
        Tessellator t = Tessellator.field_78398_a;
        t.func_78373_b(x, y, z);
        Vector3[] last = new Vector3[]{new Vector3(), new Vector3(), new Vector3(), new Vector3()};
        Vector3[] next = new Vector3[]{new Vector3(), new Vector3(), new Vector3(), new Vector3()};
        double tess = 0.05;
        Vector3 a = TileTranslocatorRenderer.getPerp(src, dst);
        boolean rev = this.sum(a.copy().crossProduct(TileTranslocatorRenderer.getPathNormal(src, dst, 0.0))) != this.sum(sideVec[src]);
        for (double di = end; di <= start; di += tess) {
            Vector3 b = TileTranslocatorRenderer.getPathNormal(src, dst, di);
            Vector3 c = TileTranslocatorRenderer.getPath(src, dst, di);
            if (rev) {
                b.negate();
            }
            double r = (2.0 * di - time / 10.0 + theta0 + (double)(dst / 6)) * 2.0 * Math.PI;
            double sz = 0.1;
            Vector3 p = c.add(a.copy().multiply(MathHelper.sin((double)r) * sz)).add(b.copy().multiply(MathHelper.cos((double)r) * sz));
            double s1 = 0.02;
            double s2 = -0.02;
            next[0].set(p).add(a.x * s1 + b.x * s1, a.y * s1 + b.y * s1, a.z * s1 + b.z * s1);
            next[1].set(p).add(a.x * s2 + b.x * s1, a.y * s2 + b.y * s1, a.z * s2 + b.z * s1);
            next[2].set(p).add(a.x * s2 + b.x * s2, a.y * s2 + b.y * s2, a.z * s2 + b.z * s2);
            next[3].set(p).add(a.x * s1 + b.x * s2, a.y * s1 + b.y * s2, a.z * s1 + b.z * s2);
            if (di > end) {
                double u1 = tex.func_94214_a(Math.abs(di) * 16.0);
                double u2 = tex.func_94214_a(Math.abs(di - tess) * 16.0);
                for (int i = 0; i < 4; ++i) {
                    int j = (i + 1) % 4;
                    Vector3 axis = next[j].copy().subtract(next[i]);
                    double v1 = tex.func_94207_b(Math.abs(next[i].scalarProject(axis)) * 16.0);
                    double v2 = tex.func_94207_b(Math.abs(next[j].scalarProject(axis)) * 16.0);
                    t.func_78374_a(next[i].x, next[i].y, next[i].z, u1, v1);
                    t.func_78374_a(next[j].x, next[j].y, next[j].z, u1, v2);
                    t.func_78374_a(last[j].x, last[j].y, last[j].z, u2, v2);
                    t.func_78374_a(last[i].x, last[i].y, last[i].z, u2, v1);
                }
            }
            Vector3[] tmp = last;
            last = next;
            next = tmp;
        }
        state.draw();
        t.func_78373_b(0.0, 0.0, 0.0);
        RenderUtils.postFluidRender();
    }

    private double sum(Vector3 v) {
        return v.x + v.y + v.z;
    }

    private void renderLink(int src, int dst, double time, int x, int y, int z) {
        double d = (time + (double)src + (double)(dst * 2)) % 10.0 / 6.0;
        for (int n = 0; n < 20; ++n) {
            double dn = d - (double)n * 0.1;
            int spriteX = (int)(7.0 - (double)n * 1.5 - d * 2.0);
            if (!MathHelper.between((double)0.0, (double)dn, (double)1.0) || spriteX < 0) continue;
            Vector3 pos = TileTranslocatorRenderer.getPath(src, dst, dn).add((double)x, (double)y, (double)z);
            double b = 1.0;
            double s = 1.0;
            double u1 = (double)spriteX / 8.0;
            double u2 = u1 + 0.125;
            double v1 = 0.0;
            double v2 = 1.0;
            RenderParticle.render(pos.x, pos.y, pos.z, this.gradient.getColour((dn - 0.5) * 1.2 + 0.5).multiplyC(b), s * 0.12, u1, v1, u2, v2);
        }
    }

    private Vector3 itemFloat(int src, int dst, double d) {
        return TileTranslocatorRenderer.getPerp(src, dst).multiply(0.01 * MathHelper.sin((double)(d * 4.0 * Math.PI)));
    }

    public static Vector3 getPath(int src, int dst, double d) {
        Vector3 v;
        if ((src ^ 1) == dst) {
            v = sideVec[src ^ 1].copy().multiply(d);
        } else {
            Vector3 vsrc = sideVec[src ^ 1];
            Vector3 vdst = sideVec[dst ^ 1];
            Vector3 a = vsrc.copy().multiply(0.3125);
            Vector3 b = vdst.copy().multiply(0.375);
            double sind = MathHelper.sin((double)(d * Math.PI / 2.0));
            double cosd = MathHelper.cos((double)(d * Math.PI / 2.0));
            v = a.multiply(sind).add(b.multiply(cosd - 1.0)).add(vsrc.copy().multiply(0.1875));
        }
        return v.add(sidePos[src]);
    }

    public static Vector3 getPerp(int src, int dst) {
        if ((src ^ 1) == dst) {
            return sideVec[(src + 2) % 6].copy();
        }
        for (int i = 0; i < 3; ++i) {
            if (i == src / 2 || i == dst / 2) continue;
            return sideVec[i * 2].copy();
        }
        return null;
    }

    private static Vector3 getPathNormal(int src, int dst, double d) {
        if ((src ^ 1) == dst) {
            return sideVec[(src + 4) % 6].copy();
        }
        double sind = MathHelper.sin((double)(d * Math.PI / 2.0));
        double cosd = MathHelper.cos((double)(d * Math.PI / 2.0));
        Vector3 vsrc = sideVec[src ^ 1].copy();
        Vector3 vdst = sideVec[dst ^ 1].copy();
        return vsrc.multiply(sind).add(vdst.multiply(cosd)).normalize();
    }

    public static void renderAttachment(int i, int type, double insertpos, int field, double x, double y, double z) {
        double tx = (double)field / 64.0;
        double ty = (double)type / 2.0;
        plates[i].render(x + 0.5, y + 0.5, z + 0.5, tx, ty);
        Matrix4 matrix = new Matrix4().translate(new Vector3(x + 0.5, y + 0.5, z + 0.5)).apply(Rotation.sideRotations[i]).translate(new Vector3(0.0, -0.5, 0.0)).scale(new Vector3(1.0, insertpos * 2.0 / 3.0 + 0.3333333333333333, 1.0));
        insert.render((Transformation)matrix, tx, ty);
    }

    static {
        Map models = CCModel.parseObjModels((ResourceLocation)new ResourceLocation("translocator", "models/model.obj"), (Transformation)new SwapYZ());
        TileTranslocatorRenderer.plates[0] = (CCModel)models.get("Plate");
        insert = (CCModel)models.get("Insert");
        CCModel.generateSidedModels((CCModel[])plates, (int)0, (Vector3)new Vector3());
    }
}

