/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.data;

import baubles.api.BaublesApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import makeo.gadomancy.client.util.FamiliarHandlerClient;
import makeo.gadomancy.common.data.AbstractData;
import makeo.gadomancy.common.familiar.FamiliarController;
import makeo.gadomancy.common.items.baubles.ItemEtherealFamiliar;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;

public class DataFamiliar
extends AbstractData {
    private List<FamiliarData> playersWithFamiliar = new ArrayList<FamiliarData>();
    private Map<EntityPlayer, FamiliarController> familiarControllers = new HashMap<EntityPlayer, FamiliarController>();
    private List<FamiliarData> addClientQueue = new ArrayList<FamiliarData>();
    private List<FamiliarData> removeClientQueue = new ArrayList<FamiliarData>();

    public boolean hasFamiliar(EntityPlayer player) {
        for (FamiliarData fam : this.playersWithFamiliar) {
            if (!fam.owner.equals(player.func_70005_c_())) continue;
            return true;
        }
        return false;
    }

    public void handleEquip(World world, EntityPlayer player, Aspect aspect) {
        if (world.field_72995_K) {
            return;
        }
        String playerName = player.func_70005_c_();
        FamiliarData data = new FamiliarData(playerName, aspect.getTag());
        if (!this.addClientQueue.contains(data)) {
            this.addClientQueue.add(data);
        }
        if (!this.playersWithFamiliar.contains(data)) {
            this.playersWithFamiliar.add(data);
        }
        this.markDirty();
        if (!this.familiarControllers.containsKey(player)) {
            FamiliarController controller = new FamiliarController(player);
            this.familiarControllers.put(player, controller);
        }
    }

    public void handleUnequip(World world, EntityPlayer player, Aspect aspect) {
        if (world.field_72995_K) {
            return;
        }
        String playerName = player.func_70005_c_();
        FamiliarData data = new FamiliarData(playerName, aspect.getTag());
        if (!this.removeClientQueue.contains(data)) {
            this.removeClientQueue.add(data);
        }
        this.playersWithFamiliar.remove(data);
        this.markDirty();
        this.familiarControllers.remove(player);
    }

    public void equipTick(World world, EntityPlayer player, Aspect aspect) {
        if (world.field_72995_K) {
            return;
        }
        FamiliarData data = new FamiliarData(player.func_70005_c_(), aspect.getTag());
        IInventory baublesInv = BaublesApi.getBaubles((EntityPlayer)player);
        if (baublesInv.func_70301_a(0) == null) {
            this.handleUnequip(world, player, aspect);
            return;
        }
        if (this.familiarControllers.get(player) == null || !this.playersWithFamiliar.contains(data)) {
            this.handleEquip(world, player, aspect);
        }
        this.familiarControllers.get(player).tick();
    }

    public void checkPlayerEquipment(EntityPlayer p) {
        Aspect a;
        ItemStack amulet;
        IInventory baublesInv = BaublesApi.getBaubles((EntityPlayer)p);
        if (baublesInv.func_70301_a(0) != null && (amulet = baublesInv.func_70301_a(0)).func_77973_b() != null && amulet.func_77973_b() instanceof ItemEtherealFamiliar && (a = ItemEtherealFamiliar.getFamiliarAspect(amulet)) != null) {
            this.handleEquip(p.field_70170_p, p, a);
        }
    }

    @Override
    public boolean needsUpdate() {
        return true;
    }

    @Override
    public void writeAllDataToPacket(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (FamiliarData data : this.playersWithFamiliar) {
            NBTTagCompound cmp = new NBTTagCompound();
            cmp.func_74778_a("owner", data.owner);
            cmp.func_74778_a("aspect", data.aspectTag);
            list.func_74742_a((NBTBase)cmp);
        }
        compound.func_74782_a("additions", (NBTBase)list);
        compound.func_74782_a("removals", (NBTBase)new NBTTagList());
    }

    @Override
    public void writeToPacket(NBTTagCompound compound) {
        NBTTagList removal = new NBTTagList();
        for (FamiliarData data : this.removeClientQueue) {
            NBTTagCompound cmp = new NBTTagCompound();
            cmp.func_74778_a("owner", data.owner);
            cmp.func_74778_a("aspect", data.aspectTag);
            removal.func_74742_a((NBTBase)cmp);
        }
        compound.func_74782_a("removals", (NBTBase)removal);
        NBTTagList additions = new NBTTagList();
        for (FamiliarData data : this.addClientQueue) {
            NBTTagCompound cmp = new NBTTagCompound();
            cmp.func_74778_a("owner", data.owner);
            cmp.func_74778_a("aspect", data.aspectTag);
            additions.func_74742_a((NBTBase)cmp);
        }
        compound.func_74782_a("additions", (NBTBase)additions);
        this.removeClientQueue.clear();
        this.addClientQueue.clear();
    }

    @Override
    public void readRawFromPacket(NBTTagCompound compound) {
        NBTTagList remove = compound.func_150295_c("removals", (int)new NBTTagCompound().func_74732_a());
        for (int i = 0; i < remove.func_74745_c(); ++i) {
            NBTTagCompound cmp = remove.func_150305_b(i);
            String owner = cmp.func_74779_i("owner");
            String aspect = cmp.func_74779_i("aspect");
            this.removeClientQueue.add(new FamiliarData(owner, aspect));
        }
        NBTTagList additions = compound.func_150295_c("additions", (int)new NBTTagCompound().func_74732_a());
        for (int i = 0; i < additions.func_74745_c(); ++i) {
            NBTTagCompound cmp = additions.func_150305_b(i);
            String owner = cmp.func_74779_i("owner");
            String aspect = cmp.func_74779_i("aspect");
            this.addClientQueue.add(new FamiliarData(owner, aspect));
        }
    }

    @Override
    public void handleIncomingData(AbstractData serverData) {
        DataFamiliar familiarData = (DataFamiliar)serverData;
        List<FamiliarData> toAdd = familiarData.addClientQueue;
        this.playersWithFamiliar.addAll(toAdd);
        FamiliarHandlerClient.handleAdditions(toAdd);
        List<FamiliarData> toRemove = familiarData.removeClientQueue;
        this.playersWithFamiliar.removeAll(toRemove);
        FamiliarHandlerClient.handleRemovals(toRemove);
    }

    public void handleUnsafeUnequip(EntityPlayer player) {
        FamiliarData data = null;
        for (FamiliarData fam : this.playersWithFamiliar) {
            if (!fam.owner.equals(player.func_70005_c_())) continue;
            data = fam;
        }
        if (data != null) {
            this.handleUnequip(player.field_70170_p, player, Aspect.getAspect((String)data.aspectTag));
        }
    }

    public static class FamiliarData {
        public final String owner;
        public final String aspectTag;

        public FamiliarData(String owner, String aspectTag) {
            this.owner = owner;
            this.aspectTag = aspectTag;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FamiliarData that = (FamiliarData)o;
            return (this.aspectTag != null ? this.aspectTag.equals(that.aspectTag) : that.aspectTag == null) && (this.owner != null ? this.owner.equals(that.owner) : that.owner == null);
        }

        public int hashCode() {
            int result = this.owner != null ? this.owner.hashCode() : 0;
            result = 31 * result + (this.aspectTag != null ? this.aspectTag.hashCode() : 0);
            return result;
        }
    }

    public static class Provider
    extends AbstractData.ProviderAutoAllocate<DataFamiliar> {
        public Provider(String key) {
            super(key);
        }

        @Override
        public DataFamiliar provideNewInstance() {
            return new DataFamiliar();
        }
    }
}

