/*
 * Decompiled with CFR 0.152.
 */
package witchinggadgets.common.util.handler;

import java.util.HashMap;
import net.minecraft.item.ItemStack;
import thaumcraft.api.aspects.Aspect;
import witchinggadgets.common.util.Utilities;

public class InfusedGemHandler {
    public static HashMap<String, Aspect[]> naturalAffinities = new HashMap();
    public static HashMap<String, Aspect[]> naturalAversions = new HashMap();

    public static void registerAffinities(Object o, Aspect ... aspects) {
        if (o instanceof String) {
            naturalAffinities.put((String)o, aspects);
        } else if (o instanceof ItemStack) {
            naturalAffinities.put(Utilities.getItemStackString((ItemStack)o), aspects);
        }
    }

    public static void removeAffinities(Object o) {
        if (o instanceof String) {
            naturalAffinities.remove((String)o);
        } else if (o instanceof ItemStack) {
            naturalAffinities.remove(Utilities.getItemStackString((ItemStack)o));
        }
    }

    public static void registerAversions(Object o, Aspect ... aspects) {
        if (o instanceof String) {
            naturalAversions.put((String)o, aspects);
        } else if (o instanceof ItemStack) {
            naturalAversions.put(Utilities.getItemStackString((ItemStack)o), aspects);
        }
    }

    public static void removeAversions(Object o) {
        if (o instanceof String) {
            naturalAversions.remove((String)o);
        } else if (o instanceof ItemStack) {
            naturalAversions.remove(Utilities.getItemStackString((ItemStack)o));
        }
    }

    public static Aspect[] getNaturalAffinities(ItemStack gem) {
        String s0 = Utilities.getItemStackString(gem);
        if (naturalAffinities.containsKey(s0)) {
            return naturalAffinities.get(s0);
        }
        for (String s1 : naturalAffinities.keySet()) {
            if (!Utilities.compareToOreName(gem, s1)) continue;
            return naturalAffinities.get(s1);
        }
        return new Aspect[0];
    }

    public static Aspect[] getNaturalAversions(ItemStack gem) {
        String s0 = Utilities.getItemStackString(gem);
        if (naturalAversions.containsKey(s0)) {
            return naturalAversions.get(s0);
        }
        for (String s1 : naturalAversions.keySet()) {
            if (!Utilities.compareToOreName(gem, s1)) continue;
            return naturalAversions.get(s1);
        }
        return new Aspect[0];
    }

    public static boolean isGem(ItemStack stack) {
        String s0 = Utilities.getItemStackString(stack);
        if (naturalAffinities.containsKey(s0) || naturalAversions.containsKey(s0)) {
            return true;
        }
        for (String s : naturalAffinities.keySet()) {
            if (!Utilities.compareToOreName(stack, s)) continue;
            return true;
        }
        for (String s : naturalAversions.keySet()) {
            if (!Utilities.compareToOreName(stack, s)) continue;
            return true;
        }
        return false;
    }

    static {
        InfusedGemHandler.registerAffinities("gemDiamond", Aspect.ORDER);
        InfusedGemHandler.registerAversions("gemDiamond", Aspect.ENTROPY, Aspect.AIR);
        InfusedGemHandler.registerAffinities("gemEmerald", Aspect.EARTH);
        InfusedGemHandler.registerAversions("gemEmerald", Aspect.WATER, Aspect.ENTROPY);
        InfusedGemHandler.registerAffinities("crystalNetherQuartz", Aspect.ENTROPY, Aspect.FIRE);
        InfusedGemHandler.registerAversions("crystalNetherQuartz", Aspect.ORDER, Aspect.WATER, Aspect.AIR);
        InfusedGemHandler.registerAffinities("crystalCertusQuartz", Aspect.ORDER, Aspect.AIR);
        InfusedGemHandler.registerAversions("crystalCertusQuartz", Aspect.ENTROPY, Aspect.FIRE, Aspect.EARTH);
        InfusedGemHandler.registerAffinities("crystalFluix", Aspect.ENTROPY, Aspect.WATER, Aspect.AIR);
        InfusedGemHandler.registerAversions("crystalFluix", Aspect.ORDER, Aspect.EARTH, Aspect.FIRE);
        InfusedGemHandler.registerAffinities("crystalQuartzite", Aspect.WATER, Aspect.EARTH);
        InfusedGemHandler.registerAversions("crystalQuartzite", Aspect.FIRE, Aspect.ENTROPY, Aspect.AIR);
        InfusedGemHandler.registerAffinities("gemTopaz", Aspect.AIR, Aspect.FIRE);
        InfusedGemHandler.registerAversions("gemTopaz", Aspect.ENTROPY, Aspect.WATER);
        InfusedGemHandler.registerAffinities("gemAmber", Aspect.AIR, Aspect.EARTH);
        InfusedGemHandler.registerAversions("gemAmber", Aspect.ENTROPY);
        InfusedGemHandler.registerAffinities("gemPeridot", Aspect.EARTH);
        InfusedGemHandler.registerAversions("gemPeridot", Aspect.ENTROPY, Aspect.FIRE);
        InfusedGemHandler.registerAffinities("gemMalachite", Aspect.EARTH, Aspect.WATER);
        InfusedGemHandler.registerAversions("gemMalachite", Aspect.ENTROPY, Aspect.FIRE);
        InfusedGemHandler.registerAffinities("gemRuby", Aspect.FIRE);
        InfusedGemHandler.registerAversions("gemRuby", Aspect.ENTROPY, Aspect.WATER);
        InfusedGemHandler.registerAffinities("gemSapphire", Aspect.WATER);
        InfusedGemHandler.registerAversions("gemSapphire", Aspect.ENTROPY, Aspect.FIRE);
        InfusedGemHandler.registerAffinities("gemTanzanite", Aspect.WATER);
        InfusedGemHandler.registerAversions("gemTanzanite", Aspect.ENTROPY, Aspect.FIRE);
        InfusedGemHandler.registerAffinities("gemPrimordial", Aspect.AIR, Aspect.EARTH, Aspect.FIRE, Aspect.WATER, Aspect.ORDER, Aspect.ENTROPY);
        InfusedGemHandler.registerAffinities("gemNetherStar", Aspect.AIR, Aspect.EARTH, Aspect.FIRE, Aspect.WATER, Aspect.ORDER, Aspect.ENTROPY);
        InfusedGemHandler.registerAffinities("gemApatite", Aspect.WATER, Aspect.EARTH);
        InfusedGemHandler.registerAversions("gemApatite", Aspect.AIR, Aspect.ORDER);
        InfusedGemHandler.registerAffinities("gemQuicksilver", Aspect.ORDER, Aspect.EARTH);
        InfusedGemHandler.registerAversions("gemQuicksilver", Aspect.FIRE, Aspect.AIR);
        InfusedGemHandler.registerAffinities("gemJasper", Aspect.FIRE);
        InfusedGemHandler.registerAversions("gemJasper", Aspect.ENTROPY, Aspect.WATER);
        InfusedGemHandler.registerAffinities("gemFirestone", Aspect.FIRE);
        InfusedGemHandler.registerAversions("gemFirestone", Aspect.WATER);
        InfusedGemHandler.registerAffinities("gemJade", Aspect.EARTH);
        InfusedGemHandler.registerAversions("gemJade", Aspect.ENTROPY, Aspect.AIR);
        InfusedGemHandler.registerAffinities("gemGreenSapphire", Aspect.EARTH);
        InfusedGemHandler.registerAversions("gemGreenSapphire", Aspect.ENTROPY, Aspect.AIR);
        InfusedGemHandler.registerAffinities("gemOlivine", Aspect.EARTH);
        InfusedGemHandler.registerAversions("gemOlivine", Aspect.ENTROPY, Aspect.AIR);
        InfusedGemHandler.registerAffinities("gemFoolsRuby", Aspect.FIRE);
        InfusedGemHandler.registerAversions("gemFoolsRuby", Aspect.ENTROPY, Aspect.WATER, Aspect.AIR, Aspect.ORDER);
        InfusedGemHandler.registerAffinities("gemGlas", Aspect.ORDER);
        InfusedGemHandler.registerAversions("gemGlass", Aspect.AIR, Aspect.EARTH, Aspect.FIRE, Aspect.WATER, Aspect.ENTROPY);
        InfusedGemHandler.registerAffinities("gemDilithium", Aspect.ORDER);
        InfusedGemHandler.registerAversions("gemDilithium", Aspect.AIR, Aspect.EARTH, Aspect.FIRE, Aspect.WATER, Aspect.ENTROPY);
        InfusedGemHandler.registerAffinities("gemOpal", Aspect.WATER);
        InfusedGemHandler.registerAversions("gemOpal", Aspect.ENTROPY, Aspect.FIRE);
        InfusedGemHandler.registerAffinities("gemAmethyst", Aspect.WATER);
        InfusedGemHandler.registerAversions("gemAmethyst", Aspect.ENTROPY, Aspect.FIRE);
        InfusedGemHandler.registerAffinities("gemBlueTopaz", Aspect.WATER);
        InfusedGemHandler.registerAversions("gemBlueTopaz", Aspect.ENTROPY, Aspect.WATER);
        InfusedGemHandler.registerAffinities("gemForcicium", Aspect.ENTROPY);
        InfusedGemHandler.registerAversions("gemForcicium", Aspect.AIR, Aspect.EARTH, Aspect.FIRE, Aspect.WATER, Aspect.ORDER);
        InfusedGemHandler.registerAffinities("gemForcilium", Aspect.ENTROPY);
        InfusedGemHandler.registerAversions("gemForcilium", Aspect.AIR, Aspect.EARTH, Aspect.FIRE, Aspect.WATER, Aspect.ORDER);
        InfusedGemHandler.registerAffinities("gemMonazite", Aspect.ENTROPY);
        InfusedGemHandler.registerAversions("gemMonazite", Aspect.AIR, Aspect.EARTH, Aspect.FIRE, Aspect.WATER, Aspect.ORDER);
        InfusedGemHandler.registerAffinities("gemVinteum", Aspect.AIR, Aspect.EARTH, Aspect.FIRE, Aspect.WATER);
        InfusedGemHandler.registerAversions("gemVinteum", Aspect.ENTROPY, Aspect.WATER);
    }
}

