/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.mixins.early.shaders;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.coderbot.iris.Iris;
import net.coderbot.iris.shaderpack.LanguageMap;
import net.coderbot.iris.shaderpack.ShaderPack;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.Locale;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Locale.class})
public class MixinLocale {
    @Shadow
    Map<String, String> field_135032_a;
    @Unique
    private static final List<String> languageCodes = new ArrayList<String>();

    @Inject(method={"translateKeyPrivate"}, at={@At(value="HEAD")}, cancellable=true)
    private void iris$overrideLanguageEntries(String key, CallbackInfoReturnable<String> cir) {
        String override = this.iris$lookupOverriddenEntry(key);
        if (override != null) {
            cir.setReturnValue((Object)override);
        }
    }

    @Unique
    private String iris$lookupOverriddenEntry(String key) {
        ShaderPack pack = Iris.getCurrentPack().orElse(null);
        if (pack == null) {
            return null;
        }
        LanguageMap languageMap = pack.getLanguageMap();
        if (this.field_135032_a.containsKey(key)) {
            return null;
        }
        for (String code : languageCodes) {
            String translation;
            Map<String, String> translations = languageMap.getTranslations(code);
            if (translations == null || (translation = translations.get(key)) == null) continue;
            return translation;
        }
        return null;
    }

    @Inject(method={"loadLocaleDataFiles"}, at={@At(value="HEAD")})
    private void iris$addLanguageCodes(IResourceManager resourceManager, List<String> definitions, CallbackInfo ci) {
        languageCodes.clear();
        new LinkedList<String>(definitions).descendingIterator().forEachRemaining(languageCodes::add);
    }
}

