/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.helpers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import squeek.applecore.api.food.FoodValues;
import squeek.spiceoflife.foodtracker.FoodModifier;
import squeek.spiceoflife.helpers.FoodHelper;

public class MealPrioritizationHelper {
    public static final Comparator<InventoryFoodInfo> hungerComparator = (a, b) -> MealPrioritizationHelper.integerCompare(a.modifiedFoodValues.hunger, b.modifiedFoodValues.hunger);
    public static final Comparator<InventoryFoodInfo> diminishedComparator = (a, b) -> Float.compare(b.diminishingReturnsModifier, a.diminishingReturnsModifier);

    public static int findBestFoodForPlayerToEat(EntityPlayer player, IInventory inventory) {
        List<InventoryFoodInfo> allFoodInfo = MealPrioritizationHelper.getFoodInfoFromInventoryForPlayer(player, inventory);
        InventoryFoodInfo bestFoodInfo = null;
        if (allFoodInfo.size() > 0) {
            int hungerMissingFromPlayer = 20 - player.func_71024_bL().func_75116_a();
            allFoodInfo.sort(new FoodInfoComparator(hungerMissingFromPlayer));
            bestFoodInfo = allFoodInfo.get(0);
        }
        return bestFoodInfo != null ? bestFoodInfo.slotNum : 0;
    }

    public static List<InventoryFoodInfo> getFoodInfoFromInventoryForPlayer(EntityPlayer player, IInventory inventory) {
        ArrayList<InventoryFoodInfo> foodInfo = new ArrayList<InventoryFoodInfo>();
        for (int slotNum = 0; slotNum < inventory.func_70302_i_(); ++slotNum) {
            ItemStack stackInSlot = inventory.func_70301_a(slotNum);
            if (stackInSlot == null || !FoodHelper.isFood(stackInSlot)) continue;
            foodInfo.add(new InventoryFoodInfo(slotNum, stackInSlot, player));
        }
        return foodInfo;
    }

    public static List<InventoryFoodInfo> findBestFoodsForPlayerAccountingForVariety(EntityPlayer player, IInventory inventory, int limit) {
        List<InventoryFoodInfo> bestFoods = MealPrioritizationHelper.findBestFoodsForPlayerAccountingForVariety(player, inventory);
        if (bestFoods.size() > limit) {
            bestFoods = bestFoods.subList(0, limit);
        }
        return bestFoods;
    }

    public static List<InventoryFoodInfo> findBestFoodsForPlayerAccountingForVariety(EntityPlayer player, IInventory inventory) {
        List<InventoryFoodInfo> allFoodInfo = MealPrioritizationHelper.getFoodInfoFromInventoryForPlayer(player, inventory);
        Collections.shuffle(allFoodInfo);
        allFoodInfo.sort(diminishedComparator);
        return allFoodInfo;
    }

    public static List<List<InventoryFoodInfo>> stratifyFoodsByHunger(List<InventoryFoodInfo> allFoods) {
        ArrayList<List<InventoryFoodInfo>> stratifiedFoods = new ArrayList<List<InventoryFoodInfo>>();
        if (allFoods.size() > 0) {
            allFoods.sort(hungerComparator);
            int strataHunger = allFoods.get((int)0).modifiedFoodValues.hunger;
            ArrayList<InventoryFoodInfo> currentStrata = new ArrayList<InventoryFoodInfo>();
            for (InventoryFoodInfo foodInfo : allFoods) {
                if (foodInfo.modifiedFoodValues.hunger != strataHunger) {
                    stratifiedFoods.add(currentStrata);
                    currentStrata = new ArrayList();
                    strataHunger = foodInfo.modifiedFoodValues.hunger;
                }
                currentStrata.add(foodInfo);
            }
            stratifiedFoods.add(currentStrata);
        }
        return stratifiedFoods;
    }

    private static int integerCompare(int a, int b) {
        return Integer.compare(a, b);
    }

    public static class FoodInfoComparator
    implements Comparator<InventoryFoodInfo>,
    Serializable {
        private static final long serialVersionUID = -2142369827782900207L;
        public int maxHungerRestored;
        public boolean ignoreHungerRemainder = false;

        public FoodInfoComparator() {
            this.ignoreHungerRemainder = true;
        }

        public FoodInfoComparator(int maxHungerRestored) {
            this.maxHungerRestored = maxHungerRestored;
        }

        @Override
        public int compare(InventoryFoodInfo a, InventoryFoodInfo b) {
            int compareResult = Float.compare(b.diminishingReturnsModifier, a.diminishingReturnsModifier);
            if (compareResult == 0 && !this.ignoreHungerRemainder) {
                int aRemainder = this.maxHungerRestored - a.modifiedFoodValues.hunger;
                int bRemainder = this.maxHungerRestored - b.modifiedFoodValues.hunger;
                compareResult = MealPrioritizationHelper.integerCompare(Math.abs(aRemainder), Math.abs(bRemainder));
                if (compareResult == 0 && aRemainder != bRemainder) {
                    int n = compareResult = bRemainder > aRemainder ? 1 : -1;
                }
            }
            if (compareResult == 0) {
                compareResult = Float.compare(b.modifiedFoodValues.saturationModifier * (float)b.modifiedFoodValues.hunger, a.modifiedFoodValues.saturationModifier * (float)a.modifiedFoodValues.hunger);
            }
            return compareResult;
        }
    }

    public static class InventoryFoodInfo {
        public ItemStack itemStack;
        public FoodValues defaultFoodValues;
        public float diminishingReturnsModifier = 1.0f;
        public FoodValues modifiedFoodValues;
        public int slotNum;

        public InventoryFoodInfo() {
        }

        public InventoryFoodInfo(int slotNum, ItemStack itemStack, EntityPlayer player) {
            this.itemStack = itemStack;
            this.slotNum = slotNum;
            this.defaultFoodValues = FoodValues.get((ItemStack)this.itemStack);
            if (FoodHelper.canFoodDiminish(this.itemStack)) {
                this.diminishingReturnsModifier = FoodModifier.getFoodModifier(player, itemStack);
                this.modifiedFoodValues = FoodModifier.getModifiedFoodValues(this.defaultFoodValues, this.diminishingReturnsModifier);
            } else {
                this.diminishingReturnsModifier = Float.NaN;
                this.modifiedFoodValues = this.defaultFoodValues;
            }
        }
    }
}

