/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import squeek.spiceoflife.interfaces.ISaveable;
import squeek.spiceoflife.inventory.INBTInventoryHaver;

public class NBTInventory
implements ISaveable,
IInventory {
    protected ItemStack[] inventoryItems;
    protected INBTInventoryHaver inventoryHaver = null;

    public NBTInventory() {
        this(0);
    }

    public NBTInventory(int inventorySize) {
        this(new ItemStack[inventorySize]);
    }

    public NBTInventory(ItemStack[] inventoryItems) {
        this.inventoryItems = inventoryItems;
    }

    public NBTInventory(INBTInventoryHaver inventoryHaver) {
        this(inventoryHaver.getSizeInventory());
        this.inventoryHaver = inventoryHaver;
    }

    public static boolean isInventoryEmpty(NBTTagCompound data) {
        NBTTagList items = data.func_150295_c("Items", 10);
        return items.func_74745_c() == 0;
    }

    public boolean isInventoryEmpty() {
        for (ItemStack itemStack : this.inventoryItems) {
            if (itemStack == null) continue;
            return false;
        }
        return true;
    }

    public boolean isInventoryFull() {
        for (ItemStack itemStack : this.inventoryItems) {
            if (itemStack != null && itemStack.field_77994_a >= Math.min(this.func_70297_j_(), itemStack.func_77976_d())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeToNBTData(NBTTagCompound data) {
        NBTTagList items = new NBTTagList();
        for (int slotNum = 0; slotNum < this.func_70302_i_(); ++slotNum) {
            ItemStack stack = this.func_70301_a(slotNum);
            if (stack == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)slotNum);
            stack.func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        data.func_74782_a("Items", (NBTBase)items);
    }

    public int func_70302_i_() {
        return this.inventoryItems.length;
    }

    public boolean isValidSlotNum(int slotNum) {
        return slotNum < this.func_70302_i_() && slotNum >= 0;
    }

    public ItemStack func_70301_a(int slotNum) {
        if (this.isValidSlotNum(slotNum)) {
            return this.inventoryItems[slotNum];
        }
        return null;
    }

    public ItemStack func_70298_a(int slotNum, int count) {
        ItemStack itemStack = this.func_70301_a(slotNum);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= count) {
                this.func_70299_a(slotNum, null);
            } else {
                itemStack = itemStack.func_77979_a(count);
                this.func_70296_d();
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slotNum) {
        ItemStack item = this.func_70301_a(slotNum);
        this.func_70299_a(slotNum, null);
        return item;
    }

    public void func_70299_a(int slotNum, ItemStack itemStack) {
        if (!this.isValidSlotNum(slotNum)) {
            return;
        }
        boolean wasEmpty = this.func_70301_a(slotNum) == null;
        this.inventoryItems[slotNum] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        if (wasEmpty && itemStack != null) {
            this.onSlotFilled(slotNum);
        } else if (!wasEmpty && itemStack == null) {
            this.onSlotEmptied(slotNum);
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        if (this.inventoryHaver != null) {
            return this.inventoryHaver.getInvName(this);
        }
        return null;
    }

    public boolean func_145818_k_() {
        if (this.inventoryHaver != null) {
            return this.inventoryHaver.isInvNameLocalized(this);
        }
        return false;
    }

    public int func_70297_j_() {
        if (this.inventoryHaver != null) {
            return this.inventoryHaver.getInventoryStackLimit(this);
        }
        return 64;
    }

    public void func_70296_d() {
        this.onInventoryChanged();
        if (this.inventoryHaver != null) {
            this.inventoryHaver.onInventoryChanged(this);
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slotNum, ItemStack itemStack) {
        if (this.inventoryHaver != null) {
            return this.inventoryHaver.isItemValidForSlot(this, slotNum, itemStack);
        }
        return true;
    }

    @Override
    public void readFromNBTData(NBTTagCompound data) {
        NBTTagList items = data.func_150295_c("Items", 10);
        for (int slotNum = 0; slotNum < items.func_74745_c(); ++slotNum) {
            NBTTagCompound item = items.func_150305_b(slotNum);
            byte slot = item.func_74771_c("Slot");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)item));
        }
    }

    protected void onSlotFilled(int slotNum) {
    }

    protected void onSlotEmptied(int slotNum) {
    }

    public void onInventoryChanged() {
    }
}

