/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.animation;

import com.cleanroommc.modularui.animation.MutableObjectAnimator;
import com.cleanroommc.modularui.api.drawable.IInterpolation;

public interface IAnimatable<T extends IAnimatable<T>> {
    public T interpolate(T var1, T var2, float var3);

    public T copyOrImmutable();

    default public boolean shouldAnimate(T target) {
        return !this.equals(target);
    }

    default public MutableObjectAnimator<T> animator(T target) {
        IAnimatable self = this;
        return new MutableObjectAnimator<IAnimatable>(self, (IAnimatable)self.copyOrImmutable(), (IAnimatable)target);
    }

    default public void animate(T target) {
        this.animate(target, false);
    }

    default public void animate(T target, boolean reverse) {
        if (this.shouldAnimate(target)) {
            this.animator(target).animate(reverse);
        }
    }

    default public void animate(T target, boolean reverse, boolean reverseOnFinish, int repeatsOnFinish) {
        if (this.shouldAnimate(target)) {
            this.animator(target).reverseOnFinish(reverseOnFinish).repeatsOnFinish(repeatsOnFinish).animate(reverse);
        }
    }

    default public void animate(T target, int durationMs, boolean reverse) {
        if (this.shouldAnimate(target)) {
            this.animator(target).duration(durationMs).animate(reverse);
        }
    }

    default public void animate(T target, IInterpolation curve, boolean reverse) {
        if (this.shouldAnimate(target)) {
            this.animator(target).curve(curve).animate(reverse);
        }
    }

    default public void animate(T target, IInterpolation curve, int durationMs, boolean reverse) {
        this.animate(target, curve, durationMs, reverse, false, 0);
    }

    default public void animate(T target, IInterpolation curve, int durationMs, boolean reverse, boolean reverseOnFinish, int repeatsOnFinish) {
        if (this.shouldAnimate(target)) {
            this.animator(target).curve(curve).duration(durationMs).reverseOnFinish(reverseOnFinish).repeatsOnFinish(repeatsOnFinish).animate(reverse);
        }
    }
}

