/*
 * Decompiled with CFR 0.152.
 */
package openmods.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import openmods.Log;
import openmods.inventory.ItemInventory;
import openmods.utils.ItemUtils;

public class PlayerItemInventory
extends ItemInventory {
    private final EntityPlayer player;
    private final int inventorySlot;
    private final int selfId = System.identityHashCode(this);
    private boolean isValid = true;
    private static final String TAG_INV = "openedInGui";

    private static void setGuiId(ItemStack stack, int id) {
        ItemUtils.getItemTag(stack).func_74768_a(TAG_INV, id);
    }

    private static int getGuiId(ItemStack stack) {
        return ItemUtils.getItemTag(stack).func_74762_e(TAG_INV);
    }

    public PlayerItemInventory(EntityPlayer player, int size) {
        this(player, size, player.field_71071_by.field_70461_c);
    }

    public PlayerItemInventory(EntityPlayer player, int size, int inventorySlot) {
        super(player.field_71071_by.func_70301_a(inventorySlot), size);
        this.player = player;
        this.inventorySlot = inventorySlot;
        PlayerItemInventory.setGuiId(this.containerStack, this.selfId);
    }

    private void invalidate(EntityPlayer player) {
        Log.info("Player %s tried to trigger item duplication bug", player);
        this.isValid = false;
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        ItemStack currentItem;
        if (player != this.player || player.field_71071_by.field_70461_c != this.inventorySlot) {
            this.invalidate(player);
            return false;
        }
        if (!(player.field_70170_p.field_72995_K || (currentItem = player.field_71071_by.func_70448_g()) != null && currentItem.func_77969_a(this.containerStack) && PlayerItemInventory.getGuiId(currentItem) == this.selfId)) {
            this.invalidate(player);
            return false;
        }
        return true;
    }

    @Override
    public void onInventoryChanged(int slotNumber) {
        super.onInventoryChanged(slotNumber);
        if (this.isValid) {
            this.player.field_71071_by.func_70299_a(this.inventorySlot, this.containerStack);
        }
    }
}

