/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.structure;

import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.ISpecialItemBlock;
import com.gtnewhorizon.structurelib.structure.IStructureElementNoPlacement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.ItemStackPredicate;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public interface IStructureElement<T> {
    public boolean check(T var1, World var2, int var3, int var4, int var5);

    default public boolean couldBeValid(T t, World world, int x, int y, int z, ItemStack trigger) {
        return true;
    }

    public boolean spawnHint(T var1, World var2, int var3, int var4, int var5, ItemStack var6);

    public boolean placeBlock(T var1, World var2, int var3, int var4, int var5, ItemStack var6);

    @Deprecated
    default public PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
        if (StructureLib.PANIC_MODE) {
            throw new RuntimeException("Panic Tripwire hit");
        }
        if (StructureLibAPI.isDebugEnabled()) {
            StructureLib.LOGGER.error("Default implementation of survivalPlaceBlock hit! Things aren't going to work well! IStructureElement class: {}", new Object[]{this.getClass().getName()});
        }
        if (!StructureLibAPI.isBlockTriviallyReplaceable(world, x, y, z, actor)) {
            return PlaceResult.REJECT;
        }
        return PlaceResult.SKIP;
    }

    @Nullable
    default public BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
        return null;
    }

    default public PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
        BlocksToPlace e = this.getBlocksToPlace(t, world, x, y, z, trigger, env);
        IItemSource source = env.getSource();
        EntityPlayer actor = env.getActor();
        Consumer<IChatComponent> chatter = env.getChatter();
        if (e != null) {
            if (this.check(t, world, x, y, z)) {
                return PlaceResult.SKIP;
            }
            if (e.getStacks() == null) {
                ItemStack taken = source.takeOne(e.getPredicate(), true);
                return StructureUtility.survivalPlaceBlock(taken, ItemStackPredicate.NBTMode.EXACT, taken.field_77990_d, true, world, x, y, z, source, actor, chatter);
            }
            for (ItemStack stack : e.getStacks()) {
                if (!source.takeOne(stack, true)) continue;
                return StructureUtility.survivalPlaceBlock(stack, ItemStackPredicate.NBTMode.EXACT, stack.field_77990_d, true, world, x, y, z, source, actor, chatter);
            }
            return PlaceResult.REJECT;
        }
        if (actor instanceof EntityPlayerMP) {
            return this.survivalPlaceBlock(t, world, x, y, z, trigger, source, (EntityPlayerMP)actor, chatter);
        }
        if (StructureLib.PANIC_MODE) {
            throw new RuntimeException("Panic Tripwire hit");
        }
        if (StructureLibAPI.isDebugEnabled()) {
            StructureLib.LOGGER.info("Fallback shim code of survivalPlaceBlock hit! Things aren't going to work well! IStructureElement class: {}", new Object[]{this.getClass().getName()});
        }
        return PlaceResult.SKIP;
    }

    default public IStructureElementNoPlacement<T> noPlacement() {
        return new IStructureElementNoPlacement<T>(){

            @Override
            public boolean check(T t, World world, int x, int y, int z) {
                return IStructureElement.this.check(t, world, x, y, z);
            }

            @Override
            public boolean couldBeValid(T t, World world, int x, int y, int z, ItemStack trigger) {
                return IStructureElement.this.couldBeValid(t, world, x, y, z, trigger);
            }

            @Override
            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                return IStructureElement.this.spawnHint(t, world, x, y, z, trigger);
            }
        };
    }

    default public int getStepA() {
        return 1;
    }

    default public int getStepB() {
        return 0;
    }

    default public int getStepC() {
        return 0;
    }

    default public boolean resetA() {
        return false;
    }

    default public boolean resetB() {
        return false;
    }

    default public boolean resetC() {
        return false;
    }

    default public boolean isNavigating() {
        return false;
    }

    public static enum PlaceResult {
        SKIP,
        REJECT,
        STOP,
        ACCEPT,
        ACCEPT_STOP;

    }

    public static final class BlocksToPlace {
        public static final BlocksToPlace errored = BlocksToPlace.createEmpty();
        private final Predicate<ItemStack> predicate;
        private final Iterable<ItemStack> stacks;

        public static BlocksToPlace createEmpty() {
            return new BlocksToPlace(s -> false, Collections.emptyList());
        }

        public static BlocksToPlace create(ItemStack ... stacks) {
            return BlocksToPlace.create(Arrays.asList(stacks));
        }

        public static BlocksToPlace create(Iterable<ItemStack> stacks) {
            Predicate<ItemStack> predicate = null;
            for (ItemStack stack : stacks) {
                ItemStackPredicate p = ItemStackPredicate.from(stack, ItemStackPredicate.NBTMode.EXACT);
                if (predicate == null) {
                    predicate = p;
                    continue;
                }
                predicate = predicate.or(p);
            }
            return new BlocksToPlace(predicate, stacks);
        }

        public static BlocksToPlace create(Block block, int meta) {
            Item itemBlock = Item.func_150898_a((Block)block);
            if (itemBlock instanceof ISpecialItemBlock) {
                meta = ((ISpecialItemBlock)itemBlock).getItemMetaFromBlockMeta(block, meta);
            }
            return BlocksToPlace.create(itemBlock, meta);
        }

        public static BlocksToPlace create(Item item, int meta) {
            return new BlocksToPlace(ItemStackPredicate.from(item).setMeta(meta), Collections.singletonList(new ItemStack(item, 1, meta)));
        }

        public static BlocksToPlace create(ItemStack itemStack) {
            return new BlocksToPlace(ItemStackPredicate.from(itemStack), Collections.singletonList(itemStack));
        }

        public static BlocksToPlace create(Predicate<ItemStack> predicate) {
            return new BlocksToPlace(predicate, null);
        }

        BlocksToPlace(Predicate<ItemStack> predicate, Iterable<ItemStack> stacks) {
            this.predicate = predicate;
            this.stacks = stacks;
        }

        @Nonnull
        public Predicate<ItemStack> getPredicate() {
            return this.predicate;
        }

        @Nullable
        public Iterable<ItemStack> getStacks() {
            return this.stacks;
        }
    }
}

