/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.blocks.BaseCaveVines;
import ganymedes01.etfuturum.blocks.BlockCaveVinesPlant;
import ganymedes01.etfuturum.tileentities.TileEntityCaveVines;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class BlockCaveVines
extends BaseCaveVines
implements IShearable,
ITileEntityProvider {
    public BlockCaveVines() {
        super(new String[]{"cave_vines", "cave_vines_lit"});
        this.func_149675_a(true);
    }

    public TileEntity createNewTileEntity(World worldIn) {
        return this.func_149915_a(worldIn, 0);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityCaveVines();
    }

    public void growVine(World world, int x, int y, int z, boolean manualPlace) {
        Random rand = new Random();
        TileEntity oldTE = world.func_147438_o(x, y, z);
        int maxLength = rand.nextInt(26) + 2;
        if (oldTE instanceof TileEntityCaveVines) {
            maxLength = ((TileEntityCaveVines)oldTE).getMaxLength();
        }
        world.func_147465_d(x, y, z, ModBlocks.CAVE_VINE_PLANT.get(), world.func_72805_g(x, y, z), 3);
        if (!manualPlace && rand.nextInt(9) == 0) {
            world.func_147465_d(x, y - 1, z, (Block)this, 1, 3);
            world.func_147463_c(EnumSkyBlock.Block, x, y, z);
        } else {
            world.func_147465_d(x, y - 1, z, (Block)this, 0, 3);
        }
        TileEntity newTE = world.func_147438_o(x, y - 1, z);
        if (newTE instanceof TileEntityCaveVines) {
            ((TileEntityCaveVines)newTE).setMaxLength(maxLength);
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCaveVines) {
            TileEntityCaveVines teCaveVine = (TileEntityCaveVines)te;
            return !teCaveVine.getTipSheared();
        }
        return false;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCaveVines) {
            TileEntityCaveVines teCaveVines = (TileEntityCaveVines)te;
            teCaveVines.setTipSheared(true);
        }
        return null;
    }

    public void func_149726_b(World worldIn, int x, int y, int z) {
        super.func_149726_b(worldIn, x, y, z);
    }

    public void func_149749_a(World worldIn, int x, int y, int z, Block blockBroken, int meta) {
        super.func_149749_a(worldIn, x, y, z, blockBroken, meta);
        worldIn.func_147475_p(x, y, z);
    }

    public boolean func_149696_a(World worldIn, int x, int y, int z, int eventId, int eventData) {
        super.func_149696_a(worldIn, x, y, z, eventId, eventData);
        TileEntity tileentity = worldIn.func_147438_o(x, y, z);
        return tileentity != null ? tileentity.func_145842_c(eventId, eventData) : false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityCaveVines) {
            TileEntityCaveVines teCaveVine = (TileEntityCaveVines)tileEntity;
            System.out.println("Tip Sheared:  " + teCaveVine.getTipSheared());
            System.out.println("Max Length:" + teCaveVine.getMaxLength());
        }
        if (this.onBlockActivatedShared(world, x, y, z, player, side, hitX, hitY, hitZ)) {
            return true;
        }
        ItemStack heldItem = player.func_70694_bm();
        if (heldItem != null && heldItem.func_77973_b() instanceof ItemShears && this.isShearable(heldItem, (IBlockAccess)world, x, y, z)) {
            this.onSheared(heldItem, (IBlockAccess)world, x, y, z, 0);
            world.func_72956_a((Entity)player, "mob.sheep.shear", 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        TileEntityCaveVines teCaveVines;
        TileEntity te;
        super.func_149674_a(world, x, y, z, random);
        if (!world.field_72995_K && world.func_147437_c(x, y - 1, z) && random.nextInt(10) == 0 && (te = world.func_147438_o(x, y, z)) instanceof TileEntityCaveVines && !(teCaveVines = (TileEntityCaveVines)te).getTipSheared() && this.getLength(world, x, y, z) < teCaveVines.getMaxLength()) {
            this.growVine(world, x, y, z, false);
        }
    }

    private int getLength(World world, int x, int y, int z) {
        int i = 1;
        while (world.func_147439_a(x, y + i, z) instanceof BlockCaveVinesPlant) {
            ++i;
        }
        return i;
    }
}

