/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.IWorldGenerator;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.blocks.BlockChorusFlower;
import ganymedes01.etfuturum.compat.ModsList;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.world.end.dimension.WorldProviderEFREnd;
import ganymedes01.etfuturum.world.generate.WorldGenDeepslateLayerBlob;
import ganymedes01.etfuturum.world.generate.WorldGenMinableCustom;
import ganymedes01.etfuturum.world.generate.decorate.WorldGenBamboo;
import ganymedes01.etfuturum.world.generate.decorate.WorldGenCaveVines;
import ganymedes01.etfuturum.world.generate.decorate.WorldGenCherryTrees;
import ganymedes01.etfuturum.world.generate.decorate.WorldGenGlowLichen;
import ganymedes01.etfuturum.world.generate.decorate.WorldGenPinkPetals;
import ganymedes01.etfuturum.world.generate.feature.WorldGenFossil;
import ganymedes01.etfuturum.world.generate.feature.WorldGenGeode;
import ganymedes01.etfuturum.world.structure.OceanMonument;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderFlat;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenClay;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

public class EtFuturumWorldGenerator
implements IWorldGenerator {
    public static final EtFuturumWorldGenerator INSTANCE = new EtFuturumWorldGenerator();
    protected final List<WorldGenMinable> stoneGen = new LinkedList<WorldGenMinable>();
    protected final WorldGenMinable copperGen = new WorldGenMinable(ModBlocks.COPPER_ORE.get(), ConfigWorld.maxCopperPerCluster);
    protected final WorldGenMinable magmaGen = new WorldGenMinable(ModBlocks.MAGMA.get(), ConfigWorld.maxMagmaPerCluster, Blocks.field_150424_aL);
    protected final WorldGenMinable netherGoldGen = new WorldGenMinable(ModBlocks.NETHER_GOLD_ORE.get(), ConfigWorld.maxNetherGoldPerCluster, Blocks.field_150424_aL);
    protected final WorldGenMinable debrisGen = new WorldGenMinableCustom(ModBlocks.ANCIENT_DEBRIS.get(), ConfigWorld.debrisMax, Blocks.field_150424_aL);
    protected final WorldGenMinable smallDebrisGen = new WorldGenMinableCustom(ModBlocks.ANCIENT_DEBRIS.get(), ConfigWorld.smallDebrisMax, Blocks.field_150424_aL);
    protected final WorldGenMinable mesaGoldGen = new WorldGenMinable(Blocks.field_150352_o, 8);
    protected final WorldGenMinable deepslateBlobGen = new WorldGenDeepslateLayerBlob(ConfigWorld.maxDeepslatePerCluster, false);
    protected final WorldGenMinable tuffGen = new WorldGenDeepslateLayerBlob(ConfigWorld.maxTuffPerCluster, true);
    protected WorldGenerator amethystGen;
    protected WorldGenerator fossilGen;
    protected WorldGenerator berryBushGen;
    protected WorldGenerator cornflowerGen;
    protected WorldGenerator lilyValleyGen;
    protected WorldGenerator pinkPetalsGen;
    protected WorldGenerator bambooGen;
    protected WorldGenerator glowLichenGen;
    protected WorldGenerator caveVineGen;
    protected WorldGenerator mudGen;
    private List<BiomeGenBase> fossilBiomes;
    private List<BiomeGenBase> berryBushBiomes;
    private List<BiomeGenBase> cornflowerBiomes;
    private List<BiomeGenBase> lilyValleyBiomes;
    private List<BiomeGenBase> bambooBiomes;
    private List<BiomeGenBase> mudBiomes;
    protected WorldGenAbstractTree cherryTreeGen;
    private List<BiomeGenBase> cherryBiomes;

    protected EtFuturumWorldGenerator() {
        this.stoneGen.add(new WorldGenMinableCustom(ModBlocks.STONE.get(), 1, ConfigWorld.maxStonesPerCluster, Blocks.field_150348_b));
        this.stoneGen.add(new WorldGenMinableCustom(ModBlocks.STONE.get(), 3, ConfigWorld.maxStonesPerCluster, Blocks.field_150348_b));
        this.stoneGen.add(new WorldGenMinableCustom(ModBlocks.STONE.get(), 5, ConfigWorld.maxStonesPerCluster, Blocks.field_150348_b));
    }

    public void postInit() {
        if (ConfigWorld.enableAmethystGeodes && ModBlocks.AMETHYST_BLOCK.isEnabled() && ModBlocks.AMETHYST_CLUSTER_1.isEnabled() && ModBlocks.AMETHYST_CLUSTER_2.isEnabled() && ModBlocks.BUDDING_AMETHYST.isEnabled() && ConfigWorld.amethystOuterBlock != null && ConfigWorld.amethystMiddleBlock != null) {
            this.amethystGen = new WorldGenGeode(ConfigWorld.amethystOuterBlock, ConfigWorld.amethystMiddleBlock);
        }
        if (ConfigWorld.enableFossils && ConfigWorld.fossilBlock != null) {
            Object[] fossilBiomesArray = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SANDY);
            for (BiomeGenBase biomeGenBase : fossilBiomesArray) {
                if (ArrayUtils.contains((Object[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.HOT), (Object)biomeGenBase) && ArrayUtils.contains((Object[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.DRY), (Object)biomeGenBase)) continue;
                fossilBiomesArray = (BiomeGenBase[])ArrayUtils.removeElement((Object[])fossilBiomesArray, (Object)biomeGenBase);
                break;
            }
            fossilBiomesArray = (BiomeGenBase[])ArrayUtils.addAll((Object[])fossilBiomesArray, (Object[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
            fossilBiomesArray = Utils.excludeBiomesFromTypes((BiomeGenBase[])fossilBiomesArray, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.END);
            this.fossilBiomes = Arrays.asList(fossilBiomesArray);
            this.fossilGen = new WorldGenFossil();
        }
        if (ModBlocks.SWEET_BERRY_BUSH.isEnabled()) {
            this.berryBushBiomes = Arrays.asList(Utils.excludeBiomesFromTypesWithDefaults(BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS), new BiomeDictionary.Type[0]));
            this.berryBushGen = new WorldGenFlowers(ModBlocks.SWEET_BERRY_BUSH.get());
            ((WorldGenFlowers)this.berryBushGen).func_150550_a(ModBlocks.SWEET_BERRY_BUSH.get(), 3);
        }
        if (ModBlocks.LILY_OF_THE_VALLEY.isEnabled()) {
            BiomeGenBase[] lilyValleyBiomeArray = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.FOREST);
            lilyValleyBiomeArray = Utils.excludeBiomesFromTypes(lilyValleyBiomeArray, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD);
            this.lilyValleyBiomes = Arrays.asList(lilyValleyBiomeArray);
            this.lilyValleyGen = new WorldGenFlowers(ModBlocks.LILY_OF_THE_VALLEY.get());
        }
        if (ModBlocks.CORNFLOWER.isEnabled()) {
            Object[] cornflowerBiomeArray = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS);
            cornflowerBiomeArray = Utils.excludeBiomesFromTypes((BiomeGenBase[])cornflowerBiomeArray, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.SAVANNA);
            cornflowerBiomeArray = (BiomeGenBase[])ArrayUtils.add((Object[])cornflowerBiomeArray, (Object)BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_76767_f.field_76756_M + 128)));
            this.cornflowerBiomes = Arrays.asList(cornflowerBiomeArray);
            this.cornflowerGen = new WorldGenFlowers(ModBlocks.CORNFLOWER.get());
            for (BiomeGenBase biome : this.cornflowerBiomes) {
                biome.addFlower(ModBlocks.CORNFLOWER.get(), 0, 5);
            }
        }
        if (ModBlocks.BAMBOO.isEnabled() && ConfigWorld.bambooWorldgen) {
            if (ModsList.BIOMES_O_PLENTY.isLoaded()) {
                BiomeDictionary.registerBiomeType((BiomeGenBase)BiomeGenBase.func_150568_d((int)21), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE});
                BiomeDictionary.registerBiomeType((BiomeGenBase)BiomeGenBase.func_150568_d((int)22), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE});
                BiomeDictionary.registerBiomeType((BiomeGenBase)BiomeGenBase.func_150568_d((int)23), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE});
                BiomeDictionary.registerBiomeType((BiomeGenBase)BiomeGenBase.func_150568_d((int)149), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE});
                BiomeDictionary.registerBiomeType((BiomeGenBase)BiomeGenBase.func_150568_d((int)151), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE});
            }
            this.bambooGen = new WorldGenBamboo(ModBlocks.BAMBOO.get());
            this.bambooBiomes = Arrays.asList(Utils.excludeBiomesFromTypesWithDefaults(BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE), new BiomeDictionary.Type[0]));
        }
        if (ModBlocks.GLOW_LICHEN.isEnabled()) {
            this.glowLichenGen = new WorldGenGlowLichen(ModBlocks.GLOW_LICHEN.get());
        }
        if (ModBlocks.CAVE_VINE.isEnabled()) {
            this.caveVineGen = new WorldGenCaveVines(ModBlocks.CAVE_VINE.get());
        }
        if (ModBlocks.CHERRY_LOG.isEnabled() && ModBlocks.LEAVES.isEnabled()) {
            BiomeGenBase[] cherryBiomeArray = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN);
            cherryBiomeArray = Utils.excludeBiomesFromTypesWithDefaults(cherryBiomeArray, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.MESA, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.JUNGLE);
            this.cherryBiomes = Arrays.asList(cherryBiomeArray);
            this.cherryTreeGen = new WorldGenCherryTrees(false);
        }
        if (ModBlocks.PINK_PETALS.isEnabled()) {
            this.pinkPetalsGen = new WorldGenPinkPetals(ModBlocks.PINK_PETALS.get());
            for (BiomeGenBase biome : this.cherryBiomes) {
                biome.addFlower(ModBlocks.PINK_PETALS.get(), 0, 1);
                biome.addFlower(ModBlocks.PINK_PETALS.get(), 4, 1);
                biome.addFlower(ModBlocks.PINK_PETALS.get(), 8, 1);
                biome.addFlower(ModBlocks.PINK_PETALS.get(), 12, 1);
            }
        }
        if (ModBlocks.MUD.isEnabled()) {
            this.mudGen = new WorldGenClay(4);
            ((WorldGenClay)this.mudGen).field_150546_a = ModBlocks.MUD.get();
            if (ModsList.BIOMES_O_PLENTY.isLoaded()) {
                BiomeDictionary.registerBiomeType((BiomeGenBase)BiomeGenBase.func_150568_d((int)6), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP});
                BiomeDictionary.registerBiomeType((BiomeGenBase)BiomeGenBase.func_150568_d((int)134), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP});
            }
            this.mudBiomes = Lists.newArrayList((Object[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
        }
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int x;
        if (!this.isFlatWorld(chunkGenerator) || world.func_72912_H().func_82571_y().contains("decoration")) {
            int zoff;
            int yoff;
            int xoff;
            int tries;
            int y;
            int z;
            if (this.amethystGen != null && ArrayUtils.contains((int[])ConfigWorld.amethystDimensionBlacklist, (int)world.field_73011_w.field_76574_g) == ConfigWorld.amethystDimensionBlacklistAsWhitelist) {
                x = (chunkX << 4) + rand.nextInt(16) + 8;
                z = (chunkZ << 4) + rand.nextInt(16) + 8;
                if (ConfigWorld.amethystRarity == 1 || rand.nextInt(ConfigWorld.amethystRarity) == 0) {
                    this.amethystGen.func_76484_a(world, rand, x, MathHelper.func_76136_a((Random)rand, (int)5, (int)(ConfigWorld.amethystMaxY - 5)), z);
                }
            }
            if (ModBlocks.COPPER_ORE.isEnabled()) {
                this.generateOre(this.copperGen, world, rand, chunkX, chunkZ, 8.0f, 4, 80);
            }
            if (ConfigWorld.enableExtraMesaGold && ArrayUtils.contains((Object[])BiomeDictionary.getTypesForBiome((BiomeGenBase)world.func_72807_a(chunkX << 4, chunkZ << 4)), (Object)BiomeDictionary.Type.MESA)) {
                this.generateOre(this.mesaGoldGen, world, rand, chunkX, chunkZ, 20.0f, 32, 80);
            }
            if (this.lilyValleyGen != null && world.func_72976_f(x = (chunkX << 4) + rand.nextInt(16) + 8, z = (chunkZ << 4) + rand.nextInt(16) + 8) > 0 && this.lilyValleyBiomes.contains(world.func_72807_a(x, z))) {
                this.lilyValleyGen.func_76484_a(world, rand, x, this.nextHeightInt(rand, world.func_72976_f(x, z) * 2), z);
            }
            if (this.cornflowerGen != null && world.func_72976_f(x = (chunkX << 4) + rand.nextInt(16) + 8, z = (chunkZ << 4) + rand.nextInt(16) + 8) > 0 && this.cornflowerBiomes.contains(world.func_72807_a(x, z))) {
                this.cornflowerGen.func_76484_a(world, rand, x, this.nextHeightInt(rand, world.func_72976_f(x, z) * 2), z);
            }
            if (this.berryBushGen != null && world.func_72976_f(x = (chunkX << 4) + rand.nextInt(16) + 8, z = (chunkZ << 4) + rand.nextInt(16) + 8) > 0 && this.berryBushBiomes.contains(world.func_72807_a(x, z))) {
                this.berryBushGen.func_76484_a(world, rand, x, this.nextHeightInt(rand, world.func_72976_f(x, z) * 2), z);
            }
            if (this.bambooGen != null && (y = world.func_72976_f(x = (chunkX << 4) + rand.nextInt(16) + 8, z = (chunkZ << 4) + rand.nextInt(16) + 8)) > 0 && this.bambooBiomes.contains(world.func_72807_a(x, z))) {
                int count = rand.nextInt(256);
                count = count < 240 ? 16 : count;
                for (int i = 0; i < count; ++i) {
                    int xoff2 = x + rand.nextInt(10) - rand.nextInt(10);
                    int yoff2 = y + rand.nextInt(4) - rand.nextInt(4);
                    int zoff2 = z + rand.nextInt(10) - rand.nextInt(10);
                    this.bambooGen.func_76484_a(world, rand, xoff2, yoff2, zoff2);
                }
            }
            if (this.glowLichenGen != null) {
                x = (chunkX << 4) + rand.nextInt(16) + 8;
                z = (chunkZ << 4) + rand.nextInt(16) + 8;
                for (tries = 0; tries < 40; ++tries) {
                    xoff = x + rand.nextInt(10) - rand.nextInt(10);
                    yoff = rand.nextInt(128);
                    zoff = z + rand.nextInt(10) - rand.nextInt(10);
                    this.glowLichenGen.func_76484_a(world, rand, xoff, yoff, zoff);
                }
            }
            if (this.caveVineGen != null) {
                x = (chunkX << 4) + rand.nextInt(16) + 8;
                z = (chunkZ << 4) + rand.nextInt(16) + 8;
                for (tries = 0; tries < 20; ++tries) {
                    xoff = x + rand.nextInt(10) - rand.nextInt(10);
                    yoff = rand.nextInt(128);
                    zoff = z + rand.nextInt(10) - rand.nextInt(10);
                    this.caveVineGen.func_76484_a(world, rand, xoff, yoff, zoff);
                }
            }
            if (this.cherryTreeGen != null) {
                x = (chunkX << 4) + rand.nextInt(16) + 8;
                z = (chunkZ << 4) + rand.nextInt(16) + 8;
                y = world.func_72976_f(x, z);
                Block block = world.func_147439_a(x, y - 1, z);
                if (y > 0 && block.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)ModBlocks.SAPLING.get())) {
                    int rng;
                    BiomeGenBase biome = world.func_72807_a(x, z);
                    int n = rng = this.cherryBiomes.contains(biome) ? ConfigWorld.cherryTreeRarity : 0;
                    if (rng > 0 && rand.nextInt(rng) == 0 && this.cherryTreeGen.func_76484_a(world, rand, x, y, z)) {
                        this.cherryTreeGen.func_150524_b(world, rand, x, y, z);
                        if (this.pinkPetalsGen != null) {
                            this.pinkPetalsGen.func_76484_a(world, rand, x, y, z);
                        }
                    }
                }
            }
            if (this.mudGen != null && (y = world.func_72976_f(x = (chunkX << 4) + rand.nextInt(16) + 8, z = (chunkZ << 4) + rand.nextInt(16) + 8)) > 0 && this.mudBiomes.contains(world.func_72807_a(x, z))) {
                this.mudGen.func_76484_a(world, rand, x, world.func_72825_h(x, z), z);
            }
            if (this.fossilGen != null && rand.nextInt(64) == 0 && ArrayUtils.contains((int[])ConfigWorld.fossilDimensionBlacklist, (int)world.field_73011_w.field_76574_g) == ConfigWorld.fossilDimensionBlacklistAsWhitelist && this.fossilBiomes.contains(world.func_72807_a(x = (chunkX << 4) + rand.nextInt(16) + 8, z = (chunkZ << 4) + rand.nextInt(16) + 8))) {
                this.fossilGen.func_76484_a(world, rand, x, MathHelper.func_76136_a((Random)rand, (int)40, (int)49), z);
            }
            if (ConfigWorld.enableOceanMonuments && ModBlocks.PRISMARINE_BLOCK.isEnabled() && ModBlocks.SEA_LANTERN.isEnabled() && !(world.field_73011_w instanceof WorldProviderEnd) && !(world.field_73011_w instanceof WorldProviderHell) && OceanMonument.canSpawnAt(world, chunkX, chunkZ)) {
                x = (chunkX << 4) + rand.nextInt(16) + 8;
                z = (chunkZ << 4) + rand.nextInt(16) + 8;
                for (y = world.func_72940_L(); y > 0 && world.func_147437_c(x, y, z); --y) {
                }
                int monumentCeiling = y - (1 + rand.nextInt(3));
                OceanMonument.buildTemple(world, x, monumentCeiling - 22, z);
                return;
            }
        }
        if (world.field_73011_w instanceof WorldProviderHell) {
            if (ModBlocks.MAGMA.isEnabled()) {
                this.generateOre(this.magmaGen, world, rand, chunkX, chunkZ, 4.0f, 23, 37);
            }
            if (ModBlocks.NETHER_GOLD_ORE.isEnabled()) {
                this.generateOre(this.netherGoldGen, world, rand, chunkX, chunkZ, 10.0f, 10, 117);
            }
            if (ModBlocks.ANCIENT_DEBRIS.isEnabled()) {
                this.generateOre(this.debrisGen, world, rand, chunkX, chunkZ, 1.0f, 8, 22);
                this.generateOre(this.smallDebrisGen, world, rand, chunkX, chunkZ, 1.0f, 8, 119);
            }
        }
        if (ModBlocks.CHORUS_PLANT.isEnabled() && ModBlocks.CHORUS_FLOWER.isEnabled() && !(world.field_73011_w instanceof WorldProviderEFREnd) && world.field_73011_w instanceof WorldProviderEnd) {
            x = (chunkX << 4) + rand.nextInt(16) + 8;
            int z = (chunkZ << 4) + rand.nextInt(16) + 8;
            for (int y = world.func_72940_L(); y > 0; --y) {
                if (world.func_147439_a(x, y, z).isAir((IBlockAccess)world, x, y, z) || !BlockChorusFlower.canPlantStay(world, x, y + 1, z)) continue;
                BlockChorusFlower.generatePlant(world, x, y + 1, z, rand, 8);
                break;
            }
        }
    }

    public void generateSingleOre(Block block, int meta, World world, Random random, int chunkX, int chunkZ, float chance, int minY, int maxY, Block generateIn) {
        if (maxY <= 0 || minY < 0 || maxY < minY || chance <= 0.0f) {
            return;
        }
        int i = 0;
        while (true) {
            int zRand;
            int yRand;
            int xRand;
            float f = i;
            float f2 = chance < 1.0f ? 1.0f : chance;
            if (!(f < f2)) break;
            if ((chance > 1.0f || random.nextFloat() < chance) && world.func_147439_a(xRand = (chunkX << 4) + random.nextInt(16), yRand = MathHelper.func_76136_a((Random)random, (int)minY, (int)maxY), zRand = (chunkZ << 4) + random.nextInt(16)).isReplaceableOreGen(world, xRand, yRand, zRand, generateIn)) {
                world.func_147465_d(xRand, yRand, zRand, block, meta, 3);
            }
            ++i;
        }
    }

    public void generateOre(WorldGenMinable gen, World world, Random random, int chunkX, int chunkZ, float chance, int minY, int maxY) {
        if (maxY <= 0 || minY < 0 || maxY < minY || gen.field_76541_b <= 0 || chance <= 0.0f) {
            return;
        }
        for (int i = 0; i < (chance < 1.0f ? 1 : (int)chance); ++i) {
            if (!(chance >= 1.0f) && !(random.nextFloat() < chance)) continue;
            int xRand = (chunkX << 4) + random.nextInt(16);
            int yRand = MathHelper.func_76136_a((Random)random, (int)minY, (int)maxY);
            int zRand = (chunkZ << 4) + random.nextInt(16);
            gen.func_76484_a(world, random, xRand, yRand, zRand);
        }
    }

    protected int nextHeightInt(Random rand, int i) {
        if (i <= 1) {
            return 1;
        }
        return rand.nextInt(i);
    }

    protected final boolean isFlatWorld(IChunkProvider chunkProvider) {
        return chunkProvider instanceof ChunkProviderFlat && !chunkProvider.getClass().getName().equals("com.rwtema.extrautils.worldgen.Underdark.ChunkProviderUnderdark");
    }
}

