/*
 * Decompiled with CFR 0.152.
 */
package makamys.mclib.updatecheck;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.util.concurrent.CompletableFuture;
import makamys.mclib.updatecheck.UpdateCheckLib;
import makamys.mclib.updatecheck.UpdateCheckTask;

public class UpdateCheckAPI {
    public static String MODS_CATEGORY_ID = "mods";
    public static String RESOURCE_PACKS_CATEGORY_ID = "resource_packs";

    public void submitModTask(String modid, String updateJSONUrl) {
        if (!UpdateCheckLib.isEnabled()) {
            return;
        }
        this.submitModTask(modid, null, updateJSONUrl);
    }

    public void submitModTask(String modid, String currentVersion, String updateJSONUrl) {
        if (!UpdateCheckLib.isEnabled()) {
            return;
        }
        ModContainer mc = (ModContainer)Loader.instance().getIndexedModList().get(modid);
        if (mc == null) {
            UpdateCheckLib.LOGGER.warn("Tried to register update check for non-existent modid: " + modid);
            return;
        }
        this.submitTask(mc.getName(), currentVersion != null ? currentVersion : mc.getVersion(), MODS_CATEGORY_ID, updateJSONUrl);
    }

    public void submitTask(String name, String currentVersion, String categoryID, String updateJSONUrl) {
        if (!UpdateCheckLib.isEnabled()) {
            return;
        }
        if (!UpdateCheckLib.categories.containsKey(categoryID)) {
            UpdateCheckLib.LOGGER.warn("Tried to register a non-existent category for mod " + name + ": " + categoryID);
        }
        UpdateCheckLib.futures.add(CompletableFuture.supplyAsync(new UpdateCheckTask(name, currentVersion, UpdateCheckLib.categories.get(categoryID), updateJSONUrl), UpdateCheckLib.executor));
    }

    public void registerCategory(String id, String version, String displayName, boolean backwardsCompatible) {
        if (!UpdateCheckLib.isEnabled()) {
            return;
        }
        if (!UpdateCheckLib.categories.containsKey(id)) {
            UpdateCheckLib.categories.put(id, new UpdateCheckLib.UpdateCategory(id, version, displayName, backwardsCompatible));
        }
    }
}

