/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.forestry.nanomachines;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IIndividual;
import java.util.Collections;
import li.cil.oc.api.Nanomachines;
import li.cil.oc.api.nanomachines.Behavior;
import li.cil.oc.api.nanomachines.Controller;
import li.cil.oc.api.prefab.AbstractProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S0BPacketAnimation;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import pl.asie.computronics.integration.forestry.IntegrationForestry;
import pl.asie.computronics.integration.forestry.nanomachines.SwarmBehavior;
import pl.asie.lib.util.RayTracer;

public class SwarmProvider
extends AbstractProvider {
    public SwarmProvider() {
        super("computronics:forestry-swarmprovider");
    }

    protected Behavior readBehaviorFromNBT(EntityPlayer player, NBTTagCompound nbt) {
        return new SwarmBehavior(player);
    }

    protected void writeBehaviorToNBT(Behavior behavior, NBTTagCompound nbt) {
    }

    public Iterable<Behavior> createBehaviors(EntityPlayer player) {
        return Collections.singletonList(new SwarmBehavior(player));
    }

    private void findTarget(EntityPlayer player, Event e) {
        SwarmBehavior behavior = this.getSwarmBehavior(player);
        if (behavior != null) {
            if (behavior.entity != null) {
                RayTracer.instance().fire((EntityLivingBase)player, 30.0);
                MovingObjectPosition target = RayTracer.instance().getTarget();
                if (target != null && target.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                    Entity entity = target.field_72308_g;
                    if (entity != null && entity instanceof EntityLivingBase && entity != behavior.entity) {
                        behavior.entity.func_70624_b((EntityLivingBase)entity);
                        SwarmProvider.swingItem(player, e);
                    }
                } else if (behavior.entity.func_70638_az() != null) {
                    behavior.entity.func_70624_b(null);
                    SwarmProvider.swingItem(player, e);
                }
            } else if (player.field_71075_bZ != null && player.field_71075_bZ.field_75098_d) {
                behavior.spawnNewEntity(player.field_70165_t, player.field_70163_u + 2.0, player.field_70161_v, BeeManager.beeRoot.getMemberStack((IIndividual)BeeManager.beeRoot.templateAsIndividual(BeeManager.beeRoot.getDefaultTemplate()), EnumBeeType.QUEEN.ordinal()));
                SwarmProvider.swingItem(player, e);
            }
        }
    }

    private void makeSwarm(double x, double y, double z, EntityPlayer player, IBeeHousing tile, Event e) {
        SwarmBehavior behavior;
        ItemStack queenStack;
        IBee member;
        if (tile.getBeekeepingLogic() != null && tile.getBeeInventory() != null && tile.getBeekeepingLogic().canDoBeeFX() && (member = BeeManager.beeRoot.getMember(queenStack = tile.getBeeInventory().getQueen())) != null && (behavior = this.getSwarmBehavior(player)) != null) {
            Controller controller;
            if (behavior.entity != null) {
                behavior.entity.func_70106_y();
            }
            if ((controller = Nanomachines.getController((EntityPlayer)player)) != null) {
                controller.changeBuffer(-10.0);
            }
            behavior.spawnNewEntity(x, y, z, member.getGenome().getPrimary().getIconColour(0), member.getGenome().getTolerantFlyer(), queenStack.func_77946_l());
            SwarmProvider.swingItem(player, e);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent e) {
        EntityPlayer player = e.entityPlayer;
        if (player != null && !player.field_70170_p.field_72995_K) {
            TileEntity te;
            ItemStack heldItem = player.func_70694_bm();
            if (heldItem != null && heldItem.func_77973_b() == IntegrationForestry.itemStickImpregnated) {
                if (e.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR) {
                    this.findTarget(player, (Event)e);
                } else if (e.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
                    if (player.func_70093_af() && e.world.func_72899_e(e.x, e.y, e.z)) {
                        TileEntity te2 = e.world.func_147438_o(e.x, e.y, e.z);
                        if (te2 instanceof IBeeHousing) {
                            this.makeSwarm((double)e.x + 0.5, (double)e.y + 0.5, (double)e.z + 0.5, player, (IBeeHousing)te2, (Event)e);
                        } else {
                            this.findTarget(player, (Event)e);
                        }
                    } else {
                        this.findTarget(player, (Event)e);
                    }
                }
            } else if (heldItem == null && e.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && player.func_70093_af() && e.world.func_72899_e(e.x, e.y, e.z) && (te = e.world.func_147438_o(e.x, e.y, e.z)) instanceof IBeeHousing) {
                this.makeSwarm((double)e.x + 0.5, (double)e.y + 0.5, (double)e.z + 0.5, player, (IBeeHousing)te, (Event)e);
            }
        }
    }

    @SubscribeEvent
    public void onMinecartInteract(MinecartInteractEvent e) {
        EntityPlayer player = e.player;
        if (player != null && !player.field_70170_p.field_72995_K) {
            ItemStack heldItem = player.func_70694_bm();
            if (heldItem != null && heldItem.func_77973_b() == IntegrationForestry.itemStickImpregnated) {
                if (player.func_70093_af() && e.minecart instanceof IBeeHousing) {
                    this.makeSwarm(e.minecart.field_70165_t, e.minecart.field_70163_u + 0.25, e.minecart.field_70161_v, player, (IBeeHousing)e.minecart, (Event)e);
                } else {
                    this.findTarget(player, (Event)e);
                }
            } else if (heldItem == null && player.func_70093_af() && e.minecart instanceof IBeeHousing) {
                this.makeSwarm(e.minecart.field_70165_t, e.minecart.field_70163_u + 0.25, e.minecart.field_70161_v, player, (IBeeHousing)e.minecart, (Event)e);
            }
        }
    }

    public static void swingItem(EntityPlayer player, Event e) {
        player.func_71038_i();
        if (player instanceof EntityPlayerMP && ((EntityPlayerMP)player).field_71135_a != null) {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S0BPacketAnimation((Entity)player, 0));
        }
        if (e != null && e.isCancelable()) {
            e.setCanceled(true);
        }
    }

    private SwarmBehavior getSwarmBehavior(EntityPlayer player) {
        Controller controller = Nanomachines.getController((EntityPlayer)player);
        if (controller != null) {
            Iterable behaviors = controller.getActiveBehaviors();
            for (Behavior behavior : behaviors) {
                if (!(behavior instanceof SwarmBehavior)) continue;
                return (SwarmBehavior)behavior;
            }
        }
        return null;
    }
}

