/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui.container.base;

import appeng.api.config.Actionable;
import appeng.api.config.CraftingAllow;
import appeng.api.config.PinsState;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.ITerminalPins;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.container.guisync.GuiSync;
import appeng.container.slot.SlotRestrictedInput;
import appeng.core.AELog;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.IPinsHandler;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.items.contents.PinsHandler;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import com.glodblock.github.client.gui.container.base.FCBaseContainer;
import com.glodblock.github.inventory.item.BaseWirelessInventory;
import com.glodblock.github.inventory.item.IWirelessTerminal;
import com.glodblock.github.network.SPacketMEUpdateBuffer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;

public abstract class FCContainerMonitor<T extends IAEStack<T>>
extends FCBaseContainer
implements IConfigManagerHost,
IConfigurableObject,
IMEMonitorHandlerReceiver<T>,
IPinsHandler {
    protected final SlotRestrictedInput[] cellView = new SlotRestrictedInput[5];
    protected final IConfigManager clientCM;
    protected final ITerminalHost host;
    protected PinsHandler pinsHandler = null;
    @GuiSync(value=99)
    public boolean canAccessViewCells = false;
    @GuiSync(value=98)
    public boolean hasPower = false;
    protected IConfigManagerHost gui;
    protected IConfigManager serverCM;
    protected IGridNode networkNode;
    protected IMEMonitor<T> monitor;
    private int lastUpdate = 0;

    public FCContainerMonitor(InventoryPlayer ip, ITerminalHost monitorable) {
        this(ip, monitorable, true);
    }

    protected FCContainerMonitor(InventoryPlayer ip, ITerminalHost monitorable, boolean bindInventory) {
        super(ip, monitorable);
        this.host = monitorable;
        this.clientCM = new ConfigManager((IConfigManagerHost)this);
        this.clientCM.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        this.clientCM.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        this.clientCM.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        this.clientCM.registerSetting(Settings.TYPE_FILTER, (Enum)TypeFilter.ALL);
        this.clientCM.registerSetting(Settings.PINS_STATE, (Enum)PinsState.DISABLED);
        if (Platform.isServer() && monitorable instanceof ITerminalPins) {
            BaseWirelessInventory bwi;
            ITerminalPins t = (ITerminalPins)monitorable;
            if (!(monitorable instanceof BaseWirelessInventory) || (bwi = (BaseWirelessInventory)monitorable).getChannel() != StorageChannel.FLUIDS) {
                this.pinsHandler = t.getPinsHandler(ip.field_70458_d);
            }
        }
    }

    public IMEMonitor<T> getMonitor() {
        return this.monitor;
    }

    public IGridNode getNetworkNode() {
        return this.networkNode;
    }

    @Override
    public void func_75142_b() {
        if (Platform.isServer()) {
            if (this.isInvalid()) {
                this.setValidContainer(false);
            }
            if (this.serverCM != null) {
                for (Settings set : this.serverCM.getSettings()) {
                    Enum sideRemote;
                    Enum sideLocal = this.serverCM.getSetting(set);
                    if (sideLocal == (sideRemote = this.clientCM.getSetting(set))) continue;
                    this.clientCM.putSetting(set, sideLocal);
                    for (Object crafter : this.field_75149_d) {
                        try {
                            NetworkHandler.instance.sendTo((AppEngPacket)new PacketValueConfig(set.name(), sideLocal.name()), (EntityPlayerMP)crafter);
                        }
                        catch (IOException e) {
                            AELog.debug((Throwable)e);
                        }
                    }
                }
            }
            if (this.pinsHandler != null) {
                if (this.clientCM.getSetting(Settings.PINS_STATE) != this.pinsHandler.getPinsState()) {
                    this.clientCM.putSetting(Settings.PINS_STATE, (Enum)this.pinsHandler.getPinsState());
                    this.updatePins(true);
                } else {
                    this.updatePins(false);
                }
            }
            this.processItemList();
            this.updatePowerStatus();
            boolean oldAccessible = this.canAccessViewCells;
            boolean bl = this.canAccessViewCells = this.host instanceof WirelessTerminalGuiObject || this.host instanceof IWirelessTerminal || this.hasAccess(SecurityPermissions.BUILD, false);
            if (this.canAccessViewCells != oldAccessible) {
                for (int y = 0; y < 5; ++y) {
                    if (this.cellView[y] == null) continue;
                    this.cellView[y].setAllowEdit(this.canAccessViewCells);
                }
            }
            super.func_75142_b();
        }
    }

    public void updatePins(boolean forceUpdate) {
        ITerminalHost iTerminalHost;
        if (this.pinsHandler == null || !((iTerminalHost = this.host) instanceof ITerminalPins)) {
            return;
        }
        ITerminalPins itp = (ITerminalPins)iTerminalHost;
        boolean isActive = this.pinsHandler.getPinsState() != PinsState.DISABLED;
        ++this.lastUpdate;
        if (!forceUpdate && this.lastUpdate <= 20) {
            return;
        }
        this.lastUpdate = 0;
        if (isActive) {
            ICraftingGrid cc = (ICraftingGrid)itp.getGrid().getCache(ICraftingGrid.class);
            ImmutableList cpuList = cc.getCpus().asList();
            ArrayList<IAEItemStack> craftedItems = new ArrayList<IAEItemStack>();
            for (int i = 0; i < cpuList.size(); ++i) {
                BaseActionSource baseActionSource;
                ICraftingCPU cpu = (ICraftingCPU)cpuList.get(i);
                if (cpu.getCraftingAllowMode() == CraftingAllow.ONLY_NONPLAYER || cpu.getFinalOutput() == null || !((baseActionSource = cpu.getCurrentJobSource()) instanceof PlayerSource)) continue;
                PlayerSource src = (PlayerSource)baseActionSource;
                if (src.player != this.pinsHandler.getPlayer() || craftedItems.contains(cpu.getFinalOutput())) continue;
                if (cpu.isBusy()) {
                    craftedItems.add(0, cpu.getFinalOutput().copy());
                    continue;
                }
                craftedItems.add(cpu.getFinalOutput().copy());
            }
            this.pinsHandler.addItemsToPins(craftedItems);
        }
        this.pinsHandler.update(forceUpdate);
        this.onListUpdate();
    }

    public void setPin(ItemStack is, int idx) {
        ITerminalHost iTerminalHost;
        if (this.pinsHandler == null || !((iTerminalHost = this.host) instanceof ITerminalPins)) {
            return;
        }
        ITerminalPins itp = (ITerminalPins)iTerminalHost;
        if (is == null) {
            ICraftingGrid cc = (ICraftingGrid)itp.getGrid().getCache(ICraftingGrid.class);
            ImmutableSet cpuSet = cc.getCpus();
            for (ICraftingCPU cpu : cpuSet) {
                if (cpu.getCraftingAllowMode() == CraftingAllow.ONLY_NONPLAYER || cpu.getFinalOutput() == null || !cpu.getFinalOutput().isSameType(this.getPin(idx))) continue;
                if (!cpu.isBusy()) {
                    cpu.resetFinalOutput();
                    continue;
                }
                return;
            }
        }
        this.pinsHandler.setPin(idx, is);
        this.updatePins(true);
    }

    public ItemStack getPin(int idx) {
        if (this.pinsHandler == null) {
            return null;
        }
        return this.pinsHandler.getPin(idx);
    }

    public void setPinsState(PinsState pinsState) {
        if (this.pinsHandler == null) {
            return;
        }
        this.clientCM.putSetting(Settings.PINS_STATE, (Enum)pinsState);
        this.pinsHandler.setPinsState(pinsState);
        this.updatePins(true);
    }

    public PinsState getPinsState() {
        return this.pinsHandler != null ? this.pinsHandler.getPinsState() : PinsState.DISABLED;
    }

    public PinsHandler getPinsHandler() {
        return this.pinsHandler;
    }

    protected abstract void processItemList();

    protected boolean isInvalid() {
        return this.monitor == null;
    }

    protected void updatePowerStatus() {
        try {
            if (this.networkNode != null) {
                this.setPowered(this.networkNode.isActive());
            } else if (this.getPowerSource() instanceof IEnergyGrid) {
                this.setPowered(((IEnergyGrid)this.getPowerSource()).isNetworkPowered());
            } else {
                this.setPowered(this.getPowerSource().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.8);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onUpdate(String field, Object oldValue, Object newValue) {
        if (field.equals("canAccessViewCells")) {
            for (int y = 0; y < 5; ++y) {
                if (this.cellView[y] == null) continue;
                this.cellView[y].setAllowEdit(this.canAccessViewCells);
            }
        }
        super.onUpdate(field, oldValue, newValue);
    }

    public void func_75132_a(ICrafting c) {
        super.func_75132_a(c);
        this.queueInventory(c);
    }

    protected abstract void queueInventory(ICrafting var1);

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.monitor != null) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
            if (player instanceof EntityPlayerMP && Platform.isServer()) {
                SPacketMEUpdateBuffer.clear((EntityPlayerMP)player);
            }
        }
    }

    public IConfigManager getConfigManager() {
        if (Platform.isServer()) {
            return this.serverCM;
        }
        return this.clientCM;
    }

    public ItemStack[] getViewCells() {
        ItemStack[] list = new ItemStack[this.cellView.length];
        for (int x = 0; x < this.cellView.length; ++x) {
            list[x] = this.cellView[x].func_75211_c();
        }
        return list;
    }

    public SlotRestrictedInput getCellViewSlot(int index) {
        return this.cellView[index];
    }

    public boolean isPowered() {
        return this.hasPower;
    }

    protected void setPowered(boolean isPowered) {
        this.hasPower = isPowered;
    }

    protected IConfigManagerHost getGui() {
        return this.gui;
    }

    public void setGui(@Nonnull IConfigManagerHost gui) {
        this.gui = gui;
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void onListUpdate() {
        for (Object c : this.field_75149_d) {
            if (!(c instanceof ICrafting)) continue;
            ICrafting cr = (ICrafting)c;
            this.queueInventory(cr);
        }
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.getGui() != null) {
            this.getGui().updateSetting(manager, settingName, newValue);
        }
    }
}

