/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.malisis.doors.door.movement.CarriageDoorMovement;
import net.malisis.doors.door.movement.CurtainMovement;
import net.malisis.doors.door.movement.DoubleRotateMovement;
import net.malisis.doors.door.movement.DoubleSlideMovement;
import net.malisis.doors.door.movement.FenceGateMovement;
import net.malisis.doors.door.movement.ForcefieldMovement;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.movement.RotateAndPlaceMovement;
import net.malisis.doors.door.movement.RotateAndSlideMovement;
import net.malisis.doors.door.movement.RotateAroundMovement;
import net.malisis.doors.door.movement.Rotating4WaysMovement;
import net.malisis.doors.door.movement.RotatingDoorMovement;
import net.malisis.doors.door.movement.RotatingSplitMovement;
import net.malisis.doors.door.movement.RustyHatchMovement;
import net.malisis.doors.door.movement.SaloonDoorMovement;
import net.malisis.doors.door.movement.Sliding4WaysMovement;
import net.malisis.doors.door.movement.SlidingDoorMovement;
import net.malisis.doors.door.movement.SlidingSplitDoorMovement;
import net.malisis.doors.door.movement.SlidingUpDoorMovement;
import net.malisis.doors.door.movement.SpinningAroundDoorMovement;
import net.malisis.doors.door.movement.SpinningDoorMovement;
import net.malisis.doors.door.movement.VanishingDoorMovement;
import net.malisis.doors.door.movement.VaultDoorMovement;
import net.malisis.doors.door.sound.CarriageDoorSound;
import net.malisis.doors.door.sound.GlassDoorSound;
import net.malisis.doors.door.sound.IDoorSound;
import net.malisis.doors.door.sound.JailDoorSound;
import net.malisis.doors.door.sound.PneumaticSound;
import net.malisis.doors.door.sound.RustyHatchSound;
import net.malisis.doors.door.sound.ShojiDoorSound;
import net.malisis.doors.door.sound.SilentDoorSound;
import net.malisis.doors.door.sound.VanillaDoorSound;
import net.malisis.doors.trapdoor.movement.SlidingTrapDoorMovement;
import net.malisis.doors.trapdoor.movement.TrapDoorMovement;

public class DoorRegistry {
    private static HashMap<String, IDoorMovement> movements = new HashMap();
    private static HashMap<String, IDoorSound> sounds = new HashMap();

    public static IDoorMovement getMovement(Class<? extends IDoorMovement> clazz) {
        for (IDoorMovement mvt : movements.values()) {
            if (!mvt.getClass().equals(clazz)) continue;
            return mvt;
        }
        throw new IllegalArgumentException(String.format("Door movement %s not found in the registry", clazz.getSimpleName()));
    }

    public static void registerMovement(String id, IDoorMovement movement) {
        if (movements.get(id) != null) {
            throw new IllegalArgumentException(String.format("Door movement %s already in registry", id));
        }
        movements.put(id, movement);
    }

    public static IDoorMovement getMovement(String id) {
        return movements.get(id);
    }

    public static String getId(IDoorMovement movement) {
        if (movement == null) {
            return null;
        }
        for (Map.Entry<String, IDoorMovement> entry : movements.entrySet()) {
            if (entry.getValue() != movement) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException(String.format("Door movement %s not found in the registry", movement.getClass().getSimpleName()));
    }

    public static Map<String, IDoorMovement> listMovements() {
        return Maps.filterValues(movements, (Predicate)new Predicate<IDoorMovement>(){

            public boolean apply(IDoorMovement input) {
                return !input.isSpecial();
            }
        });
    }

    public static IDoorSound getSound(Class<? extends IDoorSound> clazz) {
        for (IDoorSound snd : sounds.values()) {
            if (!snd.getClass().equals(clazz)) continue;
            return snd;
        }
        throw new IllegalArgumentException(String.format("Door sound %s not found in the registry", clazz.getSimpleName()));
    }

    public static void registerSound(String id, IDoorSound Sound) {
        if (sounds.get(id) != null) {
            throw new IllegalArgumentException(String.format("Door Sound %s already in registry", id));
        }
        sounds.put(id, Sound);
    }

    public static IDoorSound getSound(String id) {
        return sounds.get(id);
    }

    public static String getId(IDoorSound Sound) {
        if (Sound == null) {
            return null;
        }
        for (Map.Entry<String, IDoorSound> entry : sounds.entrySet()) {
            if (entry.getValue() != Sound) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException(String.format("Door sound %s not found in the registry", Sound.getClass().getSimpleName()));
    }

    public static Map<String, IDoorSound> listSounds() {
        return Maps.filterValues(sounds, (Predicate)new Predicate<IDoorSound>(){

            public boolean apply(IDoorSound input) {
                return !(input instanceof RustyHatchSound);
            }
        });
    }

    static {
        DoorRegistry.registerMovement("rotating_door", new RotatingDoorMovement());
        DoorRegistry.registerMovement("sliding_door", new SlidingDoorMovement());
        DoorRegistry.registerMovement("sliding_up_door", new SlidingUpDoorMovement());
        DoorRegistry.registerMovement("sliding_split_door", new SlidingSplitDoorMovement());
        DoorRegistry.registerMovement("vault_door", new VaultDoorMovement());
        DoorRegistry.registerMovement("trap_door", new TrapDoorMovement());
        DoorRegistry.registerMovement("fence_gate", new FenceGateMovement());
        DoorRegistry.registerMovement("rotating_split_door", new RotatingSplitMovement());
        DoorRegistry.registerMovement("sliding_4ways", new Sliding4WaysMovement());
        DoorRegistry.registerMovement("rotating_4ways", new Rotating4WaysMovement());
        DoorRegistry.registerMovement("rotate_around", new RotateAroundMovement());
        DoorRegistry.registerMovement("rotate_slide", new RotateAndSlideMovement());
        DoorRegistry.registerMovement("rotate_place", new RotateAndPlaceMovement());
        DoorRegistry.registerMovement("rusty_hatch", new RustyHatchMovement());
        DoorRegistry.registerMovement("curtain", new CurtainMovement());
        DoorRegistry.registerMovement("carriageDoor", new CarriageDoorMovement());
        DoorRegistry.registerMovement("forcefieldDoor", new ForcefieldMovement());
        DoorRegistry.registerMovement("vanishing_door", new VanishingDoorMovement());
        DoorRegistry.registerMovement("spinning_door", new SpinningDoorMovement());
        DoorRegistry.registerMovement("spinning_around_door", new SpinningAroundDoorMovement());
        DoorRegistry.registerMovement("double_slide_left", new DoubleSlideMovement(false));
        DoorRegistry.registerMovement("double_slide_right", new DoubleSlideMovement(true));
        DoorRegistry.registerMovement("double_rotate_left", new DoubleRotateMovement(false));
        DoorRegistry.registerMovement("double_rotate_right", new DoubleRotateMovement(true));
        DoorRegistry.registerMovement("sliding_trapdoor", new SlidingTrapDoorMovement());
        DoorRegistry.registerMovement("saloon_door", new SaloonDoorMovement());
        DoorRegistry.registerSound("silent_door", new SilentDoorSound());
        DoorRegistry.registerSound("vanilla_door", new VanillaDoorSound());
        DoorRegistry.registerSound("glass_door", new GlassDoorSound());
        DoorRegistry.registerSound("jail_door", new JailDoorSound());
        DoorRegistry.registerSound("pneumatic_door", new PneumaticSound());
        DoorRegistry.registerSound("shoji_door", new ShojiDoorSound());
        DoorRegistry.registerSound("rusty_hatch", new RustyHatchSound());
        DoorRegistry.registerSound("carriage_door", new CarriageDoorSound());
    }
}

