/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.renderer.BlockHandlerBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

@SideOnly(value=Side.CLIENT)
public abstract class BlockHandlerSloped
extends BlockHandlerBase {
    public boolean isSideSloped;
    protected int renderID = 0;
    protected float[][] ao = new float[6][4];
    protected int[][] brightness = new int[6][4];
    protected float[][] offset_ao = new float[6][4];
    protected int[][] offset_brightness = new int[6][4];

    protected final void setIDAndRender(ItemStack itemStack, int renderID, int x, int y, int z, int side) {
        this.renderID = renderID;
        this.delegateSideRender(itemStack, x, y, z, side);
    }

    protected void prepareLighting(ItemStack itemStack, int x, int y, int z) {
        for (int side = 0; side < 6; ++side) {
            this.populateLighting(itemStack, x, y, z, side);
            this.populateOffsetLighting(itemStack, x, y, z, side);
        }
    }

    private void populateLighting(ItemStack itemStack, int x, int y, int z, int side) {
        switch (side) {
            case 0: {
                this.lightingHelper.setupLightingYNeg(itemStack, x, y, z);
                break;
            }
            case 1: {
                this.lightingHelper.setupLightingYPos(itemStack, x, y, z);
                break;
            }
            case 2: {
                this.lightingHelper.setupLightingZNeg(itemStack, x, y, z);
                break;
            }
            case 3: {
                this.lightingHelper.setupLightingZPos(itemStack, x, y, z);
                break;
            }
            case 4: {
                this.lightingHelper.setupLightingXNeg(itemStack, x, y, z);
                break;
            }
            case 5: {
                this.lightingHelper.setupLightingXPos(itemStack, x, y, z);
            }
        }
        if (this.renderBlocks.field_147863_w) {
            this.ao[side][0] = this.lightingHelper.ao[0];
            this.ao[side][1] = this.lightingHelper.ao[1];
            this.ao[side][2] = this.lightingHelper.ao[2];
            this.ao[side][3] = this.lightingHelper.ao[3];
            this.brightness[side][0] = this.renderBlocks.field_147864_al;
            this.brightness[side][1] = this.renderBlocks.field_147874_am;
            this.brightness[side][2] = this.renderBlocks.field_147876_an;
            this.brightness[side][3] = this.renderBlocks.field_147870_ao;
        }
    }

    private void populateOffsetLighting(ItemStack itemStack, int x, int y, int z, int side) {
        switch (side) {
            case 0: {
                double renderTemp = this.renderBlocks.field_147855_j;
                this.renderBlocks.field_147855_j = 0.0;
                this.lightingHelper.setupLightingYNeg(itemStack, x, y + 1, z);
                this.renderBlocks.field_147855_j = renderTemp;
                break;
            }
            case 1: {
                double renderTemp = this.renderBlocks.field_147857_k;
                this.renderBlocks.field_147857_k = 1.0;
                this.lightingHelper.setupLightingYPos(itemStack, x, y - 1, z);
                this.renderBlocks.field_147857_k = renderTemp;
                break;
            }
            case 2: {
                double renderTemp = this.renderBlocks.field_147851_l;
                this.renderBlocks.field_147851_l = 0.0;
                this.lightingHelper.setupLightingZNeg(itemStack, x, y, z + 1);
                this.renderBlocks.field_147851_l = renderTemp;
                break;
            }
            case 3: {
                double renderTemp = this.renderBlocks.field_147853_m;
                this.renderBlocks.field_147853_m = 1.0;
                this.lightingHelper.setupLightingZPos(itemStack, x, y, z - 1);
                this.renderBlocks.field_147853_m = renderTemp;
                break;
            }
            case 4: {
                double renderTemp = this.renderBlocks.field_147859_h;
                this.renderBlocks.field_147859_h = 0.0;
                this.lightingHelper.setupLightingXNeg(itemStack, x + 1, y, z);
                this.renderBlocks.field_147859_h = renderTemp;
                break;
            }
            case 5: {
                double renderTemp = this.renderBlocks.field_147861_i;
                this.renderBlocks.field_147861_i = 1.0;
                this.lightingHelper.setupLightingXPos(itemStack, x - 1, y, z);
                this.renderBlocks.field_147861_i = renderTemp;
            }
        }
        if (this.renderBlocks.field_147863_w) {
            this.offset_ao[side][0] = this.lightingHelper.ao[0];
            this.offset_ao[side][1] = this.lightingHelper.ao[1];
            this.offset_ao[side][2] = this.lightingHelper.ao[2];
            this.offset_ao[side][3] = this.lightingHelper.ao[3];
            this.offset_brightness[side][0] = this.renderBlocks.field_147864_al;
            this.offset_brightness[side][1] = this.renderBlocks.field_147874_am;
            this.offset_brightness[side][2] = this.renderBlocks.field_147876_an;
            this.offset_brightness[side][3] = this.renderBlocks.field_147870_ao;
        }
    }

    abstract void renderBaseSide(int var1, int var2, int var3, int var4, IIcon var5);

    @Override
    protected final void render(int x, int y, int z, int side, IIcon icon) {
        if (this.coverRendering != 6) {
            super.render(x, y, z, side, icon);
        } else {
            this.renderBaseSide(x, y, z, side, icon);
        }
    }

    abstract void renderBaseBlock(ItemStack var1, int var2, int var3, int var4);

    @Override
    protected final void renderBlock(ItemStack itemStack, int x, int y, int z) {
        if (this.coverRendering != 6) {
            super.renderBlock(itemStack, x, y, z);
        } else {
            this.renderBaseBlock(itemStack, x, y, z);
        }
    }
}

