/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.io;

import com.jamesswafford.chess4j.exceptions.IllegalMoveException;
import com.jamesswafford.chess4j.exceptions.ParseException;
import com.jamesswafford.chess4j.io.PGNGame;
import com.jamesswafford.chess4j.io.PGNParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class PGNIterator {
    private BufferedReader br;

    public PGNIterator(InputStream is) {
        this.br = new BufferedReader(new InputStreamReader(is));
    }

    public PGNGame next() throws IOException, ParseException, IllegalMoveException {
        PGNParser parser = new PGNParser();
        String nextGame = this.getNextPGN();
        if (nextGame != null) {
            return parser.parseGame(nextGame);
        }
        return null;
    }

    public void close() {
        try {
            this.br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private String getNextPGN() throws IOException, ParseException {
        String line;
        StringBuilder sb = new StringBuilder();
        boolean foundTags = false;
        while ((line = this.br.readLine()) != null) {
            if (line.startsWith("[")) {
                foundTags = true;
                sb.append(line + "\n");
                continue;
            }
            if (!foundTags || !"".equals(line.trim())) continue;
            sb.append("\n");
            break;
        }
        if (!foundTags) {
            return null;
        }
        boolean foundMoveText = false;
        while ((line = this.br.readLine()) != null) {
            if (!"".equals(line.trim())) {
                foundMoveText = true;
                sb.append(line + "\n");
                continue;
            }
            if (!foundMoveText) continue;
        }
        if (!foundMoveText) {
            throw new ParseException("found tags but no move text");
        }
        return sb.toString();
    }
}

