/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.item;

import cpw.mods.fml.common.Loader;
import galaxyspace.GalaxySpace;
import galaxyspace.core.register.GSItems;
import java.util.List;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ItemFluidContainer;

public abstract class ItemCanisterGeneric
extends ItemFluidContainer {
    private String allowedFluid = null;
    public static final int EMPTY = 1001;
    private static boolean isTELoaded = Loader.isModLoaded((String)"ThermalExpansion");

    public ItemCanisterGeneric(String assetName) {
        super(0, 1000);
        this.func_77656_e(1001);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77655_b(assetName);
        this.func_77642_a(GSItems.BioFuelCanister);
        this.func_77637_a(GalaxySpace.tabItems);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> itemList) {
        itemList.add(new ItemStack(item, 1, 1));
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        if (isTELoaded) {
            StackTraceElement[] st = Thread.currentThread().getStackTrace();
            int imax = Math.max(st.length, 5);
            for (int i = 1; i < imax; ++i) {
                String ste = st[i].getClassName();
                if (!"thermalexpansion.block.machine.TileTransposer".equals(ste)) continue;
                return null;
            }
        }
        return new ItemStack(this.func_77668_q(), 1, 1001);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int inventoryIndex, boolean isCurrentItem) {
        if (1001 == stack.func_77960_j()) {
            if (stack.func_77973_b() != GSItems.BioFuelCanister) {
                this.replaceEmptyCanisterItem(stack, GSItems.BioFuelCanister);
            }
            stack.field_77990_d = null;
        } else if (stack.func_77960_j() <= 0) {
            stack.func_77964_b(1);
        }
    }

    public void setAllowedFluid(String name) {
        this.allowedFluid = name;
    }

    public String getAllowedFluid() {
        return this.allowedFluid;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() == null || resource.amount == 0 || container == null || container.func_77960_j() <= 1 || !(container.func_77973_b() instanceof ItemCanisterGeneric)) {
            return 0;
        }
        String fluidName = resource.getFluid().getName();
        if (container.func_77960_j() == 1001) {
            for (String key : GalacticraftCore.itemList.keySet()) {
                Item i;
                if (!key.contains("CanisterFull") || !((i = ((ItemStack)GalacticraftCore.itemList.get(key)).func_77973_b()) instanceof ItemCanisterGeneric) || !fluidName.equalsIgnoreCase(((ItemCanisterGeneric)i).allowedFluid)) continue;
                if (!doFill) {
                    return Math.min(resource.amount, this.capacity);
                }
                this.replaceEmptyCanisterItem(container, i);
                break;
            }
            container.field_77990_d = null;
        } else {
            container.field_77990_d = null;
            super.fill(container, this.getFluid(container), true);
        }
        if (fluidName.equalsIgnoreCase(((ItemCanisterGeneric)container.func_77973_b()).allowedFluid)) {
            int added = super.fill(container, resource, doFill);
            if (doFill && added > 0) {
                container.func_77964_b(Math.max(1, container.func_77960_j() - added));
            }
            return added;
        }
        return 0;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (this.allowedFluid == null || container.func_77960_j() >= 1001) {
            return null;
        }
        container.field_77990_d = null;
        super.fill(container, this.getFluid(container), true);
        FluidStack used = super.drain(container, maxDrain, doDrain);
        if (doDrain && used != null && used.amount > 0) {
            this.setNewDamage(container, container.func_77960_j() + used.amount);
        }
        return used;
    }

    protected void setNewDamage(ItemStack container, int newDamage) {
        if ((newDamage = Math.min(newDamage, 1001)) == 1001) {
            container.field_77990_d = null;
            if (container.func_77973_b() != GSItems.BioFuelCanister) {
                this.replaceEmptyCanisterItem(container, GSItems.BioFuelCanister);
                return;
            }
        }
        container.func_77964_b(newDamage);
    }

    private void replaceEmptyCanisterItem(ItemStack container, Item newItem) {
        int stackSize = container.field_77994_a;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74777_a("id", (short)Item.func_150891_b((Item)newItem));
        tag.func_74774_a("Count", (byte)stackSize);
        tag.func_74777_a("Damage", (short)1001);
        container.func_77963_c(tag);
    }

    public FluidStack getFluid(ItemStack container) {
        String fluidName = ((ItemCanisterGeneric)container.func_77973_b()).allowedFluid;
        if (fluidName == null || 1001 == container.func_77960_j()) {
            return null;
        }
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid == null) {
            return null;
        }
        return new FluidStack(fluid, 1001 - container.func_77960_j());
    }
}

