/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.FavoriteRecipes;
import codechicken.nei.ItemList;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PresetsList;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.StackInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PositionedStack {
    public int relx;
    public int rely;
    public ItemStack[] items;
    public ItemStack item;
    private boolean permutated = false;

    public PositionedStack(Object object, int x, int y, boolean genPerms) {
        this.items = NEIServerUtils.extractRecipeItems(object);
        this.relx = x;
        this.rely = y;
        if (genPerms) {
            this.generatePermutations();
        } else {
            this.setPermutationToRender(0);
        }
    }

    public PositionedStack(Object object, int x, int y) {
        this(object, x, y, true);
    }

    public void generatePermutations() {
        if (this.permutated) {
            return;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack item : this.items) {
            if (item == null || item.func_77973_b() == null) continue;
            if (item.func_77960_j() == Short.MAX_VALUE) {
                List permutations = ItemList.itemMap.get((Object)item.func_77973_b());
                if (!permutations.isEmpty()) {
                    for (ItemStack stack : permutations) {
                        ItemStack toAdd = stack.func_77946_l();
                        toAdd.field_77994_a = item.field_77994_a;
                        stacks.add(toAdd);
                    }
                    continue;
                }
                ItemStack base = new ItemStack(item.func_77973_b(), item.field_77994_a);
                base.field_77990_d = item.field_77990_d;
                stacks.add(base);
                continue;
            }
            stacks.add(item.func_77946_l());
        }
        this.items = stacks.toArray(new ItemStack[0]);
        if (this.items.length == 0) {
            this.items = new ItemStack[]{new ItemStack((Block)Blocks.field_150480_ab)};
        }
        this.permutated = true;
        this.setPermutationToRender(0);
    }

    public void setMaxSize(int i) {
        for (ItemStack item : this.items) {
            if (item.field_77994_a <= i) continue;
            item.field_77994_a = i;
        }
    }

    public PositionedStack copy() {
        PositionedStack pStack = new PositionedStack(Arrays.stream(this.items).map(ItemStack::func_77946_l).toArray(ItemStack[]::new), this.relx, this.rely, false);
        pStack.permutated = this.permutated;
        return pStack;
    }

    public List<ItemStack> getFilteredPermutations() {
        return this.getFilteredPermutations(null);
    }

    public List<ItemStack> getFilteredPermutations(ItemFilter additionalFilter) {
        List<ItemStack> items = Arrays.asList(this.items);
        items = this.filteringPermutations(items, item -> !ItemInfo.isHidden(item));
        items = this.filteringPermutations(items, PresetsList.getItemFilter());
        items = this.filteringPermutations(items, GuiRecipe.getSearchItemFilter());
        items = this.filteringPermutations(items, additionalFilter);
        items.sort(Comparator.comparing(FavoriteRecipes::contains).reversed());
        return items;
    }

    private List<ItemStack> filteringPermutations(List<ItemStack> items, ItemFilter filter) {
        if (filter == null) {
            return items;
        }
        List filteredItems = items.stream().filter(filter::matches).collect(Collectors.toList());
        return filteredItems.isEmpty() ? items : filteredItems;
    }

    public boolean setPermutationToRender(ItemStack ingredient) {
        for (int index = 0; index < this.items.length; ++index) {
            if (!NEIServerUtils.areStacksSameTypeCraftingWithNBT(this.items[index], ingredient)) continue;
            this.setPermutationToRender(index);
            return true;
        }
        return false;
    }

    public void setPermutationToRender(int index) {
        this.item = this.items[index].func_77946_l();
        if (this.item.func_77973_b() == null) {
            this.item = new ItemStack((Block)Blocks.field_150480_ab);
        } else if (this.item.func_77960_j() == Short.MAX_VALUE && this.item.func_77973_b().isRepairable()) {
            this.item.func_77964_b(0);
        }
    }

    public boolean contains(ItemStack ingredient) {
        for (ItemStack item : this.items) {
            if (!NEIServerUtils.areStacksSameTypeCrafting(item, ingredient)) continue;
            return true;
        }
        return false;
    }

    public boolean containsWithNBT(ItemStack ingredient) {
        for (ItemStack item : this.items) {
            if (!StackInfo.equalItemAndNBT(item, ingredient, true)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Item ingred) {
        for (ItemStack item : this.items) {
            if (item.func_77973_b() != ingred) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "PositionedStack(output='" + this.item.toString() + "')";
    }
}

