/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import serverutils.data.ClaimedChunks;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.math.MathUtils;
import serverutils.lib.net.MessageToServer;
import serverutils.lib.net.NetworkWrapper;
import serverutils.net.MessageClaimedChunksUpdate;
import serverutils.net.ServerUtilitiesNetHandler;

public class MessageClaimedChunksRequest
extends MessageToServer {
    private int startX;
    private int startZ;

    public MessageClaimedChunksRequest() {
    }

    public MessageClaimedChunksRequest(int sx, int sz) {
        this.startX = sx;
        this.startZ = sz;
    }

    public MessageClaimedChunksRequest(Entity entity) {
        this(MathUtils.chunk(entity.field_70165_t) - 7, MathUtils.chunk(entity.field_70161_v) - 7);
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.CLAIMS;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeVarInt(this.startX);
        data.writeVarInt(this.startZ);
    }

    @Override
    public void readData(DataIn data) {
        this.startX = data.readVarInt();
        this.startZ = data.readVarInt();
    }

    @Override
    public void onMessage(EntityPlayerMP player) {
        if (ClaimedChunks.isActive()) {
            new MessageClaimedChunksUpdate(this.startX, this.startZ, (EntityPlayer)player).sendTo(player);
        }
    }
}

