/*
 * Decompiled with CFR 0.152.
 */
package serverutils.pregenerator.filemanager;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import net.minecraft.server.MinecraftServer;
import serverutils.lib.util.misc.PregeneratorCommandInfo;
import serverutils.pregenerator.filemanager.readwriters.FileReadWriter;
import serverutils.pregenerator.filemanager.readwriters.SafeFileReadWriter;

public class PregeneratorFileManager {
    private final FileReadWriter commandReadWriter;
    private final SafeFileReadWriter iterationReadWriter;
    public static final String COMMAND_FOLDER = "pregenerationFiles";
    public static final String COMMAND_FILE = "fileCommand";
    public static final String COMMAND_ITERATION = "fileIteration";

    public PregeneratorFileManager(MinecraftServer server, double xLoc, double zLoc, int radius, int dimensionID) throws IOException {
        Path temporaryFileSaveFolder = Paths.get("saves", new String[0]).resolve(this.getWorldFolderPath(server).resolve(COMMAND_FOLDER));
        if (!Files.exists(temporaryFileSaveFolder, new LinkOption[0])) {
            Files.createDirectories(temporaryFileSaveFolder, new FileAttribute[0]);
        }
        this.iterationReadWriter = new SafeFileReadWriter(temporaryFileSaveFolder.resolve(COMMAND_ITERATION), 100);
        this.commandReadWriter = new FileReadWriter(temporaryFileSaveFolder.resolve(COMMAND_FILE));
        this.commandReadWriter.clearFile();
        this.commandReadWriter.writeDouble(xLoc);
        this.commandReadWriter.writeDouble(zLoc);
        this.commandReadWriter.writeInt(radius);
        this.commandReadWriter.writeInt(dimensionID);
        this.commandReadWriter.close();
    }

    public PregeneratorFileManager(MinecraftServer server) throws IOException {
        Path temporaryFileSaveFolder = Paths.get("saves", new String[0]).resolve(this.getWorldFolderPath(server).resolve(COMMAND_FOLDER));
        if (!Files.exists(temporaryFileSaveFolder, new LinkOption[0])) {
            Files.createDirectories(temporaryFileSaveFolder, new FileAttribute[0]);
        }
        this.iterationReadWriter = new SafeFileReadWriter(temporaryFileSaveFolder.resolve(COMMAND_ITERATION), 100);
        this.commandReadWriter = new FileReadWriter(temporaryFileSaveFolder.resolve(COMMAND_FILE));
    }

    public Optional<PregeneratorCommandInfo> getCommandInfo() {
        try {
            this.commandReadWriter.openForReading();
            this.iterationReadWriter.openForReading();
            return Optional.of(new PregeneratorCommandInfo(this.commandReadWriter.readDouble(), this.commandReadWriter.readDouble(), this.commandReadWriter.readInt(), this.commandReadWriter.readInt(), this.iterationReadWriter.readInt()));
        }
        catch (IOException iOException) {
            return Optional.empty();
        }
    }

    public void saveIteration(int iteration) {
        try {
            this.iterationReadWriter.writeAndCommitIntAfterIterations(iteration);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void closeAndRemoveAllFiles() {
        try {
            this.iterationReadWriter.close();
            this.iterationReadWriter.deleteFile();
            this.commandReadWriter.close();
            this.commandReadWriter.deleteFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void closeAllFiles() {
        try {
            this.iterationReadWriter.close();
            this.commandReadWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isReady() {
        return true;
    }

    private Path getWorldFolderPath(MinecraftServer server) {
        return Paths.get(server.func_71270_I(), new String[0]);
    }
}

