/*
 * Decompiled with CFR 0.152.
 */
package serverutils.ranks;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import serverutils.lib.config.ConfigBoolean;
import serverutils.lib.config.ConfigNull;
import serverutils.lib.config.ConfigString;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.config.RankConfigAPI;
import serverutils.lib.config.RankConfigValueInfo;
import serverutils.lib.util.FinalIDObject;
import serverutils.lib.util.StringJoiner;
import serverutils.ranks.Ranks;

public class Rank
extends FinalIDObject
implements Comparable<Rank> {
    public static final String NODE_PARENT = "parent";
    public static final String NODE_DEFAULT_PLAYER = "default_player_rank";
    public static final String NODE_DEFAULT_OP = "default_op_rank";
    public static final String NODE_PRIORITY = "priority";
    public static final String NODE_COMMAND = "command";
    @Deprecated
    public static final String NODE_POWER = "power";
    public final Ranks ranks;
    private int priority;
    protected IChatComponent displayName = new ChatComponentText(this.getId());
    protected Set<Rank> parents;
    public final Map<String, Entry> permissions;
    public String comment;

    public Rank(Ranks r, String id) {
        super(id);
        this.displayName.func_150256_b().func_150238_a(EnumChatFormatting.DARK_GREEN);
        this.ranks = r;
        this.permissions = new LinkedHashMap<String, Entry>();
        this.comment = "";
        this.priority = -1;
    }

    public int getPriority() {
        if (this.priority == -1) {
            String s = this.getLocalPermission(NODE_POWER);
            String s1 = this.getLocalPermission(NODE_PRIORITY);
            int pow = s.isEmpty() ? 0 : Integer.parseInt(s);
            int pri = s1.isEmpty() ? 0 : Integer.parseInt(s1);
            int actualPriority = Math.max(pri, pow);
            this.priority = MathHelper.func_76125_a((int)actualPriority, (int)0, (int)0x7FFFFFFE);
        }
        return this.priority;
    }

    public boolean isPlayer() {
        return false;
    }

    public void clearCache() {
        this.parents = null;
        this.priority = -1;
    }

    public IChatComponent getDisplayName() {
        return this.displayName;
    }

    public Set<Rank> getParents() {
        if (this.parents == null) {
            ArrayList<Rank> list = new ArrayList<Rank>();
            for (String s : this.getLocalPermission(NODE_PARENT).split(",")) {
                Rank r = this.ranks.getRank(s.trim());
                if (r == null || r.isPlayer()) continue;
                list.add(r);
            }
            list.sort(null);
            this.parents = new LinkedHashSet<Rank>(list);
        }
        return this.parents;
    }

    public Set<Rank> getActualParents() {
        return this.getParents();
    }

    public boolean addParent(@Nullable Rank rank) {
        if (rank == null || rank.isPlayer()) {
            return false;
        }
        this.parents = this.getParents();
        if (this.parents.add(rank)) {
            this.setPermission(NODE_PARENT, StringJoiner.with(", ").join(this.parents));
            this.parents = null;
            return true;
        }
        return false;
    }

    public boolean removeParent(Rank rank) {
        this.parents = this.getParents();
        if (this.parents.remove(rank)) {
            this.setPermission(NODE_PARENT, StringJoiner.with(", ").join(this.parents));
            this.parents = null;
            return true;
        }
        return false;
    }

    public boolean clearParents() {
        this.priority = -1;
        this.parents = null;
        return this.setPermission(NODE_PARENT, "") != null;
    }

    @Nullable
    public Entry setPermission(String node, @Nullable Object value) {
        String v;
        String string = v = value == null ? "" : value.toString();
        if (v.isEmpty()) {
            return this.permissions.remove(node);
        }
        Entry entry = this.permissions.get(node);
        if (entry != null) {
            if (!entry.value.equals(v)) {
                entry.value = v;
                return entry;
            }
            return null;
        }
        entry = new Entry(node);
        entry.value = v;
        this.permissions.put(node, entry);
        return entry;
    }

    public String getLocalPermission(String node) {
        Entry entry = this.permissions.get(node);
        return entry == null ? "" : entry.value;
    }

    public String getPermission(String node) {
        return this.getPermission(node, node, false);
    }

    public String getPermission(String originalNode, String node, boolean recursive) {
        String s = this.getLocalPermission(node);
        if (!s.isEmpty()) {
            return s;
        }
        for (Rank parent : this.getActualParents()) {
            s = parent.getPermission(node);
            if (s.isEmpty()) continue;
            return s;
        }
        if (recursive) {
            int i = node.lastIndexOf(46);
            if (i != -1) {
                return this.getPermission(originalNode, node.substring(0, i), true);
            }
            if (!node.equals("*")) {
                return this.getPermission(originalNode, "*", true);
            }
        }
        return "";
    }

    public ConfigValue getPermissionValue(String node) {
        return this.getPermissionValue(node, node, false);
    }

    public ConfigValue getPermissionValue(String originalNode, String node, boolean recursive) {
        String s = this.getPermission(originalNode, node, recursive);
        if (s.isEmpty()) {
            return ConfigNull.INSTANCE;
        }
        if (s.equals("true")) {
            return new ConfigBoolean(true);
        }
        if (s.equals("false")) {
            return new ConfigBoolean(false);
        }
        RankConfigValueInfo info = RankConfigAPI.getHandler().getInfo(originalNode);
        if (info != null) {
            ConfigValue value = info.defaultValue.copy();
            value.setValueFromString(null, s, false);
            return value;
        }
        return new ConfigString(s);
    }

    public boolean add() {
        return this.ranks.ranks.put(this.getId(), this) != this;
    }

    public boolean remove() {
        if (this.ranks.ranks.remove(this.getId()) != null) {
            for (Rank rank : this.ranks.ranks.values()) {
                rank.removeParent(this);
            }
            for (Rank rank : this.ranks.playerRanks.values()) {
                rank.removeParent(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(Rank o) {
        return Integer.compare(o.getPriority(), this.getPriority());
    }

    public boolean isDefaultPlayerRank() {
        return this.getLocalPermission(NODE_DEFAULT_PLAYER).equals("true");
    }

    public boolean isDefaultOPRank() {
        return this.getLocalPermission(NODE_DEFAULT_OP).equals("true");
    }

    public static class Entry
    implements Comparable<Entry> {
        public final String node;
        public String value = "";
        public String comment = "";

        public Entry(String n) {
            this.node = n;
        }

        @Override
        public int compareTo(Entry o) {
            return this.node.compareTo(o.node);
        }

        public String toString() {
            return this.node + ":" + this.value;
        }
    }
}

