/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils;

import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.blocks.ILittleTile;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTileBlockPos;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileSize;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import com.creativemd.littletiles.utils.InsideShiftHandler;
import com.creativemd.littletiles.utils.PreviewTile;
import com.creativemd.littletiles.utils.ShiftHandler;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PlacementHelper {
    private static PlacementHelper instance;
    public EntityPlayer player;
    public World world;

    public static PlacementHelper getInstance(EntityPlayer player) {
        if (instance == null) {
            instance = new PlacementHelper(player);
        } else {
            PlacementHelper.instance.player = player;
            PlacementHelper.instance.world = player.field_70170_p;
        }
        return instance;
    }

    public PlacementHelper(EntityPlayer player) {
        this.player = player;
        this.world = player.field_70170_p;
    }

    public static ILittleTile getLittleInterface(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.func_77973_b() instanceof ILittleTile) {
            return (ILittleTile)stack.func_77973_b();
        }
        if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof ILittleTile) {
            return (ILittleTile)Block.func_149634_a((Item)stack.func_77973_b());
        }
        return null;
    }

    public static boolean isLittleBlock(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof ILittleTile) {
            return ((ILittleTile)stack.func_77973_b()).getLittlePreview(stack) != null;
        }
        if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof ILittleTile) {
            return ((ILittleTile)Block.func_149634_a((Item)stack.func_77973_b())).getLittlePreview(stack) != null;
        }
        return false;
    }

    public static LittleTileVec getInternalOffset(ArrayList<LittleTilePreview> tiles) {
        int minX = 16;
        int minY = 16;
        int minZ = 16;
        for (LittleTilePreview tile : tiles) {
            if (tile == null) {
                return new LittleTileVec(0, 0, 0);
            }
            if (tile.box == null) continue;
            minX = (byte)Math.min(minX, tile.box.minX);
            minY = (byte)Math.min(minY, tile.box.minY);
            minZ = (byte)Math.min(minZ, tile.box.minZ);
        }
        return new LittleTileVec(minX, minY, minZ);
    }

    public static LittleTileSize getSize(ArrayList<LittleTilePreview> tiles) {
        int minX = 16;
        int minY = 16;
        int minZ = 16;
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        LittleTileSize size = new LittleTileSize(0, 0, 0);
        for (LittleTilePreview tile : tiles) {
            if (tile == null) {
                return new LittleTileSize(0, 0, 0);
            }
            if (tile.box != null) {
                minX = (byte)Math.min(minX, tile.box.minX);
                minY = (byte)Math.min(minY, tile.box.minY);
                minZ = (byte)Math.min(minZ, tile.box.minZ);
                maxX = (byte)Math.max(maxX, tile.box.maxX);
                maxY = (byte)Math.max(maxY, tile.box.maxY);
                maxZ = (byte)Math.max(maxZ, tile.box.maxZ);
                continue;
            }
            size.max(tile.size);
        }
        return new LittleTileSize(maxX - minX, maxY - minY, maxZ - minZ).max(size);
    }

    public ArrayList<PreviewTile> getPreviewTiles(ItemStack stack, LittleTileBlockPos pos, boolean customPlacement) {
        ArrayList<ShiftHandler> shifthandlers = new ArrayList<ShiftHandler>();
        ArrayList<PreviewTile> preview = new ArrayList<PreviewTile>();
        ArrayList<LittleTilePreview> tiles = null;
        ILittleTile iTile = PlacementHelper.getLittleInterface(stack);
        if (iTile != null) {
            tiles = iTile.getLittlePreview(stack);
        }
        if (tiles != null) {
            LittleTileSize size = PlacementHelper.getSize(tiles);
            if (tiles.size() == 1) {
                shifthandlers.addAll(tiles.get((int)0).shifthandlers);
            }
            shifthandlers.add(new InsideShiftHandler());
            LittleTileBox box = this.getTilesBox(size, pos);
            LittleTileVec internalOffset = PlacementHelper.getInternalOffset(tiles);
            internalOffset.invert();
            boolean canPlaceNormal = false;
            if (!customPlacement && this.player.func_70093_af()) {
                Block block;
                int x = pos.getPosX();
                int y = pos.getPosY();
                int z = pos.getPosZ();
                if (tiles.size() > 0 && tiles.get((int)0).box != null && ((block = this.world.func_147439_a(x, y, z)).isReplaceable((IBlockAccess)this.world, x, y, z) || block instanceof BlockTile)) {
                    TileEntity te = this.world.func_147438_o(x, y, z);
                    canPlaceNormal = true;
                    if (te instanceof TileEntityLittleTiles) {
                        TileEntityLittleTiles teTiles = (TileEntityLittleTiles)te;
                        for (LittleTilePreview tile : tiles) {
                            if (teTiles.isSpaceForLittleTile(tile.box)) continue;
                            canPlaceNormal = false;
                            break;
                        }
                    }
                }
                if (!canPlaceNormal) {
                    for (ShiftHandler shiftHandler : shifthandlers) {
                        shiftHandler.init(this.world, x, y, z);
                    }
                    LittleTileVec hit = pos.toHitVecRelative();
                    ShiftHandler handler = null;
                    double distance = 2.0;
                    for (ShiftHandler shifthandler : shifthandlers) {
                        double tempDistance = shifthandler.getDistance(hit);
                        if (!(tempDistance < distance)) continue;
                        distance = tempDistance;
                        handler = shifthandler;
                    }
                    if (handler != null) {
                        box = handler.getNewPosition(this.world, x, y, z, box);
                    }
                }
            }
            LittleTileVec offset = box.getMinVec();
            offset.addVec(internalOffset);
            for (LittleTilePreview tile : tiles) {
                if (tile == null) continue;
                if (tile.box == null) {
                    preview.add(new PreviewTile(box.copy(), tile));
                    continue;
                }
                if (!canPlaceNormal) {
                    tile.box.addOffset(offset);
                }
                preview.add(new PreviewTile(tile.box, tile));
            }
            LittleStructure structure = iTile.getLittleStructure(stack);
            if (structure != null) {
                ArrayList<PreviewTile> newBoxes = structure.getSpecialTiles();
                for (PreviewTile newBox : newBoxes) {
                    if (canPlaceNormal) continue;
                    newBox.box.addOffset(offset);
                }
                preview.addAll(newBoxes);
            }
        }
        return preview;
    }

    public LittleTileBox getTilesBox(LittleTileSize size, LittleTileBlockPos pos) {
        LittleTileVec hit = pos.toHitVecRelative();
        LittleTileVec center = size.calculateCenter();
        LittleTileVec centerInv = size.calculateInvertedCenter();
        switch (pos.getSide()) {
            case EAST: {
                hit.x += center.x;
                break;
            }
            case WEST: {
                hit.x -= centerInv.x - 1;
                break;
            }
            case UP: {
                hit.y += center.y;
                break;
            }
            case DOWN: {
                hit.y -= centerInv.y - 1;
                break;
            }
            case SOUTH: {
                hit.z += center.z;
                break;
            }
            case NORTH: {
                hit.z -= centerInv.z - 1;
                break;
            }
        }
        return new LittleTileBox(hit, size);
    }

    public boolean canBePlacedInsideBlock(int x, int y, int z) {
        TileEntity tileEntity = this.player.field_70170_p.func_147438_o(x, y, z);
        return tileEntity instanceof TileEntityLittleTiles;
    }
}

