/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.powergoggles.handlers;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.common.powergoggles.PowerGogglesClient;
import gregtech.common.powergoggles.PowerGogglesUtil;
import gregtech.common.powergoggles.gui.PowerGogglesGuiHudConfig;
import gregtech.common.powergoggles.handlers.PowerGogglesConfigHandler;
import gregtech.common.powergoggles.handlers.PowerGogglesKeybindHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;

public class PowerGogglesEventHandler {
    private static final PowerGogglesEventHandler INSTANCE = new PowerGogglesEventHandler();
    private final Map<UUID, PowerGogglesClient> clients = new HashMap<UUID, PowerGogglesClient>();
    private int updateTicker = 0;

    private PowerGogglesEventHandler() {
    }

    public static PowerGogglesEventHandler getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void processServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.updateTicker = (this.updateTicker + 1) % 100;
    }

    @SubscribeEvent
    public void processPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.side.isClient()) {
            return;
        }
        this.updateClient(event);
    }

    private void updateClient(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        UUID uuid = player.func_110124_au();
        if (!this.clients.containsKey(uuid)) {
            return;
        }
        if (this.updateTicker != 1) {
            return;
        }
        PowerGogglesClient client = this.clients.get(uuid);
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        client.measure(playerMP);
        client.updatePlayer(playerMP);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (PowerGogglesKeybindHandler.openConfigGui.func_151468_f()) {
            this.openConfig();
        } else if (PowerGogglesKeybindHandler.toggleChart.func_151468_f()) {
            this.toggleChart();
        }
    }

    @SubscribeEvent
    public void processPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        UUID uuid = player.func_110124_au();
        if (this.clients.containsKey(uuid)) {
            this.clients.get(player.func_110124_au()).overwriteMeasurements(player);
            return;
        }
        this.processNewClient(player);
    }

    private void processNewClient(EntityPlayerMP player) {
        ItemStack goggles = PowerGogglesUtil.getPlayerGoggles((EntityPlayer)player);
        if (goggles == null) {
            return;
        }
        this.updatePlayerLink(goggles, player);
    }

    @SideOnly(value=Side.CLIENT)
    private void openConfig() {
        Minecraft screenInfo = Minecraft.func_71410_x();
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new PowerGogglesGuiHudConfig(screenInfo.field_71443_c, screenInfo.field_71440_d));
    }

    @SideOnly(value=Side.CLIENT)
    private void toggleChart() {
        PowerGogglesConfigHandler.showPowerChart = !PowerGogglesConfigHandler.showPowerChart;
        PowerGogglesConfigHandler.config.getCategory("general").get("Show Power Chart").set(PowerGogglesConfigHandler.showPowerChart);
        PowerGogglesConfigHandler.config.save();
    }

    public void updatePlayerLink(ItemStack itemstack, EntityPlayerMP player) {
        PowerGogglesClient client = this.clients.computeIfAbsent(player.func_110124_au(), uuid -> new PowerGogglesClient());
        client.updateLscLink(itemstack, player);
    }

    public Map<UUID, PowerGogglesClient> getClients() {
        return this.clients;
    }
}

