/*
 * Decompiled with CFR 0.152.
 */
package gtnhlanth.common.tileentity;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gtnhlanth.api.recipe.LanthanidesRecipeMaps;
import gtnhlanth.util.DescTextLocalization;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEDigester
extends MTEEnhancedMultiBlockBase<MTEDigester>
implements ISurvivalConstructable {
    protected int casingAmount = 0;
    protected int height = 0;
    private HeatingCoilLevel heatLevel;
    private final IStructureDefinition<MTEDigester> multiDefinition = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"       ", " ttttt ", " t---t ", " t---t ", " t---t ", " ttttt ", "       "}, {"  ttt  ", " t---t ", "t-----t", "t-----t", "t-----t", " t---t ", "  ttt  "}, {" tccct ", "tc---ct", "c-----c", "c-----c", "c-----c", "tc---ct", " tccct "}, {" tt~tt ", "thhhhht", "thsssht", "thsssht", "thsssht", "thhhhht", " ttttt "}})).addElement('t', GTStructureUtility.buildHatchAdder(MTEDigester.class).atLeast(HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy, HatchElement.Muffler).casingIndex(47).dot(1).buildAndChain(GregTechAPI.sBlockCasings4, 0)).addElement('h', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)11)).addElement('s', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)).addElement('c', GTStructureUtility.activeCoils(GTStructureUtility.ofCoil(MTEDigester::setCoilLevel, MTEDigester::getCoilLevel))).build();

    public MTEDigester(String name) {
        super(name);
    }

    public MTEDigester(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.checkPiece(this.mName, 3, 3, 0) && !this.mMufflerHatches.isEmpty() && this.mMaintenanceHatches.size() == 1;
    }

    public HeatingCoilLevel getCoilLevel() {
        return this.heatLevel;
    }

    public void setCoilLevel(HeatingCoilLevel level) {
        this.heatLevel = level;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return LanthanidesRecipeMaps.digesterRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@Nonnull GTRecipe recipe) {
                return super.createOverclockCalculator(recipe).enablePerfectOC();
            }

            @Override
            @Nonnull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                return (long)recipe.mSpecialValue <= MTEDigester.this.getCoilLevel().getHeat() ? CheckRecipeResultRegistry.SUCCESSFUL : CheckRecipeResultRegistry.insufficientHeat(recipe.mSpecialValue);
            }
        };
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return 400;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity arg0) {
        return new MTEDigester(this.mName);
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(this.mName, itemStack, b, 3, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(this.mName, stackSize, 3, 3, 0, elementBudget, env, false, true);
    }

    @Override
    public String[] getStructureDescription(ItemStack arg0) {
        return DescTextLocalization.addText("Digester.hint", 6);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity te, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstone) {
        if (side == facing) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][47], TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][47], TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][47]};
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Digester").addInfo("Input ores and fluid, output water").addPerfectOCInfo().addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(7, 7, 4, true).addController("Front bottom").addCasingInfoExactly("Robust Tungstensteel Machine Casing", 52, false).addCasingInfoExactly("Heat Proof Machine Casing", 16, false).addCasingInfoExactly("Clean Stainless Steel Machine Casing", 9, false).addCasingInfoExactly("Coil", 16, true).addInputHatch("Hint block with dot 1").addInputBus("Hint block with dot 1").addOutputHatch("Hint block with dot 1").addOutputBus("Hint block with dot 1").addMaintenanceHatch("Hint block with dot 1").addMufflerHatch("Hint block with dot 1").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IStructureDefinition<MTEDigester> getStructureDefinition() {
        return this.multiDefinition;
    }
}

