/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.hatch;

import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.GTRecipe;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.mechanics.dataTransport.ALRecipeDataPacket;
import tectech.mechanics.pipe.IConnectsToDataPipe;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataConnector;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataItemsInput;
import tectech.thing.metaTileEntity.pipe.MTEPipeData;
import tectech.util.CommonValues;

public class MTEHatchDataItemsOutput
extends MTEHatchDataConnector<ALRecipeDataPacket> {
    private ALRecipeDataPacket previousPacket;

    public MTEHatchDataItemsOutput(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, new String[]{CommonValues.TEC_MARK_EM, StatCollector.func_74838_a((String)"gt.blockmachines.hatch.dataoutass.desc.0"), StatCollector.func_74838_a((String)"gt.blockmachines.hatch.dataoutass.desc.1"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"gt.blockmachines.hatch.dataoutass.desc.2")});
    }

    public MTEHatchDataItemsOutput(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchDataItemsOutput(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    protected ALRecipeDataPacket loadPacketFromNBT(NBTTagCompound nbt) {
        return new ALRecipeDataPacket(nbt);
    }

    @Override
    public boolean isDataInputFacing(ForgeDirection side) {
        return this.isInputFacing(side);
    }

    @Override
    public boolean canConnectData(ForgeDirection side) {
        return this.isOutputFacing(side);
    }

    @Override
    public void moveAround(IGregTechTileEntity aBaseMetaTileEntity) {
        IConnectsToDataPipe next;
        IConnectsToDataPipe current = this;
        MTEHatchDataItemsOutput source = this;
        int range = 0;
        while ((next = current.getNext(source)) != null && range++ < 1000) {
            if (next instanceof MTEHatchDataItemsInput) {
                ((MTEHatchDataItemsInput)next).setContents((ALRecipeDataPacket)this.q);
                break;
            }
            source = current;
            current = next;
        }
        this.previousPacket = (ALRecipeDataPacket)this.q;
        this.q = null;
    }

    @Override
    public IConnectsToDataPipe getNext(IConnectsToDataPipe source) {
        IGregTechTileEntity base = this.getBaseMetaTileEntity();
        byte color = base.getColorization();
        if (color < 0) {
            return null;
        }
        IGregTechTileEntity next = base.getIGregTechTileEntityAtSide(base.getFrontFacing());
        if (next == null) {
            return null;
        }
        IMetaTileEntity meta = next.getMetaTileEntity();
        if (meta instanceof MTEPipeData) {
            ((MTEPipeData)meta).markUsed();
            return (IConnectsToDataPipe)((Object)meta);
        }
        if (meta instanceof MTEHatchDataItemsInput && ((MTEHatchDataItemsInput)meta).getColorization() == color && ((MTEHatchDataItemsInput)meta).canConnectData(base.getFrontFacing().getOpposite())) {
            return (IConnectsToDataPipe)((Object)meta);
        }
        return null;
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("recipeCount", this.previousPacket == null ? 0 : ((GTRecipe.RecipeAssemblyLine[])this.previousPacket.getContent()).length);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currenttip.add(this.translate("tt.keyphrase.AL_Recipe_Transmitting", tag.func_74762_e("recipeCount")));
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> lines = new ArrayList<String>();
        if (this.previousPacket != null) {
            for (GTRecipe.RecipeAssemblyLine recipe : (GTRecipe.RecipeAssemblyLine[])this.previousPacket.getContent()) {
                lines.add(this.translate("tt.keyphrase.AL_Recipe_Desc", recipe.mOutput.func_82833_r()));
            }
        } else {
            lines.add(this.translate("tt.keyphrase.AL_Recipe_None"));
        }
        lines.sort(String::compareTo);
        lines.add(0, this.translate("tt.keyphrase.AL_Recipe_Header"));
        return lines.toArray(new String[0]);
    }
}

