/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractguis;

import java.io.IOException;
import logisticspipes.LPConstants;
import logisticspipes.LogisticsPipes;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractguis.GuiProvider;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class CoordinatesGuiProvider
extends GuiProvider {
    private int posX;
    private int posY;
    private int posZ;

    public CoordinatesGuiProvider(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        data.writeInt(this.posX);
        data.writeInt(this.posY);
        data.writeInt(this.posZ);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        this.posX = data.readInt();
        this.posY = data.readInt();
        this.posZ = data.readInt();
    }

    public CoordinatesGuiProvider setTilePos(TileEntity tile) {
        this.setPosX(tile.field_145851_c);
        this.setPosY(tile.field_145848_d);
        this.setPosZ(tile.field_145849_e);
        return this;
    }

    public <T> T getTile(World world, Class<T> clazz) {
        if (world == null) {
            return null;
        }
        if (!world.func_72899_e(this.getPosX(), this.getPosY(), this.getPosZ())) {
            if (LPConstants.DEBUG) {
                LogisticsPipes.log.fatal(this.toString());
                new RuntimeException("Couldn't find " + clazz.getName()).printStackTrace();
            }
            return null;
        }
        TileEntity tile = world.func_147438_o(this.getPosX(), this.getPosY(), this.getPosZ());
        if (tile != null) {
            if (!clazz.isAssignableFrom(tile.getClass())) {
                if (LPConstants.DEBUG) {
                    LogisticsPipes.log.fatal(this.toString());
                    new RuntimeException("Couldn't find " + clazz.getName() + ", found " + tile.getClass()).printStackTrace();
                }
                return null;
            }
        } else if (LPConstants.DEBUG) {
            LogisticsPipes.log.fatal(this.toString());
            new RuntimeException("Couldn't find " + clazz.getName()).printStackTrace();
        }
        return (T)tile;
    }

    public LogisticsTileGenericPipe getPipe(World world) {
        return this.getTile(world, LogisticsTileGenericPipe.class);
    }

    public String toString() {
        return "CoordinatesGuiProvider(posX=" + this.getPosX() + ", posY=" + this.getPosY() + ", posZ=" + this.getPosZ() + ")";
    }

    public int getPosX() {
        return this.posX;
    }

    public CoordinatesGuiProvider setPosX(int posX) {
        this.posX = posX;
        return this;
    }

    public int getPosY() {
        return this.posY;
    }

    public CoordinatesGuiProvider setPosY(int posY) {
        this.posY = posY;
        return this;
    }

    public int getPosZ() {
        return this.posZ;
    }

    public CoordinatesGuiProvider setPosZ(int posZ) {
        this.posZ = posZ;
        return this;
    }
}

