/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.keridos.floodlights.client.gui.CreativeTabFloodlight;
import de.keridos.floodlights.reference.Textures;
import de.keridos.floodlights.tileentity.TileEntityFL;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockFL
extends Block {
    protected String unlocName;
    public IIcon topIcon;
    public IIcon topOnIcon;
    public IIcon sideIcon;
    public IIcon botIcon;

    protected BlockFL(String unlocName, Material material, Block.SoundType type, float hardness) {
        super(material);
        this.func_149672_a(type);
        this.func_149711_c(hardness);
        this.func_149663_c(unlocName);
        this.unlocName = unlocName;
        if (!unlocName.equals("tilePhantomLight") && !unlocName.equals("tileUVLight")) {
            this.func_149647_a(CreativeTabFloodlight.FL_TAB);
        }
    }

    public String func_149739_a() {
        return String.format("tile.%s%s", Textures.RESOURCE_PREFIX, this.getUnwrappedUnlocalizedName(super.func_149739_a()));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.topIcon = iconRegister.func_94245_a(String.format("%s", this.getUnwrappedUnlocalizedName(this.func_149739_a() + "_top")));
        this.topOnIcon = iconRegister.func_94245_a(String.format("%s", this.getUnwrappedUnlocalizedName(this.func_149739_a() + "_top_on")));
        this.botIcon = iconRegister.func_94245_a(String.format("%s", this.getUnwrappedUnlocalizedName(this.func_149739_a() + "_bot")));
        this.sideIcon = iconRegister.func_94245_a(String.format("%s", this.getUnwrappedUnlocalizedName(this.func_149739_a() + "_side")));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == meta - 6) {
            return this.topOnIcon;
        }
        if (meta > 5) {
            meta -= 6;
        }
        if (side == meta) {
            return this.topIcon;
        }
        if (side == ForgeDirection.getOrientation((int)meta).getOpposite().ordinal()) {
            return this.botIcon;
        }
        return this.sideIcon;
    }

    protected String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(".") + 1);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public void func_149636_a(World worldIn, EntityPlayer player, int x, int y, int z, int meta) {
        super.func_149636_a(worldIn, player, x, y, z, meta);
        worldIn.func_147468_f(x, y, z);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityFL) {
            TileEntityFL tileEntityFL = (TileEntityFL)tileEntity;
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            tileEntityFL.writeOwnToNBT(nbtTagCompound);
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this), 1, 0);
            stack.func_77982_d(nbtTagCompound);
            drops.add(stack);
            return drops;
        }
        return super.getDrops(world, x, y, z, metadata, fortune);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityFL) {
            TileEntityFL tileFL = (TileEntityFL)tile;
            if (itemStack.func_77942_o()) {
                tileFL.readOwnFromNBT(itemStack.func_77978_p());
            }
            if (itemStack.func_82837_s()) {
                tileFL.setCustomName(itemStack.func_82833_r());
            }
            tileFL.setOrientation(ForgeDirection.getOrientation((int)this.getFacing(entityLiving)));
            world.func_72921_c(x, y, z, this.getFacing(entityLiving), 2);
        }
    }

    public int getFacing(EntityLivingBase entityLiving) {
        float rotationYaw = MathHelper.func_76142_g((float)entityLiving.field_70177_z);
        float rotationPitch = entityLiving.field_70125_A;
        int result = rotationPitch < -45.0f ? 1 : (rotationPitch > 45.0f ? 0 : (MathHelper.func_76128_c((double)((double)(rotationYaw * 4.0f / 360.0f) + 0.5)) & 3) + 2);
        ForgeDirection[] direction = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST};
        return direction[result].ordinal();
    }
}

